/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;

public class ArithmeticValueUpdate
extends ValueUpdate<DoubleFieldValue> {
    protected Operator operator;
    protected DoubleFieldValue operand;

    public ArithmeticValueUpdate(Operator operator, DoubleFieldValue operand) {
        super(ValueUpdate.ValueUpdateClassID.ARITHMETIC);
        this.operator = operator;
        this.operand = operand;
    }

    public ArithmeticValueUpdate(Operator operator, Number operand) {
        this(operator, new DoubleFieldValue(operand.doubleValue()));
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Number getOperand() {
        return this.operand.getDouble();
    }

    @Override
    public DoubleFieldValue getValue() {
        return this.operand;
    }

    @Override
    public void setValue(DoubleFieldValue value) {
        this.operand = value;
    }

    @Override
    public FieldValue applyTo(FieldValue oldValue) {
        if (!(oldValue instanceof NumericFieldValue)) {
            throw new IllegalStateException("Cannot use arithmetic value update on non-numeric datatype " + oldValue.getClass().getName());
        }
        Number number = (Number)oldValue.getWrappedValue();
        oldValue.assign(this.calculate(number));
        return oldValue;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof NumericDataType)) {
            throw new UnsupportedOperationException("Expected numeric type, got " + fieldType.getName() + ".");
        }
    }

    private double calculate(Number operand2) {
        switch (this.operator) {
            case ADD: {
                return operand2.doubleValue() + this.operand.getDouble();
            }
            case DIV: {
                return operand2.doubleValue() / this.operand.getDouble();
            }
            case MUL: {
                return operand2.doubleValue() * this.operand.getDouble();
            }
            case SUB: {
                return operand2.doubleValue() - this.operand.getDouble();
            }
        }
        return 0.0;
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ArithmeticValueUpdate && super.equals(o) && this.operator == ((ArithmeticValueUpdate)o).operator && this.operand.equals(((ArithmeticValueUpdate)o).operand);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.operator.hashCode() + this.operand.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.operator.name + " " + this.operand;
    }

    public static enum Operator {
        ADD(0, "add"),
        DIV(1, "divide"),
        MUL(2, "multiply"),
        SUB(3, "subtract");

        public final int id;
        public final String name;

        private Operator(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Operator getID(int id) {
            for (Operator operator : Operator.values()) {
                if (operator.id != id) continue;
                return operator;
            }
            return null;
        }
    }
}

