/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.io.HexDump;
import com.yahoo.vespa.objects.FieldBase;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;

public final class Raw
extends FieldValue {
    public static final int classId = Raw.registerClass((int)4112, Raw.class);
    private ByteBuffer value;

    public Raw() {
        this.value = null;
    }

    public Raw(ByteBuffer value) {
        this.value = value;
    }

    public Raw(byte[] buf) {
        this.value = ByteBuffer.wrap(buf);
        this.value.position(0);
    }

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public ByteBuffer getByteBuffer() {
        return this.value;
    }

    @Override
    public Raw clone() {
        Raw raw = (Raw)super.clone();
        if (this.value.hasArray()) {
            raw.value = ByteBuffer.wrap(Arrays.copyOf(this.value.array(), this.value.array().length));
            raw.value.position(this.value.position());
        } else {
            byte[] copyBuf = new byte[this.value.capacity()];
            int origPos = this.value.position();
            this.value.position(0);
            this.value.get(copyBuf);
            this.value.position(origPos);
            raw.value = ByteBuffer.wrap(copyBuf);
            raw.value.position(this.value.position());
        }
        return raw;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    public void clear() {
        this.value = ByteBuffer.wrap(new byte[0]);
    }

    @Override
    public void assign(Object o) {
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof Raw) {
            this.value = ((Raw)o).value;
        } else if (o instanceof ByteBuffer) {
            this.value = (ByteBuffer)o;
        } else if (o instanceof byte[]) {
            ByteBuffer byteBufVal = ByteBuffer.wrap((byte[])o);
            byteBufVal.position(0);
            this.value = byteBufVal;
        } else {
            throw new IllegalArgumentException("Class " + o.getClass() + " not applicable to an " + this.getClass() + " instance.");
        }
    }

    @Override
    public DataType getDataType() {
        return DataType.RAW;
    }

    @Override
    @Deprecated
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printRawXml(this, xml);
    }

    public String toString() {
        ByteBuffer buf = this.value.slice();
        byte[] arr = new byte[buf.remaining()];
        buf.get(arr);
        return HexDump.toHexString((byte[])arr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Raw)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Raw raw = (Raw)o;
        return !(this.value != null ? !this.value.equals(raw.value) : raw.value != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new Raw();
        }

        @Override
        public FieldValue create(String value) {
            return new Raw(Base64.getMimeDecoder().decode(value));
        }
    }
}

