/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.DummySpanNode;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.datatypes.FieldValue;

public class Annotation
implements Comparable<Annotation> {
    private AnnotationType type;
    private SpanNode spanNode = null;
    private FieldValue value = null;
    private int scratchId = -1;

    public void setScratchId(int id) {
        this.scratchId = id;
    }

    public int getScratchId() {
        return this.scratchId;
    }

    public Annotation() {
    }

    public Annotation(AnnotationType type) {
        this.type = type;
    }

    public Annotation(Annotation other) {
        this.type = other.type;
        this.value = other.value == null ? null : other.value.clone();
    }

    public Annotation(AnnotationType type, FieldValue value) {
        this(type);
        this.setFieldValue(value);
    }

    public AnnotationType getType() {
        return this.type;
    }

    public void setType(AnnotationType type) {
        this.type = type;
    }

    public boolean hasSpanNode() {
        return this.spanNode != null;
    }

    public boolean isSpanNodeValid() {
        return this.spanNode != null && this.spanNode.isValid();
    }

    public SpanNode getSpanNode() {
        if (this.spanNode != null && !this.spanNode.isValid()) {
            throw new IllegalStateException("Span node is invalid: " + this.spanNode);
        }
        return this.spanNode;
    }

    public final SpanNode getSpanNodeFast() {
        return this.spanNode;
    }

    public void setSpanNode(SpanNode spanNode) {
        if (this.spanNode != null && spanNode != null) {
            throw new IllegalStateException("WARNING! " + this + " is already attached to node " + this.spanNode + ". Attempt to attach to node " + spanNode + ". Annotation instances MUST NOT be shared among SpanNodes.");
        }
        if (spanNode != null && !spanNode.isValid()) {
            throw new IllegalStateException("Span node is invalid: " + spanNode);
        }
        if (spanNode == DummySpanNode.INSTANCE) {
            throw new IllegalStateException("BUG! Annotations should never be attached to DummySpanNode.");
        }
        this.spanNode = spanNode;
    }

    public final void setSpanNodeFast(SpanNode spanNode) {
        this.spanNode = spanNode;
    }

    public FieldValue getFieldValue() {
        return this.value;
    }

    public void setFieldValue(FieldValue fieldValue) {
        if (fieldValue == null) {
            this.value = null;
            return;
        }
        DataType type = this.getType().getDataType();
        if (type == null || !type.isValueCompatible(fieldValue)) {
            String typeName = type == null ? "null" : type.getValueClass().getName();
            throw new IllegalArgumentException("Argument is of wrong type, must be of type " + typeName + ", was " + fieldValue.getClass().getName());
        }
        this.value = fieldValue;
    }

    public boolean hasFieldValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation that = (Annotation)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.spanNode != null ? !this.spanNode.equals(that.spanNode) : that.spanNode != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.spanNode != null ? this.spanNode.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.toString().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.type + " annotation " + (this.value == null ? " (no value)" : " (with value)") + (String)(this.spanNode == null ? " (no span)" : " with span " + this.spanNode);
    }

    @Override
    public int compareTo(Annotation annotation) {
        int comp;
        if (this.spanNode == null) {
            comp = annotation.spanNode == null ? 0 : -1;
        } else {
            int n = comp = annotation.spanNode == null ? 1 : this.spanNode.compareTo(annotation.spanNode);
        }
        if (comp != 0) {
            return comp;
        }
        comp = this.type.compareTo(annotation.type);
        if (comp != 0) {
            return comp;
        }
        comp = this.value == null ? (annotation.value == null ? 0 : -1) : (annotation.value == null ? 1 : this.value.compareTo(annotation.value));
        return comp;
    }
}

