/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TokenBuffer {
    private final List<Token> tokens;
    private int position = 0;
    private int nesting = 0;

    public TokenBuffer() {
        this(new ArrayList<Token>());
    }

    public TokenBuffer(List<Token> tokens) {
        this.tokens = tokens;
        if (tokens.size() > 0) {
            this.updateNesting(tokens.get((int)this.position).token);
        }
    }

    public boolean isEmpty() {
        return this.remaining() == 0;
    }

    public JsonToken previous() {
        this.updateNestingGoingBackwards(this.current());
        --this.position;
        return this.current();
    }

    public JsonToken current() {
        if (this.isEmpty()) {
            return null;
        }
        Token token = this.tokens.get(this.position);
        if (token == null) {
            return null;
        }
        return token.token;
    }

    public JsonToken next() {
        ++this.position;
        JsonToken token = this.current();
        this.updateNesting(token);
        return token;
    }

    public JsonToken peek(int ahead) {
        if (this.tokens.size() <= this.position + ahead) {
            return null;
        }
        return this.tokens.get((int)(this.position + ahead)).token;
    }

    public String currentName() {
        if (this.isEmpty()) {
            return null;
        }
        Token token = this.tokens.get(this.position);
        if (token == null) {
            return null;
        }
        return token.name;
    }

    public String currentText() {
        if (this.isEmpty()) {
            return null;
        }
        Token token = this.tokens.get(this.position);
        if (token == null) {
            return null;
        }
        return token.text;
    }

    public int remaining() {
        return this.tokens.size() - this.position;
    }

    private void add(JsonToken token, String name, String text) {
        this.tokens.add(this.tokens.size(), new Token(token, name, text));
    }

    public void bufferObject(JsonToken first, JsonParser tokens) {
        this.bufferJsonStruct(first, tokens, JsonToken.START_OBJECT);
    }

    private void bufferJsonStruct(JsonToken first, JsonParser tokens, JsonToken firstToken) {
        int localNesting = 0;
        JsonToken t = first;
        Preconditions.checkArgument((first == firstToken ? 1 : 0) != 0, (String)"Expected %s, got %s.", (Object)firstToken.name(), (Object)t);
        if (this.remaining() == 0) {
            this.updateNesting(t);
        }
        localNesting = this.storeAndPeekNesting(t, localNesting, tokens);
        while (localNesting > 0) {
            t = this.nextValue(tokens);
            localNesting = this.storeAndPeekNesting(t, localNesting, tokens);
        }
    }

    private int storeAndPeekNesting(JsonToken t, int nesting, JsonParser tokens) {
        this.addFromParser(t, tokens);
        return nesting + this.nestingOffset(t);
    }

    private int nestingOffset(JsonToken token) {
        if (token == null) {
            return 0;
        }
        if (token.isStructStart()) {
            return 1;
        }
        if (token.isStructEnd()) {
            return -1;
        }
        return 0;
    }

    private void addFromParser(JsonToken t, JsonParser tokens) {
        try {
            this.add(t, tokens.getCurrentName(), tokens.getText());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private JsonToken nextValue(JsonParser tokens) {
        try {
            return tokens.nextValue();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void updateNesting(JsonToken token) {
        this.nesting += this.nestingOffset(token);
    }

    private void updateNestingGoingBackwards(JsonToken token) {
        this.nesting -= this.nestingOffset(token);
    }

    public int nesting() {
        return this.nesting;
    }

    public void skipToRelativeNesting(int relativeNesting) {
        int initialNesting = this.nesting();
        do {
            this.next();
        } while (this.nesting() > initialNesting + relativeNesting);
    }

    public List<Token> rest() {
        return this.tokens.subList(this.position, this.tokens.size());
    }

    public static final class Token {
        public final JsonToken token;
        public final String name;
        public final String text;

        Token(JsonToken token, String name, String text) {
            this.token = token;
            this.name = name;
            this.text = text;
        }

        public String toString() {
            return "Token(" + this.token + ", " + this.name + ", " + this.text + ")";
        }
    }
}

