/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;

public class SimpleDocument {
    private final Document document;

    public SimpleDocument(Document document) {
        this.document = document;
    }

    public final Object get(Field field) {
        return SimpleDocument.get(this.document, field);
    }

    public final Object get(String fieldName) {
        return SimpleDocument.get(this.document, this.document.getField(fieldName));
    }

    public final Object set(Field field, Object value) {
        return SimpleDocument.set(this.document, field, value);
    }

    public final Object set(String fieldName, Object value) {
        return this.set(this.document.getField(fieldName), value);
    }

    public final Object remove(Field field) {
        return SimpleDocument.remove(this.document, field);
    }

    public final Object remove(String fieldName) {
        return this.remove(this.document.getField(fieldName));
    }

    public static Object get(StructuredFieldValue struct, Field field) {
        return field == null ? null : SimpleDocument.unwrapValue(struct.getFieldValue(field));
    }

    public static Object set(StructuredFieldValue struct, Field field, Object value) {
        return SimpleDocument.unwrapValue(struct.setFieldValue(field, SimpleDocument.wrapValue(field.getDataType(), value)));
    }

    public static Object remove(StructuredFieldValue struct, Field field) {
        return field == null ? null : SimpleDocument.unwrapValue(struct.removeFieldValue(field));
    }

    private static FieldValue wrapValue(DataType type, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof FieldValue) {
            return (FieldValue)val;
        }
        FieldValue ret = type.createFieldValue();
        ret.assign(val);
        return ret;
    }

    private static Object unwrapValue(FieldValue val) {
        if (val == null) {
            return null;
        }
        return val.getWrappedValue();
    }
}

