/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentId;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.internal.GeoPosType;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.vespa.objects.FieldBase;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;

public class JsonSerializationHelper {
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();

    static void wrapIOException(SubroutineThrowingIOException lambda) {
        try {
            lambda.invoke();
        }
        catch (IOException e) {
            throw new JsonSerializationException(e);
        }
    }

    public static void serializeTensorField(JsonGenerator generator, FieldBase field, TensorFieldValue value, boolean shortForm, boolean directValues) {
        JsonSerializationHelper.wrapIOException(() -> {
            JsonSerializationHelper.fieldNameIfNotNull(generator, field);
            if (value.getTensor().isPresent()) {
                Tensor tensor = value.getTensor().get();
                byte[] encoded = JsonFormat.encode((Tensor)tensor, (boolean)shortForm, (boolean)directValues);
                generator.writeRawValue(new String(encoded, StandardCharsets.UTF_8));
            } else {
                generator.writeStartObject();
                generator.writeEndObject();
            }
        });
    }

    static void serializeTensorCells(JsonGenerator generator, Tensor tensor) throws IOException {
        generator.writeArrayFieldStart("cells");
        for (Map.Entry cell : tensor.cells().entrySet()) {
            generator.writeStartObject();
            JsonSerializationHelper.serializeTensorAddress(generator, (TensorAddress)cell.getKey(), tensor.type());
            generator.writeNumberField("value", ((Double)cell.getValue()).doubleValue());
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    static void serializeTensorAddresses(JsonGenerator generator, Tensor tensor) throws IOException {
        TensorType tensorType = tensor.type();
        generator.writeArrayFieldStart("addresses");
        for (Map.Entry cell : tensor.cells().entrySet()) {
            generator.writeStartObject();
            for (int i = 0; i < tensorType.dimensions().size(); ++i) {
                generator.writeStringField(((TensorType.Dimension)tensorType.dimensions().get(i)).name(), ((TensorAddress)cell.getKey()).label(i));
            }
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    private static void serializeTensorAddress(JsonGenerator generator, TensorAddress address, TensorType type) throws IOException {
        generator.writeObjectFieldStart("address");
        for (int i = 0; i < type.dimensions().size(); ++i) {
            generator.writeStringField(((TensorType.Dimension)type.dimensions().get(i)).name(), address.label(i));
        }
        generator.writeEndObject();
    }

    public static void serializeReferenceField(JsonGenerator generator, FieldBase field, ReferenceFieldValue value) {
        JsonSerializationHelper.wrapIOException(() -> {
            JsonSerializationHelper.fieldNameIfNotNull(generator, field);
            generator.writeString(value.getDocumentId().map(DocumentId::toString).orElse(""));
        });
    }

    public static void serializeStringField(JsonGenerator generator, FieldBase field, StringFieldValue value) {
        if (value.getString().length() == 0 && field != null) {
            return;
        }
        JsonSerializationHelper.serializeString(generator, field, value.getString());
    }

    public static void serializeStructuredField(FieldWriter fieldWriter, JsonGenerator generator, FieldBase field, StructuredFieldValue value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> {
            generator.writeStartObject();
            Iterator<Map.Entry<Field, FieldValue>> i = value.iterator();
            while (i.hasNext()) {
                Map.Entry<Field, FieldValue> entry = i.next();
                entry.getValue().serialize(entry.getKey(), fieldWriter);
            }
            generator.writeEndObject();
        });
    }

    private static void serializeGeoPos(JsonGenerator generator, FieldBase field, Struct value, GeoPosType dataType) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> {
            generator.writeStartObject();
            generator.writeFieldName("lat");
            generator.writeRawValue(dataType.fmtLatitude(value));
            generator.writeFieldName("lng");
            generator.writeRawValue(dataType.fmtLongitude(value));
            generator.writeEndObject();
        });
    }

    public static void serializeStructField(FieldWriter fieldWriter, JsonGenerator generator, FieldBase field, Struct value) {
        GeoPosType gpt;
        StructDataType dt = value.getDataType();
        if (dt instanceof GeoPosType && (gpt = (GeoPosType)dt).renderJsonAsVespa8()) {
            JsonSerializationHelper.serializeGeoPos(generator, field, value, gpt);
            return;
        }
        JsonSerializationHelper.serializeStructuredField(fieldWriter, generator, field, value);
    }

    public static <T extends FieldValue> void serializeWeightedSet(JsonGenerator generator, FieldBase field, WeightedSet<T> value) {
        if (value.size() == 0) {
            return;
        }
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> {
            generator.writeStartObject();
            for (FieldValue key : value.keySet()) {
                Integer weight = value.get(key);
                generator.writeNumberField(key.toString(), weight.intValue());
            }
            generator.writeEndObject();
        });
    }

    public static <T extends FieldValue> void serializeCollectionField(FieldWriter fieldWriter, JsonGenerator generator, FieldBase field, CollectionFieldValue<T> value) {
        if (value.size() == 0) {
            return;
        }
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> {
            generator.writeStartArray();
            Iterator i = value.iterator();
            while (i.hasNext()) {
                ((FieldValue)i.next()).serialize(null, fieldWriter);
            }
            generator.writeEndArray();
        });
    }

    public static <K extends FieldValue, V extends FieldValue> void serializeMapField(FieldWriter fieldWriter, JsonGenerator generator, FieldBase field, MapFieldValue<K, V> map) {
        if (map.size() == 0) {
            return;
        }
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> {
            generator.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                FieldValue key = (FieldValue)entry.getKey();
                DataType keyType = key.getDataType();
                if (!(keyType instanceof PrimitiveDataType)) {
                    throw new IllegalArgumentException("Can't use complex types as keys for map fields. Type: " + keyType);
                }
                generator.writeFieldName(key.toString());
                ((FieldValue)entry.getValue()).serialize(null, fieldWriter);
            }
            generator.writeEndObject();
        });
    }

    public static <T extends FieldValue> void serializeArrayField(FieldWriter fieldWriter, JsonGenerator generator, FieldBase field, Array<T> value) {
        if (value.size() == 0) {
            return;
        }
        JsonSerializationHelper.wrapIOException(() -> {
            JsonSerializationHelper.fieldNameIfNotNull(generator, field);
            generator.writeStartArray();
            for (FieldValue elem : value) {
                elem.serialize(null, fieldWriter);
            }
            generator.writeEndArray();
        });
    }

    public static void serializeDoubleField(JsonGenerator generator, FieldBase field, DoubleFieldValue value) {
        JsonSerializationHelper.serializeDouble(generator, field, value.getDouble());
    }

    public static void serializeFloatField(JsonGenerator generator, FieldBase field, FloatFieldValue value) {
        JsonSerializationHelper.serializeFloat(generator, field, value.getFloat());
    }

    public static void serializeIntField(JsonGenerator generator, FieldBase field, IntegerFieldValue value) {
        JsonSerializationHelper.serializeInt(generator, field, value.getInteger());
    }

    public static void serializeLongField(JsonGenerator generator, FieldBase field, LongFieldValue value) {
        JsonSerializationHelper.serializeLong(generator, field, value.getLong());
    }

    public static void serializeByteField(JsonGenerator generator, FieldBase field, ByteFieldValue value) {
        JsonSerializationHelper.serializeByte(generator, field, value.getByte());
    }

    public static void serializeBoolField(JsonGenerator generator, FieldBase field, BoolFieldValue value) {
        JsonSerializationHelper.serializeBool(generator, field, value.getBoolean());
    }

    public static void serializePredicateField(JsonGenerator generator, FieldBase field, PredicateFieldValue value) {
        JsonSerializationHelper.serializeString(generator, field, value.toString());
    }

    public static void serializeRawField(JsonGenerator generator, FieldBase field, Raw raw) {
        JsonSerializationHelper.serializeByteBuffer(generator, field, raw.getByteBuffer());
    }

    public static void serializeString(JsonGenerator generator, FieldBase field, String value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeString(value));
    }

    public static void serializeByte(JsonGenerator generator, FieldBase field, byte value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeNumber((short)value));
    }

    public static void serializeBool(JsonGenerator generator, FieldBase field, boolean value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeBoolean(value));
    }

    public static void serializeShort(JsonGenerator generator, FieldBase field, short value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeNumber(value));
    }

    public static void serializeInt(JsonGenerator generator, FieldBase field, int value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeNumber(value));
    }

    public static void serializeLong(JsonGenerator generator, FieldBase field, long value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeNumber(value));
    }

    public static void serializeFloat(JsonGenerator generator, FieldBase field, float value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeNumber(value));
    }

    public static void serializeDouble(JsonGenerator generator, FieldBase field, double value) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        JsonSerializationHelper.wrapIOException(() -> generator.writeNumber(value));
    }

    public static void serializeByteBuffer(JsonGenerator generator, FieldBase field, ByteBuffer raw) {
        JsonSerializationHelper.fieldNameIfNotNull(generator, field);
        byte[] data = new byte[raw.remaining()];
        int origPosition = raw.position();
        raw.get(data);
        raw.position(origPosition);
        JsonSerializationHelper.wrapIOException(() -> generator.writeString(base64Encoder.encodeToString(data)));
    }

    public static void serializeByteArray(JsonGenerator generator, FieldBase field, byte[] value) {
        JsonSerializationHelper.serializeByteBuffer(generator, field, ByteBuffer.wrap(value));
    }

    public static void fieldNameIfNotNull(JsonGenerator generator, FieldBase field) {
        if (field != null) {
            JsonSerializationHelper.wrapIOException(() -> generator.writeFieldName(field.getName()));
        }
    }

    @FunctionalInterface
    static interface SubroutineThrowingIOException {
        public void invoke() throws IOException;
    }

    static class JsonSerializationException
    extends RuntimeException {
        public JsonSerializationException(Exception base) {
            super(base);
        }

        public JsonSerializationException(String message) {
            super(message);
        }
    }
}

