/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.SingleValueReader;
import java.util.List;

public class ArrayReader {
    public static void fillArrayUpdate(TokenBuffer buffer, int initNesting, DataType valueType, List<FieldValue> arrayContents) {
        while (buffer.nesting() >= initNesting) {
            Preconditions.checkArgument((buffer.currentToken() != JsonToken.VALUE_NULL ? 1 : 0) != 0, (Object)"Illegal null value for array entry");
            arrayContents.add(SingleValueReader.readSingleValue(buffer, valueType));
            buffer.next();
        }
    }

    public static void fillArray(TokenBuffer buffer, CollectionFieldValue parent, DataType valueType) {
        int initNesting = buffer.nesting();
        JsonParserHelpers.expectArrayStart(buffer.currentToken());
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            Preconditions.checkArgument((buffer.currentToken() != JsonToken.VALUE_NULL ? 1 : 0) != 0, (Object)"Illegal null value for array entry");
            parent.add(SingleValueReader.readSingleValue(buffer, valueType));
            buffer.next();
        }
    }
}

