/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.json.JsonWriter;
import com.yahoo.document.serialization.DocumentReader;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.SerializationException;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.vespa.objects.FieldBase;
import com.yahoo.vespa.objects.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

public class Document
extends StructuredFieldValue {
    public static final int classId = Document.registerClass((int)4099, Document.class);
    public static final short SERIALIZED_VERSION = 8;
    private DocumentId docId;
    private Struct header;
    private Struct body;
    private Long lastModified = null;

    public Document(DocumentType docType, String id) {
        this(docType, new DocumentId(id));
    }

    public Document(DocumentType docType, DocumentId id) {
        super(docType);
        this.setNewType(docType);
        this.internalSetId(id, docType);
    }

    public Document(Document doc) {
        this(doc.getDataType(), doc.getId());
        this.header = doc.header;
        this.body = doc.body;
        this.lastModified = doc.lastModified;
    }

    public Document(DocumentReader reader) {
        super(null);
        reader.read(this);
    }

    public DocumentId getId() {
        return this.docId;
    }

    public void setId(DocumentId id) {
        this.internalSetId(id, this.getDataType());
    }

    private void internalSetId(DocumentId id, DocumentType docType) {
        if (id != null && id.hasDocType() && docType != null && !id.getDocType().equals(docType.getName())) {
            throw new IllegalArgumentException("Trying to set a document id (type " + id.getDocType() + ") that doesn't match the document type (" + this.getDataType().getName() + ").");
        }
        this.docId = id;
    }

    @Deprecated
    public Struct getHeader() {
        return this.header;
    }

    @Deprecated
    public Struct getBody() {
        return this.body;
    }

    @Override
    public void assign(Object o) {
        throw new IllegalArgumentException("Assign not implemented for " + this.getClass() + " objects");
    }

    @Override
    public Document clone() {
        Document doc = (Document)super.clone();
        doc.docId = this.docId.clone();
        doc.header = this.header.clone();
        doc.body = this.body.clone();
        return doc;
    }

    private void setNewType(DocumentType type) {
        this.header = type.contentStruct().createFieldValue();
        this.body = type.getBodyType().createFieldValue();
    }

    @Override
    public void setDataType(DataType type) {
        if (this.docId != null && this.docId.hasDocType() && !this.docId.getDocType().equals(type.getName())) {
            throw new IllegalArgumentException("Trying to set a document type (" + type.getName() + ") that doesn't match the document id (" + this.docId + ").");
        }
        super.setDataType(type);
        this.setNewType((DocumentType)type);
    }

    public int getSerializedSize() throws SerializationException {
        DocumentSerializer data = DocumentSerializerFactory.create6(new GrowableByteBuffer(65536, 2.0f));
        data.write(this);
        return data.getBuf().position();
    }

    public final int getApproxSize() {
        return 4096;
    }

    public void serialize(OutputStream out) throws SerializationException {
        byte[] array;
        DocumentSerializer writer = DocumentSerializerFactory.create6(new GrowableByteBuffer(65536, 2.0f));
        writer.write(this);
        GrowableByteBuffer data = writer.getBuf();
        if (data.hasArray()) {
            array = data.array();
        } else {
            array = new byte[data.position()];
            int endPos = data.position();
            data.position(0);
            data.get(array);
            data.position(endPos);
        }
        try {
            out.write(array, 0, data.position());
        }
        catch (IOException ioe) {
            throw new SerializationException(ioe);
        }
    }

    public static Document createDocument(DocumentReader buffer) {
        return new Document(buffer);
    }

    @Override
    public Field getField(String fieldName) {
        Field field;
        block2: {
            DocumentType parent;
            field = this.header.getField(fieldName);
            if (field == null) {
                field = this.body.getField(fieldName);
            }
            if (field != null) break block2;
            Iterator<DocumentType> iterator = this.getDataType().getInheritedTypes().iterator();
            while (iterator.hasNext() && (field = (parent = iterator.next()).getField(fieldName)) == null) {
            }
        }
        return field;
    }

    @Override
    public FieldValue getFieldValue(Field field) {
        FieldValue fv = this.header.getFieldValue(field);
        if (fv == null) {
            fv = this.body.getFieldValue(field);
        }
        return fv;
    }

    @Override
    protected void doSetFieldValue(Field field, FieldValue value) {
        if (field.isHeader()) {
            this.header.setFieldValue(field, value);
        } else {
            this.body.setFieldValue(field, value);
        }
    }

    @Override
    public FieldValue removeFieldValue(Field field) {
        FieldValue removed = this.header.removeFieldValue(field);
        if (removed == null) {
            removed = this.body.removeFieldValue(field);
        }
        return removed;
    }

    @Override
    public void clear() {
        this.header.clear();
        this.body.clear();
    }

    @Override
    public Iterator<Map.Entry<Field, FieldValue>> iterator() {
        return new Iterator<Map.Entry<Field, FieldValue>>(){
            private Iterator<Map.Entry<Field, FieldValue>> headerIt;
            private Iterator<Map.Entry<Field, FieldValue>> bodyIt;
            {
                this.headerIt = Document.this.header.iterator();
                this.bodyIt = Document.this.body.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.headerIt != null) {
                    if (this.headerIt.hasNext()) {
                        return true;
                    }
                    this.headerIt = null;
                }
                return this.bodyIt.hasNext();
            }

            @Override
            public Map.Entry<Field, FieldValue> next() {
                return this.headerIt == null ? this.bodyIt.next() : this.headerIt.next();
            }

            @Override
            public void remove() {
                if (this.headerIt == null) {
                    this.bodyIt.remove();
                } else {
                    this.headerIt.remove();
                }
            }
        };
    }

    public String toString() {
        return "document '" + String.valueOf(this.docId) + "' of type '" + this.getDataType().getName() + "'";
    }

    public String toXML(String indent) {
        XmlStream xml = new XmlStream();
        xml.setIndent(indent);
        xml.beginTag("document");
        this.printXml(xml);
        xml.endTag();
        return xml.toString();
    }

    @Override
    public String toXml() {
        return this.toXML("  ");
    }

    @Override
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printDocumentXml(this, xml);
    }

    public String toJson() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        JsonWriter writer = new JsonWriter(buffer);
        writer.write(this);
        try {
            return buffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        return super.equals(o) && this.docId.equals(other.docId) && this.header.equals(other.header) && this.body.equals(other.body);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.docId != null ? this.docId.hashCode() : 0);
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public void onSerialize(Serializer data) throws SerializationException {
        this.serialize((DocumentWriter)data);
    }

    @Override
    public DocumentType getDataType() {
        return (DocumentType)super.getDataType();
    }

    @Override
    public int getFieldCount() {
        return this.header.getFieldCount() + this.body.getFieldCount();
    }

    public void serialize(DocumentWriter writer) {
        writer.write(this);
    }

    public void deserialize(DocumentReader reader) {
        reader.read(this);
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        Document otherValue = (Document)fieldValue;
        comp = this.getId().compareTo(otherValue.getId());
        if (comp != 0) {
            return comp;
        }
        comp = this.header.compareTo(otherValue.header);
        if (comp != 0) {
            return comp;
        }
        comp = this.body.compareTo(otherValue.body);
        return comp;
    }
}

