/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public class TensorReader {
    public static final String TENSOR_ADDRESS = "address";
    public static final String TENSOR_DIMENSIONS = "dimensions";
    public static final String TENSOR_CELLS = "cells";
    public static final String TENSOR_VALUES = "values";
    public static final String TENSOR_VALUE = "value";

    static void fillTensor(TokenBuffer buffer, TensorFieldValue tensorFieldValue) {
        Tensor.Builder builder = Tensor.Builder.of((TensorType)tensorFieldValue.getDataType().getTensorType());
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            if (TENSOR_CELLS.equals(buffer.currentName())) {
                TensorReader.readTensorCells(buffer, builder);
            } else if (TENSOR_VALUES.equals(buffer.currentName())) {
                TensorReader.readTensorValues(buffer, builder);
            } else if (builder.type().dimensions().stream().anyMatch(d -> d.isIndexed())) {
                throw new IllegalArgumentException("Expected a tensor value to contain either 'cells' or 'values'");
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        tensorFieldValue.assign(builder.build());
    }

    static void readTensorCells(TokenBuffer buffer, Tensor.Builder builder) {
        JsonParserHelpers.expectArrayStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            TensorReader.readTensorCell(buffer, builder);
            buffer.next();
        }
        JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
    }

    private static void readTensorCell(TokenBuffer buffer, Tensor.Builder builder) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        double cellValue = 0.0;
        Tensor.Builder.CellBuilder cellBuilder = builder.cell();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String currentName = buffer.currentName();
            if (TENSOR_ADDRESS.equals(currentName)) {
                TensorReader.readTensorAddress(buffer, cellBuilder);
            } else if (TENSOR_VALUE.equals(currentName)) {
                cellValue = TensorReader.readDouble(buffer);
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        cellBuilder.value(cellValue);
    }

    private static void readTensorAddress(TokenBuffer buffer, Tensor.Builder.CellBuilder cellBuilder) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String dimension = buffer.currentName();
            String label = buffer.currentText();
            cellBuilder.label(dimension, label);
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
    }

    private static void readTensorValues(TokenBuffer buffer, Tensor.Builder builder) {
        if (!(builder instanceof IndexedTensor.BoundBuilder)) {
            throw new IllegalArgumentException("The 'values' field can only be used with dense tensors. Use 'cells' instead");
        }
        JsonParserHelpers.expectArrayStart(buffer.currentToken());
        IndexedTensor.BoundBuilder indexedBuilder = (IndexedTensor.BoundBuilder)builder;
        int index = 0;
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            indexedBuilder.cellByDirectIndex((long)index++, TensorReader.readDouble(buffer));
            buffer.next();
        }
        JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
    }

    private static double readDouble(TokenBuffer buffer) {
        try {
            return Double.valueOf(buffer.currentText());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected a number but got '" + buffer.currentText());
        }
    }
}

