/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.serialization;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.BoolFieldValue;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.vespa.objects.FieldBase;
import com.yahoo.vespa.objects.Serializer;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;

public final class XmlDocumentWriter
implements DocumentWriter {
    private final String indent;
    private XmlStream buffer;
    private Deque<FieldBase> optionalWrapperMarker = new ArrayDeque<FieldBase>();

    public static XmlDocumentWriter createWriter(String indent) {
        return new XmlDocumentWriter(indent);
    }

    public XmlDocumentWriter() {
        this("  ");
    }

    private XmlDocumentWriter(String indent) {
        this.indent = indent;
    }

    @Override
    public void write(FieldBase field, FieldValue value) {
        Class<?> valueType = value.getClass();
        if (valueType == AnnotationReference.class) {
            this.write(field, (AnnotationReference)value);
        } else if (valueType == Array.class) {
            this.write(field, (Array)value);
        } else if (valueType == WeightedSet.class) {
            this.write(field, (WeightedSet)value);
        } else if (valueType == Document.class) {
            this.write(field, (Document)value);
        } else if (valueType == Struct.class) {
            this.write(field, (Struct)value);
        } else if (valueType == ByteFieldValue.class) {
            this.write(field, (ByteFieldValue)value);
        } else if (valueType == DoubleFieldValue.class) {
            this.write(field, (DoubleFieldValue)value);
        } else if (valueType == FloatFieldValue.class) {
            this.write(field, (FloatFieldValue)value);
        } else if (valueType == IntegerFieldValue.class) {
            this.write(field, (IntegerFieldValue)value);
        } else if (valueType == LongFieldValue.class) {
            this.write(field, (LongFieldValue)value);
        } else if (valueType == Raw.class) {
            this.write(field, (Raw)value);
        } else if (valueType == PredicateFieldValue.class) {
            this.write(field, (PredicateFieldValue)value);
        } else if (valueType == StringFieldValue.class) {
            this.write(field, (StringFieldValue)value);
        } else {
            throw new UnsupportedOperationException("Cannot serialize a " + valueType.getName());
        }
    }

    @Override
    public void write(FieldBase field, Document value) {
        this.buffer.beginTag("document");
        this.buffer.addAttribute("documenttype", value.getDataType().getName());
        this.buffer.addAttribute("documentid", value.getId());
        Long lastModified = value.getLastModified();
        if (lastModified != null) {
            this.buffer.addAttribute("lastmodifiedtime", lastModified);
        }
        Document asStructured = value;
        this.write(null, (StructuredFieldValue)asStructured);
        this.buffer.endTag();
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, Array<T> value) {
        this.buffer.beginTag(field.getName());
        XmlSerializationHelper.printArrayXml(value, this.buffer);
        this.buffer.endTag();
    }

    private void singleValueTag(FieldBase field, FieldValue value) {
        this.buffer.beginTag(field.getName());
        value.printXml(this.buffer);
        this.buffer.endTag();
    }

    @Override
    public <K extends FieldValue, V extends FieldValue> void write(FieldBase field, MapFieldValue<K, V> map) {
        this.buffer.beginTag(field.getName());
        XmlSerializationHelper.printMapXml(map, this.buffer);
        this.buffer.endTag();
    }

    @Override
    public void write(FieldBase field, ByteFieldValue value) {
        this.singleValueTag(field, value);
    }

    @Override
    public void write(FieldBase field, BoolFieldValue value) {
        this.singleValueTag(field, value);
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, CollectionFieldValue<T> value) {
        this.buffer.beginTag(field.getName());
        Iterator<T> i = value.iterator();
        while (i.hasNext()) {
            this.buffer.beginTag("item");
            ((FieldValue)i.next()).printXml(this.buffer);
            this.buffer.endTag();
        }
        this.buffer.endTag();
    }

    @Override
    public void write(FieldBase field, DoubleFieldValue value) {
        this.singleValueTag(field, value);
    }

    @Override
    public void write(FieldBase field, FloatFieldValue value) {
        this.singleValueTag(field, value);
    }

    @Override
    public void write(FieldBase field, IntegerFieldValue value) {
        this.singleValueTag(field, value);
    }

    @Override
    public void write(FieldBase field, LongFieldValue value) {
        this.singleValueTag(field, value);
    }

    @Override
    public void write(FieldBase field, Raw value) {
        this.buffer.beginTag(field.getName());
        XmlSerializationHelper.printRawXml(value, this.buffer);
        this.buffer.endTag();
    }

    @Override
    public void write(FieldBase field, PredicateFieldValue value) {
        this.singleValueTag(field, value);
    }

    @Override
    public void write(FieldBase field, StringFieldValue value) {
        this.buffer.beginTag(field.getName());
        XmlSerializationHelper.printStringXml(value, this.buffer);
        this.buffer.endTag();
    }

    @Override
    public void write(FieldBase field, TensorFieldValue value) {
        throw new IllegalArgumentException("write() for tensor field value not implemented yet");
    }

    @Override
    public void write(FieldBase field, ReferenceFieldValue value) {
        throw new IllegalArgumentException("write() for reference field value not implemented yet");
    }

    private void optionalWrapperStart(FieldBase field) {
        if (field == null) {
            return;
        }
        this.optionalWrapperMarker.addFirst(field);
        this.buffer.beginTag(field.getName());
    }

    private void optionalWrapperEnd(FieldBase field) {
        if (field == null) {
            return;
        }
        if (this.optionalWrapperMarker.removeFirst() != field) {
            throw new IllegalStateException("Unbalanced optional wrapper tags.");
        }
        this.buffer.endTag();
    }

    @Override
    public void write(FieldBase field, Struct value) {
        Struct asStructured = value;
        this.write(field, (StructuredFieldValue)asStructured);
    }

    @Override
    public void write(FieldBase field, StructuredFieldValue value) {
        this.optionalWrapperStart(field);
        Iterator<Map.Entry<Field, FieldValue>> i = value.iterator();
        while (i.hasNext()) {
            Map.Entry<Field, FieldValue> v = i.next();
            this.buffer.beginTag(v.getKey().getName());
            v.getValue().printXml(this.buffer);
            this.buffer.endTag();
        }
        this.optionalWrapperEnd(field);
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, WeightedSet<T> value) {
        this.buffer.beginTag(field.getName());
        XmlSerializationHelper.printWeightedSetXml(value, this.buffer);
        this.buffer.endTag();
    }

    @Override
    public void write(FieldBase field, AnnotationReference value) {
    }

    public Serializer putByte(FieldBase field, byte value) {
        this.singleValueTag(field, new ByteFieldValue(value));
        return this;
    }

    public Serializer putShort(FieldBase field, short value) {
        this.singleValueTag(field, new IntegerFieldValue(value));
        return this;
    }

    public Serializer putInt(FieldBase field, int value) {
        this.singleValueTag(field, new IntegerFieldValue(value));
        return this;
    }

    public Serializer putLong(FieldBase field, long value) {
        this.singleValueTag(field, new LongFieldValue(value));
        return this;
    }

    public Serializer putFloat(FieldBase field, float value) {
        this.singleValueTag(field, new FloatFieldValue(value));
        return this;
    }

    public Serializer putDouble(FieldBase field, double value) {
        this.singleValueTag(field, new DoubleFieldValue(value));
        return this;
    }

    public Serializer put(FieldBase field, byte[] value) {
        this.write(field, new Raw(value));
        return this;
    }

    public Serializer put(FieldBase field, ByteBuffer value) {
        this.write(field, new Raw(value));
        return this;
    }

    public Serializer put(FieldBase field, String value) {
        this.write(field, new StringFieldValue(value));
        return this;
    }

    @Override
    public void write(Document document) {
        this.buffer = new XmlStream();
        this.buffer.setIndent(this.indent);
        this.optionalWrapperMarker.clear();
        this.write((FieldBase)new Field(document.getDataType().getName(), 0, (DataType)document.getDataType()), document);
    }

    @Override
    public void write(DocumentId id) {
        throw new UnsupportedOperationException("Writing a DocumentId as XML is not implemented.");
    }

    @Override
    public void write(DocumentType type) {
        throw new UnsupportedOperationException("Writing a DocumentId as XML is not implemented.");
    }

    public String lastRendered() {
        return this.buffer.toString();
    }
}

