/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.compress.CompressionType;
import com.yahoo.config.InnerNode;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumentmanagerConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DocumentTypeManagerConfigurer
implements ConfigSubscriber.SingleSubscriber<DocumentmanagerConfig> {
    private static final Logger log = Logger.getLogger(DocumentTypeManagerConfigurer.class.getName());
    private final DocumentTypeManager managerToConfigure;

    public DocumentTypeManagerConfigurer(DocumentTypeManager manager) {
        this.managerToConfigure = manager;
    }

    @Deprecated
    public static CompressionType toCompressorType(DocumentmanagerConfig.Datatype.Structtype.Compresstype.Enum value) {
        switch (value) {
            case NONE: {
                return CompressionType.NONE;
            }
            case LZ4: {
                return CompressionType.LZ4;
            }
            case UNCOMPRESSABLE: {
                return CompressionType.INCOMPRESSIBLE;
            }
        }
        throw new IllegalArgumentException("Compression type " + value + " is not supported");
    }

    public static ConfigSubscriber configure(DocumentTypeManager manager, String configId) {
        return new DocumentTypeManagerConfigurer(manager).configure(configId);
    }

    public ConfigSubscriber configure(String configId) {
        ConfigSubscriber subscriber = new ConfigSubscriber();
        subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, DocumentmanagerConfig.class, configId);
        return subscriber;
    }

    static void configureNewManager(DocumentmanagerConfig config, DocumentTypeManager manager) {
        if (config == null) {
            return;
        }
        new Apply(config, manager);
    }

    public static DocumentTypeManager configureNewManager(DocumentmanagerConfig config) {
        DocumentTypeManager manager = new DocumentTypeManager();
        new Apply(config, manager);
        return manager;
    }

    public void configure(DocumentmanagerConfig config) {
        DocumentTypeManager manager = DocumentTypeManagerConfigurer.configureNewManager(config);
        int defaultTypeCount = new DocumentTypeManager().getDataTypes().size();
        if (this.managerToConfigure.getDataTypes().size() != defaultTypeCount) {
            log.log(Level.FINE, "Live document config overwritten with new config.");
        }
        this.managerToConfigure.assign(manager);
    }

    private static class Apply {
        private Map<Integer, DataType> typesById = new HashMap<Integer, DataType>();
        private Map<String, DataType> typesByName = new HashMap<String, DataType>();
        private Map<Integer, DocumentmanagerConfig.Datatype> configMap = new HashMap<Integer, DocumentmanagerConfig.Datatype>();
        private final boolean usev8geopositions;
        private final DocumentTypeManager manager;

        public Apply(DocumentmanagerConfig config, DocumentTypeManager manager) {
            this.manager = manager;
            boolean bl = this.usev8geopositions = config == null ? false : config.usev8geopositions();
            if (config != null) {
                this.apply(config);
            }
        }

        private void inProgress(DataType type) {
            DataType old = this.typesById.put(type.getId(), type);
            if (old != null) {
                throw new IllegalArgumentException("Multiple types with same id: " + old + " -> " + type);
            }
            old = this.typesByName.put(type.getName(), type);
            if (old != null) {
                log.warning("Multiple types with same name: " + old + " -> " + type);
            }
        }

        private void startStructsAndDocs(DocumentmanagerConfig config) {
            int id;
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Structtype o : thisDataType.structtype()) {
                    id = thisDataType.id();
                    StructDataType type = new StructDataType(id, o.name());
                    this.inProgress(type);
                    this.configMap.remove(id);
                }
            }
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Documenttype doc : thisDataType.documenttype()) {
                    id = thisDataType.id();
                    StructDataType header = (StructDataType)this.typesById.get(doc.headerstruct());
                    Set<String> importedFields = doc.importedfield().stream().map(f -> f.name()).collect(Collectors.toUnmodifiableSet());
                    DocumentType type = new DocumentType(doc.name(), header, importedFields);
                    if (id != type.getId()) {
                        int alt = (doc.name() + "." + doc.version()).hashCode();
                        if (id == alt) {
                            this.typesById.put(id, type);
                        } else {
                            throw new IllegalArgumentException("Document type " + doc.name() + " wanted id " + id + " but got " + type.getId() + ", alternative id was: " + alt);
                        }
                    }
                    this.inProgress(type);
                    this.configMap.remove(id);
                }
            }
        }

        private DataType createArrayType(int id, DocumentmanagerConfig.Datatype.Arraytype array) {
            DataType nestedType = this.getOrCreateType(array.datatype());
            ArrayDataType type = new ArrayDataType(nestedType, id);
            this.inProgress(type);
            return type;
        }

        private DataType createMapType(int id, DocumentmanagerConfig.Datatype.Maptype map) {
            DataType keyType = this.getOrCreateType(map.keytype());
            DataType valType = this.getOrCreateType(map.valtype());
            MapDataType type = new MapDataType(keyType, valType, id);
            this.inProgress(type);
            return type;
        }

        private DataType createWeightedSetType(int id, DocumentmanagerConfig.Datatype.Weightedsettype wset) {
            DataType nestedType = this.getOrCreateType(wset.datatype());
            WeightedSetDataType type = new WeightedSetDataType(nestedType, wset.createifnonexistant(), wset.removeifzero(), id);
            this.inProgress(type);
            return type;
        }

        private DataType createReferenceType(int id, DocumentmanagerConfig.Datatype.Referencetype refType) {
            int targetId = refType.target_type_id();
            DocumentType targetDocType = (DocumentType)this.typesById.get(targetId);
            ReferenceDataType type = new ReferenceDataType(targetDocType, id);
            this.inProgress(type);
            return type;
        }

        private DataType getOrCreateType(int id) {
            if (this.typesById.containsKey(id)) {
                return this.typesById.get(id);
            }
            DocumentmanagerConfig.Datatype config = this.configMap.remove(id);
            if (config == null) {
                return this.manager.getDataType(id);
            }
            assert (id == config.id());
            Iterator<InnerNode> iterator = config.arraytype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Arraytype o = iterator.next();
                return this.createArrayType(id, o);
            }
            iterator = config.maptype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Maptype o = (DocumentmanagerConfig.Datatype.Maptype)iterator.next();
                return this.createMapType(id, o);
            }
            iterator = config.weightedsettype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Weightedsettype o = (DocumentmanagerConfig.Datatype.Weightedsettype)iterator.next();
                return this.createWeightedSetType(id, o);
            }
            iterator = config.referencetype().iterator();
            if (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Referencetype o = (DocumentmanagerConfig.Datatype.Referencetype)iterator.next();
                return this.createReferenceType(id, o);
            }
            throw new IllegalArgumentException("Could not create type from config: " + config);
        }

        private void createRemainingTypes(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                int id = thisDataType.id();
                DataType type = this.getOrCreateType(id);
                assert (type != null);
            }
        }

        private void fillStructs(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Structtype struct : thisDataType.structtype()) {
                    int id = thisDataType.id();
                    StructDataType type = (StructDataType)this.typesById.get(id);
                    for (DocumentmanagerConfig.Datatype.Structtype.Inherits parent : struct.inherits()) {
                        StructDataType parentStruct = (StructDataType)this.typesByName.get(parent.name());
                        type.inherit(parentStruct);
                    }
                    for (DocumentmanagerConfig.Datatype.Structtype.Field field : struct.field()) {
                        DataType fieldType;
                        if (field.datatype() == id) {
                            log.fine("Self-referencing struct " + struct.name() + " field: " + field);
                        }
                        if ((fieldType = this.typesById.get(field.datatype())) == null) {
                            fieldType = this.manager.getDataType(field.datatype(), field.detailedtype());
                        }
                        if (field.id().size() == 1) {
                            type.addField(new Field(field.name(), field.id().get(0).id(), fieldType));
                            continue;
                        }
                        type.addField(new Field(field.name(), fieldType));
                    }
                }
            }
        }

        private void fillDocuments(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                for (DocumentmanagerConfig.Datatype.Documenttype doc : thisDataType.documenttype()) {
                    int id = thisDataType.id();
                    DocumentType type = (DocumentType)this.typesById.get(id);
                    for (DocumentmanagerConfig.Datatype.Documenttype.Inherits parent : doc.inherits()) {
                        DocumentType parentType = (DocumentType)this.typesByName.get(parent.name());
                        if (parentType == null) {
                            DataTypeName name = new DataTypeName(parent.name());
                            parentType = this.manager.getDocumentType(name);
                        }
                        if (parentType == null) {
                            throw new IllegalArgumentException("Could not find parent document type '" + parent.name() + "'.");
                        }
                        type.inherit(parentType);
                    }
                    HashMap<String, Collection<String>> fieldSets = new HashMap<String, Collection<String>>(doc.fieldsets().size());
                    for (Map.Entry<String, DocumentmanagerConfig.Datatype.Documenttype.Fieldsets> entry : doc.fieldsets().entrySet()) {
                        fieldSets.put(entry.getKey(), entry.getValue().fields());
                    }
                    type.addFieldSets(fieldSets);
                }
            }
        }

        private void splitConfig(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype dataTypeConfig : config.datatype()) {
                int id = dataTypeConfig.id();
                DocumentmanagerConfig.Datatype old = this.configMap.put(id, dataTypeConfig);
                if (old == null) continue;
                throw new IllegalArgumentException("Multiple configs for id " + id + " first: " + old + " second: " + dataTypeConfig);
            }
        }

        private void apply(DocumentmanagerConfig config) {
            this.splitConfig(config);
            this.setupAnnotationTypesWithoutPayloads(config);
            this.setupAnnotationRefTypes(config);
            this.startStructsAndDocs(config);
            this.createRemainingTypes(config);
            this.fillStructs(config);
            this.fillDocuments(config);
            for (DataType type : this.typesById.values()) {
                this.manager.register(type);
            }
            this.addAnnotationTypePayloads(config);
            this.addAnnotationTypeInheritance(config);
        }

        private void setupAnnotationRefTypes(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Datatype thisDataType : config.datatype()) {
                int id = thisDataType.id();
                for (DocumentmanagerConfig.Datatype.Annotationreftype annRefType : thisDataType.annotationreftype()) {
                    AnnotationType annotationType = this.manager.getAnnotationTypeRegistry().getType(annRefType.annotation());
                    if (annotationType == null) {
                        throw new IllegalArgumentException("Found reference to " + annRefType.annotation() + ", which does not exist!");
                    }
                    AnnotationReferenceDataType type = new AnnotationReferenceDataType(annotationType, id);
                    this.inProgress(type);
                    this.configMap.remove(id);
                }
            }
        }

        private void setupAnnotationTypesWithoutPayloads(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                AnnotationType annotationType = new AnnotationType(annType.name(), annType.id());
                this.manager.getAnnotationTypeRegistry().register(annotationType);
            }
        }

        private void addAnnotationTypePayloads(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                AnnotationType annotationType = this.manager.getAnnotationTypeRegistry().getType(annType.id());
                DataType payload = this.manager.getDataType(annType.datatype(), "");
                if (payload.equals(DataType.NONE)) continue;
                annotationType.setDataType(payload);
            }
        }

        private void addAnnotationTypeInheritance(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                if (annType.inherits().size() <= 0) continue;
                AnnotationType inheritedType = this.manager.getAnnotationTypeRegistry().getType(annType.inherits(0).id());
                AnnotationType type = this.manager.getAnnotationTypeRegistry().getType(annType.id());
                type.inherit(inheritedType);
            }
        }
    }
}

