/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.tensor.TensorType;

public class TensorDataType
extends DataType {
    private final TensorType tensorType;
    public static int classId = TensorDataType.registerClass((int)4155, TensorDataType.class);

    public TensorDataType(TensorType tensorType) {
        super(tensorType.toString(), 21);
        this.tensorType = tensorType;
    }

    @Override
    public TensorDataType clone() {
        return (TensorDataType)super.clone();
    }

    @Override
    public FieldValue createFieldValue() {
        return new TensorFieldValue(this.tensorType);
    }

    @Override
    public Class<? extends TensorFieldValue> getValueClass() {
        return TensorFieldValue.class;
    }

    @Override
    public boolean isValueCompatible(FieldValue value) {
        if (value == null) {
            return false;
        }
        if (!TensorFieldValue.class.isAssignableFrom(value.getClass())) {
            return false;
        }
        TensorFieldValue tensorValue = (TensorFieldValue)value;
        return this.tensorType.isConvertibleTo(tensorValue.getDataType().getTensorType());
    }

    public TensorType getTensorType() {
        return this.tensorType;
    }
}

