/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.compress.CompressionType;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumentmanagerConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DocumentTypeManagerConfigurer
implements ConfigSubscriber.SingleSubscriber<DocumentmanagerConfig> {
    private static final Logger log = Logger.getLogger(DocumentTypeManagerConfigurer.class.getName());
    private final DocumentTypeManager managerToConfigure;

    public DocumentTypeManagerConfigurer(DocumentTypeManager manager) {
        this.managerToConfigure = manager;
    }

    @Deprecated
    public static CompressionType toCompressorType(DocumentmanagerConfig.Datatype.Structtype.Compresstype.Enum value) {
        switch (value) {
            case NONE: {
                return CompressionType.NONE;
            }
            case LZ4: {
                return CompressionType.LZ4;
            }
            case UNCOMPRESSABLE: {
                return CompressionType.INCOMPRESSIBLE;
            }
        }
        throw new IllegalArgumentException("Compression type " + value + " is not supported");
    }

    public static ConfigSubscriber configure(DocumentTypeManager manager, String configId) {
        return new DocumentTypeManagerConfigurer(manager).configure(configId);
    }

    public ConfigSubscriber configure(String configId) {
        ConfigSubscriber subscriber = new ConfigSubscriber();
        subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, DocumentmanagerConfig.class, configId);
        return subscriber;
    }

    static void configureNewManager(DocumentmanagerConfig config, DocumentTypeManager manager) {
        if (config == null) {
            return;
        }
        new Apply(config, manager);
    }

    public static DocumentTypeManager configureNewManager(DocumentmanagerConfig config) {
        DocumentTypeManager manager = new DocumentTypeManager();
        new Apply(config, manager);
        return manager;
    }

    public void configure(DocumentmanagerConfig config) {
        DocumentTypeManager manager = DocumentTypeManagerConfigurer.configureNewManager(config);
        int defaultTypeCount = new DocumentTypeManager().getDataTypes().size();
        if (this.managerToConfigure.getDataTypes().size() != defaultTypeCount) {
            log.log(Level.FINE, "Live document config overwritten with new config.");
        }
        this.managerToConfigure.assign(manager);
    }

    private static class Apply {
        private final boolean usev8geopositions;
        private final DocumentTypeManager manager;

        public Apply(DocumentmanagerConfig config, DocumentTypeManager manager) {
            this.manager = manager;
            boolean bl = this.usev8geopositions = config == null ? false : config.usev8geopositions();
            if (config != null) {
                this.apply(config);
            }
        }

        private void apply(DocumentmanagerConfig config) {
            this.setupAnnotationTypesWithoutPayloads(config);
            this.setupAnnotationRefTypes(config);
            this.setupDatatypesWithRetry(config);
            this.addStructInheritance(config);
            this.addAnnotationTypePayloads(config);
            this.addAnnotationTypeInheritance(config);
            this.manager.replaceTemporaryTypes();
        }

        private void setupDatatypesWithRetry(DocumentmanagerConfig config) {
            ArrayList<DocumentmanagerConfig.Datatype> tmp = new ArrayList<DocumentmanagerConfig.Datatype>(config.datatype());
            log.log(Level.FINE, "Configuring document manager with " + tmp.size() + " data types.");
            while (!tmp.isEmpty()) {
                int oldSz = tmp.size();
                ArrayList<DocumentmanagerConfig.Datatype> failed = new ArrayList<DocumentmanagerConfig.Datatype>();
                for (DocumentmanagerConfig.Datatype thisDataType : tmp) {
                    int id = thisDataType.id();
                    try {
                        this.registerTypeIdMapping(thisDataType, id);
                    }
                    catch (IllegalArgumentException e) {
                        failed.add(thisDataType);
                    }
                }
                tmp = failed;
                if (tmp.size() != oldSz) continue;
                throw new IllegalArgumentException("No progress registering datatypes");
            }
        }

        private void registerTypeIdMapping(DocumentmanagerConfig.Datatype thisDataType, int id) {
            for (DocumentmanagerConfig.Datatype.Arraytype arraytype : thisDataType.arraytype()) {
                this.registerArrayType(id, arraytype);
            }
            for (DocumentmanagerConfig.Datatype.Maptype maptype : thisDataType.maptype()) {
                this.registerMapType(id, maptype);
            }
            for (DocumentmanagerConfig.Datatype.Weightedsettype weightedsettype : thisDataType.weightedsettype()) {
                this.registerWeightedSetType(id, weightedsettype);
            }
            for (DocumentmanagerConfig.Datatype.Structtype structtype : thisDataType.structtype()) {
                this.registerStructType(id, structtype);
            }
            for (DocumentmanagerConfig.Datatype.Documenttype documenttype : thisDataType.documenttype()) {
                this.registerDocumentType(documenttype);
            }
            for (DocumentmanagerConfig.Datatype.Referencetype referencetype : thisDataType.referencetype()) {
                this.registerReferenceType(id, referencetype);
            }
        }

        private void registerArrayType(int id, DocumentmanagerConfig.Datatype.Arraytype array) {
            DataType nestedType = this.manager.getDataType(array.datatype(), "");
            ArrayDataType type = new ArrayDataType(nestedType, id);
            this.manager.register(type);
        }

        private void registerMapType(int id, DocumentmanagerConfig.Datatype.Maptype map) {
            DataType keyType = this.manager.getDataType(map.keytype(), "");
            DataType valType = this.manager.getDataType(map.valtype(), "");
            MapDataType type = new MapDataType(keyType, valType, id);
            this.manager.register(type);
        }

        private void registerWeightedSetType(int id, DocumentmanagerConfig.Datatype.Weightedsettype wset) {
            DataType nestedType = this.manager.getDataType(wset.datatype(), "");
            WeightedSetDataType type = new WeightedSetDataType(nestedType, wset.createifnonexistant(), wset.removeifzero(), id);
            this.manager.register(type);
        }

        private void registerDocumentType(DocumentmanagerConfig.Datatype.Documenttype doc) {
            StructDataType header = (StructDataType)this.manager.getDataType(doc.headerstruct(), "");
            Set<String> importedFields = doc.importedfield().stream().map(f -> f.name()).collect(Collectors.toUnmodifiableSet());
            DocumentType type = new DocumentType(doc.name(), header, importedFields);
            for (DocumentmanagerConfig.Datatype.Documenttype.Inherits parent : doc.inherits()) {
                DataTypeName name = new DataTypeName(parent.name());
                DocumentType parentType = this.manager.getDocumentType(name);
                if (parentType == null) {
                    throw new IllegalArgumentException("Could not find document type '" + name + "'.");
                }
                type.inherit(parentType);
            }
            HashMap<String, Collection<String>> fieldSets = new HashMap<String, Collection<String>>(doc.fieldsets().size());
            for (Map.Entry<String, DocumentmanagerConfig.Datatype.Documenttype.Fieldsets> entry : doc.fieldsets().entrySet()) {
                fieldSets.put(entry.getKey(), entry.getValue().fields());
            }
            type.addFieldSets(fieldSets);
            this.manager.register(type);
        }

        private void registerStructType(int id, DocumentmanagerConfig.Datatype.Structtype struct) {
            StructDataType type = new StructDataType(id, struct.name());
            for (DocumentmanagerConfig.Datatype.Structtype.Field field : struct.field()) {
                DataType fieldType;
                DataType dataType = fieldType = field.datatype() == id ? this.manager.getDataTypeAndReturnTemporary(field.datatype(), field.detailedtype()) : this.manager.getDataType(field.datatype(), field.detailedtype());
                if (field.id().size() == 1) {
                    type.addField(new Field(field.name(), field.id().get(0).id(), fieldType));
                    continue;
                }
                type.addField(new Field(field.name(), fieldType));
            }
            this.manager.register(type);
        }

        private void registerReferenceType(int id, DocumentmanagerConfig.Datatype.Referencetype refType) {
            ReferenceDataType referenceType;
            if (this.manager.hasDataType(refType.target_type_id())) {
                DocumentType targetDocType = (DocumentType)this.manager.getDataType(refType.target_type_id());
                referenceType = new ReferenceDataType(targetDocType, id);
            } else {
                TemporaryStructuredDataType temporaryTargetType = TemporaryStructuredDataType.createById(refType.target_type_id());
                referenceType = new ReferenceDataType(temporaryTargetType, id);
            }
            this.manager.register(referenceType);
        }

        private void setupAnnotationRefTypes(DocumentmanagerConfig config) {
            for (int i = 0; i < config.datatype().size(); ++i) {
                DocumentmanagerConfig.Datatype thisDataType = config.datatype(i);
                int id = thisDataType.id();
                for (DocumentmanagerConfig.Datatype.Annotationreftype annRefType : thisDataType.annotationreftype()) {
                    AnnotationType annotationType = this.manager.getAnnotationTypeRegistry().getType(annRefType.annotation());
                    if (annotationType == null) {
                        throw new IllegalArgumentException("Found reference to " + annRefType.annotation() + ", which does not exist!");
                    }
                    AnnotationReferenceDataType type = new AnnotationReferenceDataType(annotationType, id);
                    this.manager.register(type);
                }
            }
        }

        private void setupAnnotationTypesWithoutPayloads(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                AnnotationType annotationType = new AnnotationType(annType.name(), annType.id());
                this.manager.getAnnotationTypeRegistry().register(annotationType);
            }
        }

        private void addAnnotationTypePayloads(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                AnnotationType annotationType = this.manager.getAnnotationTypeRegistry().getType(annType.id());
                DataType payload = this.manager.getDataType(annType.datatype(), "");
                if (payload.equals(DataType.NONE)) continue;
                annotationType.setDataType(payload);
            }
        }

        private void addAnnotationTypeInheritance(DocumentmanagerConfig config) {
            for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
                if (annType.inherits().size() <= 0) continue;
                AnnotationType inheritedType = this.manager.getAnnotationTypeRegistry().getType(annType.inherits(0).id());
                AnnotationType type = this.manager.getAnnotationTypeRegistry().getType(annType.id());
                type.inherit(inheritedType);
            }
        }

        private void addStructInheritance(DocumentmanagerConfig config) {
            for (int i = 0; i < config.datatype().size(); ++i) {
                DocumentmanagerConfig.Datatype thisDataType = config.datatype(i);
                int id = thisDataType.id();
                for (DocumentmanagerConfig.Datatype.Structtype struct : thisDataType.structtype()) {
                    StructDataType thisStruct = (StructDataType)this.manager.getDataType(id, "");
                    for (DocumentmanagerConfig.Datatype.Structtype.Inherits parent : struct.inherits()) {
                        StructDataType parentStruct = (StructDataType)this.manager.getDataType(parent.name());
                        thisStruct.inherit(parentStruct);
                    }
                }
            }
        }
    }
}

