/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.json.readers.SingleValueReader;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.ValueUpdate;

public class MapReader {
    public static final String MAP_KEY = "key";
    public static final String MAP_VALUE = "value";
    public static final String UPDATE_ELEMENT = "element";
    public static final String UPDATE_MATCH = "match";

    public static void fillMap(TokenBuffer buffer, MapFieldValue parent) {
        if (buffer.currentToken() == JsonToken.START_ARRAY) {
            MapReader.fillMapFromArray(buffer, parent);
        } else {
            MapReader.fillMapFromObject(buffer, parent);
        }
    }

    public static void fillMapFromArray(TokenBuffer buffer, MapFieldValue parent) {
        JsonToken token = buffer.currentToken();
        int initNesting = buffer.nesting();
        JsonParserHelpers.expectArrayStart(token);
        token = buffer.next();
        DataType keyType = parent.getDataType().getKeyType();
        DataType valueType = parent.getDataType().getValueType();
        while (buffer.nesting() >= initNesting) {
            FieldValue key = null;
            FieldValue value = null;
            JsonParserHelpers.expectObjectStart(token);
            token = buffer.next();
            for (int i = 0; i < 2; ++i) {
                if (MAP_KEY.equals(buffer.currentName())) {
                    key = SingleValueReader.readSingleValue(buffer, keyType);
                } else if (MAP_VALUE.equals(buffer.currentName())) {
                    value = SingleValueReader.readSingleValue(buffer, valueType);
                }
                token = buffer.next();
            }
            Preconditions.checkState((key != null && value != null ? 1 : 0) != 0, (Object)"Missing key or value for map entry.");
            parent.put(key, value);
            JsonParserHelpers.expectObjectEnd(token);
            token = buffer.next();
        }
    }

    public static void fillMapFromObject(TokenBuffer buffer, MapFieldValue parent) {
        JsonToken token = buffer.currentToken();
        int initNesting = buffer.nesting();
        JsonParserHelpers.expectObjectStart(token);
        token = buffer.next();
        DataType keyType = parent.getDataType().getKeyType();
        DataType valueType = parent.getDataType().getValueType();
        while (buffer.nesting() >= initNesting) {
            FieldValue key = SingleValueReader.readAtomic(buffer.currentName(), keyType);
            FieldValue value = SingleValueReader.readSingleValue(buffer, valueType);
            Preconditions.checkState((key != null && value != null ? 1 : 0) != 0, (Object)"Missing key or value for map entry.");
            parent.put(key, value);
            token = buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(token);
    }

    public static ValueUpdate createMapUpdate(TokenBuffer buffer, DataType currentLevel, FieldValue keyParent, FieldValue topLevelKey) {
        TokenBuffer.Token element = buffer.prefetchScalar(UPDATE_ELEMENT);
        if (UPDATE_ELEMENT.equals(buffer.currentName())) {
            buffer.next();
        }
        FieldValue key = MapReader.keyTypeForMapUpdate(element, currentLevel);
        if (keyParent != null) {
            ((CollectionFieldValue)keyParent).add(key);
        }
        if (!UPDATE_MATCH.equals(buffer.currentName())) {
            if (topLevelKey == null) {
                return ValueUpdate.createMap(key, SingleValueReader.readSingleUpdate(buffer, MapReader.valueTypeForMapUpdate(currentLevel), buffer.currentName()));
            }
            return ValueUpdate.createMap(topLevelKey, SingleValueReader.readSingleUpdate(buffer, MapReader.valueTypeForMapUpdate(currentLevel), buffer.currentName()));
        }
        if (topLevelKey == null) {
            return MapReader.createMapUpdate(buffer, MapReader.valueTypeForMapUpdate(currentLevel), key, key);
        }
        return MapReader.createMapUpdate(buffer, MapReader.valueTypeForMapUpdate(currentLevel), key, topLevelKey);
    }

    public static ValueUpdate createMapUpdate(TokenBuffer buffer, Field field) {
        buffer.next();
        MapValueUpdate m = (MapValueUpdate)MapReader.createMapUpdate(buffer, field.getDataType(), null, null);
        buffer.next();
        return m;
    }

    private static DataType valueTypeForMapUpdate(DataType parentType) {
        if (parentType instanceof WeightedSetDataType) {
            return DataType.INT;
        }
        if (parentType instanceof CollectionDataType) {
            return ((CollectionDataType)parentType).getNestedType();
        }
        if (parentType instanceof MapDataType) {
            return ((MapDataType)parentType).getValueType();
        }
        throw new UnsupportedOperationException("Unexpected parent type: " + parentType);
    }

    private static FieldValue keyTypeForMapUpdate(TokenBuffer.Token element, DataType expectedType) {
        FieldValue v;
        if (expectedType instanceof ArrayDataType) {
            v = new IntegerFieldValue(Integer.valueOf(element.text));
        } else if (expectedType instanceof WeightedSetDataType) {
            v = ((WeightedSetDataType)expectedType).getNestedType().createFieldValue(element.text);
        } else if (expectedType instanceof MapDataType) {
            v = ((MapDataType)expectedType).getKeyType().createFieldValue(element.text);
        } else {
            throw new IllegalArgumentException("Container type " + expectedType + " not supported for match update.");
        }
        return v;
    }
}

