/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.update;

import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;

public class TensorModifyUpdate
extends ValueUpdate<TensorFieldValue> {
    protected Operation operation;
    protected TensorFieldValue tensor;

    public TensorModifyUpdate(Operation operation, TensorFieldValue tensor) {
        super(ValueUpdate.ValueUpdateClassID.TENSORMODIFY);
        this.operation = operation;
        this.tensor = tensor;
        this.verifyCompatibleType(tensor.getDataType().getTensorType());
    }

    private void verifyCompatibleType(TensorType type) {
        if (type.dimensions().stream().anyMatch(dim -> dim.isIndexed())) {
            throw new IllegalArgumentException("Tensor type '" + type + "' is not compatible as it contains some indexed dimensions");
        }
    }

    public static TensorType convertDimensionsToMapped(TensorType type) {
        TensorType.Builder builder = new TensorType.Builder(type.valueType());
        type.dimensions().stream().forEach(dim -> builder.mapped(dim.name()));
        return builder.build();
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public TensorFieldValue getValue() {
        return this.tensor;
    }

    @Override
    public void setValue(TensorFieldValue value) {
        this.tensor = value;
    }

    @Override
    public FieldValue applyTo(FieldValue oldValue) {
        if (oldValue instanceof TensorFieldValue) {
            Tensor oldTensor = ((TensorFieldValue)oldValue).getTensor().orElseThrow(() -> new IllegalArgumentException("No existing tensor to apply update on"));
            if (this.tensor.getTensor().isPresent()) {
                DoubleBinaryOperator modifier;
                switch (this.operation) {
                    case REPLACE: {
                        modifier = (left, right) -> right;
                        break;
                    }
                    case ADD: {
                        modifier = (left, right) -> left + right;
                        break;
                    }
                    case MULTIPLY: {
                        modifier = (left, right) -> left * right;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown operation: " + this.operation);
                    }
                }
                Tensor modified = oldTensor.modify(modifier, this.tensor.getTensor().get().cells());
                return new TensorFieldValue(modified);
            }
        } else {
            throw new IllegalStateException("Cannot use tensor modify update on non-tensor datatype " + oldValue.getClass().getName());
        }
        return oldValue;
    }

    @Override
    protected void checkCompatibility(DataType fieldType) {
        if (!(fieldType instanceof TensorDataType)) {
            throw new UnsupportedOperationException("Expected tensor type, got " + fieldType.getName() + ".");
        }
    }

    @Override
    public void serialize(DocumentUpdateWriter data, DataType superType) {
        data.write(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TensorModifyUpdate that = (TensorModifyUpdate)o;
        return this.operation == that.operation && this.tensor.equals(that.tensor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operation, this.tensor});
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.operation.name + " " + this.tensor;
    }

    public static enum Operation {
        REPLACE(0, "replace"),
        ADD(1, "add"),
        MULTIPLY(2, "multiply");

        public final int id;
        public final String name;

        private Operation(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static Operation getOperation(int id) {
            for (Operation operation : Operation.values()) {
                if (operation.id != id) continue;
                return operation;
            }
            return null;
        }
    }
}

