/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.rule;

import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.select.BucketSet;
import com.yahoo.document.select.Context;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.ResultList;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.rule.AttributeNode;
import com.yahoo.document.select.rule.ExpressionNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ArithmeticNode
implements ExpressionNode {
    public static final int NOP = 0;
    public static final int ADD = 1;
    public static final int SUB = 2;
    public static final int MOD = 3;
    public static final int DIV = 4;
    public static final int MUL = 5;
    private final List<NodeItem> items = new ArrayList<NodeItem>();

    public ArithmeticNode add(String operator, ExpressionNode node) {
        this.items.add(new NodeItem(this.stringToOperator(operator), node));
        return this;
    }

    public List<NodeItem> getItems() {
        return this.items;
    }

    @Override
    public BucketSet getBucketSet(BucketIdFactory factory) {
        return null;
    }

    @Override
    public Object evaluate(Context context) {
        StringBuilder ret = null;
        Stack<ValueItem> buf = new Stack<ValueItem>();
        for (int i = 0; i < this.items.size(); ++i) {
            NodeItem item = this.items.get(i);
            Object val = item.node.evaluate(context);
            if (val == null) {
                throw new IllegalArgumentException("Can not perform arithmetic on null value (referencing missing field?)");
            }
            if (val instanceof AttributeNode.VariableValueList) {
                AttributeNode.VariableValueList value = (AttributeNode.VariableValueList)val;
                if (value.size() == 0) {
                    throw new IllegalArgumentException("Can not perform arithmetic on missing field: " + item.node.toString());
                }
                if (value.size() != 1) {
                    throw new IllegalStateException("Arithmetic is only valid for single values.");
                }
                val = ((ResultList.VariableValue)value.get(0)).getValue();
            }
            if (val instanceof NumericFieldValue) {
                val = ((NumericFieldValue)val).getNumber();
            }
            if (val instanceof String) {
                if (i == 0) {
                    ret = new StringBuilder();
                }
                if (ret != null) {
                    ret.append(val);
                    continue;
                }
            } else {
                if (val instanceof Number) {
                    if (!buf.isEmpty()) {
                        while (buf.peek().operator > item.operator) {
                            this.popOffTheTop(buf);
                        }
                    }
                    buf.push(new ValueItem(item.operator, (Number)val));
                    continue;
                }
                if (val == Result.INVALID) {
                    return val;
                }
            }
            throw new IllegalStateException("Term '" + item.node + " with class " + val.getClass() + "' does not evaluate to a number.");
        }
        if (ret != null) {
            return ret.toString();
        }
        while (buf.size() > 1) {
            this.popOffTheTop(buf);
        }
        return ((ValueItem)buf.pop()).value;
    }

    private void popOffTheTop(Stack<ValueItem> buf) {
        ValueItem rhs = buf.pop();
        ValueItem lhs = buf.pop();
        switch (rhs.operator) {
            case 1: {
                lhs.value = lhs.value.doubleValue() + rhs.value.doubleValue();
                break;
            }
            case 2: {
                lhs.value = lhs.value.doubleValue() - rhs.value.doubleValue();
                break;
            }
            case 4: {
                lhs.value = lhs.value.doubleValue() / rhs.value.doubleValue();
                break;
            }
            case 5: {
                lhs.value = lhs.value.doubleValue() * rhs.value.doubleValue();
                break;
            }
            case 3: {
                lhs.value = lhs.value.longValue() % rhs.value.longValue();
                break;
            }
            default: {
                throw new IllegalStateException("Arithmetic operator " + rhs.operator + " not supported.");
            }
        }
        buf.push(lhs);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (NodeItem item : this.items) {
            if (item.operator != 0) {
                ret.append(" ").append(this.operatorToString(item.operator)).append(" ");
            }
            ret.append(item.node);
        }
        return ret.toString();
    }

    public String operatorToString(int operator) {
        switch (operator) {
            case 0: {
                return null;
            }
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 3: {
                return "%";
            }
            case 4: {
                return "/";
            }
            case 5: {
                return "*";
            }
        }
        throw new IllegalStateException("Arithmetic operator " + operator + " not supported.");
    }

    private int stringToOperator(String operator) {
        if (operator == null) {
            return 0;
        }
        if (operator.equals("+")) {
            return 1;
        }
        if (operator.equals("-")) {
            return 2;
        }
        if (operator.equals("%")) {
            return 3;
        }
        if (operator.equals("/")) {
            return 4;
        }
        if (operator.equals("*")) {
            return 5;
        }
        throw new IllegalStateException("Arithmetic operator '" + operator + "' not supported.");
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public static class NodeItem {
        private int operator;
        private ExpressionNode node;

        NodeItem(int operator, ExpressionNode node) {
            this.operator = operator;
            this.node = node;
        }

        public int getOperator() {
            return this.operator;
        }

        public ExpressionNode getNode() {
            return this.node;
        }
    }

    private static class ValueItem {
        public int operator;
        public Number value;

        ValueItem(int operator, Number value) {
            this.operator = operator;
            this.value = value;
        }
    }
}

