/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.google.common.collect.ImmutableList;
import com.yahoo.collections.CollectionComparator;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlSerializationHelper;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.text.Text;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;

public class StringFieldValue
extends FieldValue {
    public static final int classId = StringFieldValue.registerClass((int)4111, StringFieldValue.class);
    private String value;
    private Map<String, SpanTree> spanTrees = null;

    public static PrimitiveDataType.Factory getFactory() {
        return new Factory();
    }

    public StringFieldValue() {
        this.value = "";
    }

    public StringFieldValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.setValue(value);
    }

    private static void validateTextString(String value) {
        OptionalInt illegalCodePoint = Text.validateTextString((String)value);
        if (illegalCodePoint.isPresent()) {
            throw new IllegalArgumentException("The string field value contains illegal code point 0x" + Integer.toHexString(illegalCodePoint.getAsInt()).toUpperCase());
        }
    }

    private void setValue(String value) {
        StringFieldValue.validateTextString(value);
        this.value = value;
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    @Override
    public StringFieldValue clone() {
        StringFieldValue strfval = (StringFieldValue)super.clone();
        if (this.spanTrees != null) {
            strfval.spanTrees = new HashMap<String, SpanTree>(this.spanTrees.size());
            for (Map.Entry<String, SpanTree> entry : this.spanTrees.entrySet()) {
                strfval.spanTrees.put(entry.getKey(), new SpanTree(entry.getValue()));
            }
        }
        return strfval;
    }

    @Override
    public void clear() {
        this.value = "";
        if (this.spanTrees != null) {
            this.spanTrees.clear();
            this.spanTrees = null;
        }
    }

    @Override
    public void assign(Object o) {
        if (this.spanTrees != null) {
            this.spanTrees.clear();
            this.spanTrees = null;
        }
        if (!this.checkAssign(o)) {
            return;
        }
        if (o instanceof StringFieldValue) {
            this.spanTrees = ((StringFieldValue)o).spanTrees;
        }
        if (o instanceof String) {
            this.setValue((String)o);
        } else if (o instanceof StringFieldValue || o instanceof NumericFieldValue) {
            this.setValue(o.toString());
        } else {
            throw new IllegalArgumentException("Class " + o.getClass() + " not applicable to an " + this.getClass() + " instance.");
        }
    }

    public Collection<SpanTree> getSpanTrees() {
        if (this.spanTrees == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.spanTrees.values());
    }

    public final Map<String, SpanTree> getSpanTreeMap() {
        return this.spanTrees;
    }

    public SpanTree getSpanTree(String name) {
        if (this.spanTrees == null) {
            return null;
        }
        return this.spanTrees.get(name);
    }

    public SpanTree setSpanTree(SpanTree spanTree) {
        if (this.spanTrees == null) {
            this.spanTrees = new HashMap<String, SpanTree>(1);
        }
        if (this.spanTrees.containsKey(spanTree.getName())) {
            throw new IllegalArgumentException("Span tree " + spanTree.getName() + " already exists.");
        }
        this.spanTrees.put(spanTree.getName(), spanTree);
        spanTree.setStringFieldValue(this);
        return spanTree;
    }

    public SpanTree removeSpanTree(String name) {
        if (this.spanTrees == null) {
            return null;
        }
        SpanTree tree = this.spanTrees.remove(name);
        if (tree != null) {
            tree.setStringFieldValue(null);
        }
        return tree;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public Object getWrappedValue() {
        return this.value;
    }

    @Override
    public void printXml(XmlStream xml) {
        XmlSerializationHelper.printStringXml(this, xml);
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringFieldValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringFieldValue that = (StringFieldValue)o;
        if (this.spanTrees != null ? !this.spanTrees.equals(that.spanTrees) : that.spanTrees != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : super.hashCode();
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    @Override
    public int compareTo(FieldValue fieldValue) {
        int comp = super.compareTo(fieldValue);
        if (comp != 0) {
            return comp;
        }
        StringFieldValue otherValue = (StringFieldValue)fieldValue;
        comp = this.value.compareTo(otherValue.value);
        if (comp != 0) {
            return comp;
        }
        if (this.spanTrees == null) {
            comp = otherValue.spanTrees == null ? 0 : -1;
        } else if (otherValue.spanTrees == null) {
            comp = 1;
        } else {
            comp = CollectionComparator.compare(this.spanTrees.keySet(), otherValue.spanTrees.keySet());
            if (comp != 0) {
                return comp;
            }
            comp = CollectionComparator.compare(this.spanTrees.values(), otherValue.spanTrees.values());
        }
        return comp;
    }

    public void setUnChecked(String s) {
        this.value = s;
    }

    private static class Factory
    extends PrimitiveDataType.Factory {
        private Factory() {
        }

        @Override
        public FieldValue create() {
            return new StringFieldValue();
        }
    }
}

