/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.GlobalId;
import com.yahoo.document.idstring.IdString;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.document.serialization.DocumentReader;
import com.yahoo.document.serialization.DocumentWriter;
import com.yahoo.document.serialization.SerializationException;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.Serializer;
import java.io.Serializable;

public class DocumentId
extends Identifiable
implements Serializable {
    private IdString id;
    private GlobalId globalId;

    public DocumentId(Deserializer buf) {
        this.deserialize(buf);
    }

    public DocumentId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot create DocumentId from null id.");
        }
        if (id.length() > 65536) {
            throw new IllegalArgumentException("The document id(" + id.length() + ") is too long(65536). However if you have already fed a document earlier on and want to remove it, you can do so by calling new DocumentId(IdString.createIdStringLessStrict()) that will bypass this restriction.");
        }
        this.id = IdString.createIdString(id);
        this.globalId = null;
    }

    public DocumentId(IdString id) {
        this.id = id;
        this.globalId = null;
    }

    public static DocumentId createFromSerialized(String id) {
        return new DocumentId(IdString.createFromSerialized(id));
    }

    public DocumentId clone() {
        return (DocumentId)super.clone();
    }

    public void setId(IdString id) {
        this.id = id;
    }

    public IdString getScheme() {
        return this.id;
    }

    public byte[] getGlobalId() {
        if (this.globalId == null) {
            this.globalId = new GlobalId(this.id);
        }
        return this.globalId.getRawId();
    }

    public int compareTo(Object o) {
        DocumentId cmp = (DocumentId)o;
        return this.id.toString().compareTo(cmp.id.toString());
    }

    public boolean equals(Object o) {
        return o instanceof DocumentId && this.id.equals(((DocumentId)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    public void onSerialize(Serializer target) throws SerializationException {
        if (target instanceof DocumentWriter) {
            ((DocumentWriter)target).write(this);
        } else {
            target.put(null, this.id.toString());
        }
    }

    public void onDeserialize(Deserializer data) throws DeserializationException {
        this.id = data instanceof DocumentReader ? ((DocumentReader)data).readDocumentId().getScheme() : IdString.createFromSerialized(data.getString(null));
    }

    public boolean hasDocType() {
        return this.id.hasDocType();
    }

    public String getDocType() {
        return this.id.getDocType();
    }
}

