/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.JsonParserHelpers;
import com.yahoo.document.update.TensorRemoveUpdate;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;

public class TensorRemoveUpdateReader {
    public static final String TENSOR_ADDRESSES = "addresses";

    static TensorRemoveUpdate createTensorRemoveUpdate(TokenBuffer buffer, Field field) {
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        TensorRemoveUpdateReader.expectTensorTypeHasSparseDimensions(field);
        TensorDataType tensorDataType = (TensorDataType)field.getDataType();
        TensorType originalType = tensorDataType.getTensorType();
        TensorType convertedType = TensorRemoveUpdate.extractSparseDimensions(originalType);
        Tensor tensor = TensorRemoveUpdateReader.readRemoveUpdateTensor(buffer, convertedType, originalType);
        TensorRemoveUpdateReader.expectAddressesAreNonEmpty(field, tensor);
        return new TensorRemoveUpdate(new TensorFieldValue(tensor));
    }

    private static void expectTensorTypeHasSparseDimensions(Field field) {
        TensorType tensorType = ((TensorDataType)field.getDataType()).getTensorType();
        if (tensorType.dimensions().stream().allMatch(TensorType.Dimension::isIndexed)) {
            throw new IllegalArgumentException("A remove update can only be applied to tensors with at least one sparse dimension. Field '" + field.getName() + "' has unsupported tensor type '" + tensorType + "'");
        }
    }

    private static void expectAddressesAreNonEmpty(Field field, Tensor tensor) {
        if (tensor.isEmpty()) {
            throw new IllegalArgumentException("Remove update for field '" + field.getName() + "' does not contain tensor addresses");
        }
    }

    private static Tensor readRemoveUpdateTensor(TokenBuffer buffer, TensorType type, TensorType originalType) {
        Tensor.Builder builder = Tensor.Builder.of((TensorType)type);
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            if (TENSOR_ADDRESSES.equals(buffer.currentName())) {
                JsonParserHelpers.expectArrayStart(buffer.currentToken());
                int nesting = buffer.nesting();
                buffer.next();
                while (buffer.nesting() >= nesting) {
                    builder.cell(TensorRemoveUpdateReader.readTensorAddress(buffer, type, originalType), 1.0);
                    buffer.next();
                }
                JsonParserHelpers.expectCompositeEnd(buffer.currentToken());
            }
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        return builder.build();
    }

    private static TensorAddress readTensorAddress(TokenBuffer buffer, TensorType type, TensorType originalType) {
        TensorAddress.Builder builder = new TensorAddress.Builder(type);
        JsonParserHelpers.expectObjectStart(buffer.currentToken());
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            String dimension = buffer.currentName();
            if (type.dimension(dimension).isEmpty() && originalType.dimension(dimension).isPresent()) {
                throw new IllegalArgumentException("Indexed dimension address '" + dimension + "' should not be specified in remove update");
            }
            String label = buffer.currentText();
            builder.add(dimension, label);
            buffer.next();
        }
        JsonParserHelpers.expectObjectEnd(buffer.currentToken());
        return builder.build();
    }
}

