/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

public class DocumentUtil {
    public static int calculateMaxPendingSize(double maxConcurrentFactor, double documentExpansionFactor, int containerCoreMemoryMb) {
        long heapBytes = Runtime.getRuntime().maxMemory();
        long heapMb = heapBytes / 1024L / 1024L;
        double maxPendingMb = (double)(heapMb - (long)containerCoreMemoryMb) / (1.0 + maxConcurrentFactor * documentExpansionFactor);
        long maxPendingBytes = (long)(maxPendingMb * 1024.0) * 1024L;
        if (maxPendingBytes < 0x100000L) {
            maxPendingBytes = 0x100000L;
        }
        if (maxPendingBytes > heapBytes / 5L) {
            maxPendingBytes = heapBytes / 5L;
        }
        if (maxPendingBytes > 0x40000000L) {
            maxPendingBytes = 0x40000000L;
        }
        return (int)maxPendingBytes;
    }
}

