/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json.readers;

import com.fasterxml.jackson.core.JsonToken;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.json.JsonReaderException;
import com.yahoo.document.json.TokenBuffer;
import com.yahoo.document.json.readers.SingleValueReader;

public class StructReader {
    public static void fillStruct(TokenBuffer buffer, StructuredFieldValue parent) {
        int initNesting = buffer.nesting();
        buffer.next();
        while (buffer.nesting() >= initNesting) {
            Field f = StructReader.getField(buffer, parent);
            try {
                if (buffer.currentToken() != JsonToken.VALUE_NULL) {
                    FieldValue v = SingleValueReader.readSingleValue(buffer, f.getDataType());
                    parent.setFieldValue(f, v);
                }
                buffer.next();
            }
            catch (IllegalArgumentException e) {
                throw new JsonReaderException(f, (Throwable)e);
            }
        }
    }

    public static Field getField(TokenBuffer buffer, StructuredFieldValue parent) {
        Field f = parent.getField(buffer.currentName());
        if (f == null) {
            throw new NullPointerException("Could not get field \"" + buffer.currentName() + "\" in the structure of type \"" + parent.getDataType().getDataTypeName() + "\".");
        }
        return f;
    }
}

