/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.datatypes;

import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.document.serialization.FieldWriter;
import com.yahoo.document.serialization.XmlStream;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.objects.FieldBase;
import java.util.Optional;

public class TensorFieldValue
extends FieldValue {
    private Optional<Tensor> tensor;
    private final TensorDataType dataType;

    public TensorFieldValue(TensorType type) {
        this.dataType = new TensorDataType(type);
        this.tensor = Optional.empty();
    }

    public TensorFieldValue(Tensor tensor) {
        this.dataType = new TensorDataType(tensor.type());
        this.tensor = Optional.of(tensor);
    }

    public Optional<Tensor> getTensor() {
        return this.tensor;
    }

    @Override
    public TensorDataType getDataType() {
        return this.dataType;
    }

    public String toString() {
        if (this.tensor.isPresent()) {
            return this.tensor.get().toString();
        }
        return "null";
    }

    @Override
    public void printXml(XmlStream xml) {
    }

    @Override
    public void clear() {
        this.tensor = Optional.empty();
    }

    @Override
    public void assign(Object o) {
        if (o == null) {
            this.assignTensor(Optional.empty());
        } else if (o instanceof Tensor) {
            this.assignTensor(Optional.of((Tensor)o));
        } else if (o instanceof TensorFieldValue) {
            this.assignTensor(((TensorFieldValue)o).getTensor());
        } else {
            throw new IllegalArgumentException("Expected class '" + this.getClass().getName() + "', got '" + o.getClass().getName() + "'.");
        }
    }

    public void assignTensor(Optional<Tensor> tensor) {
        if (tensor.isPresent() && !tensor.get().type().isAssignableTo(this.dataType.getTensorType())) {
            throw new IllegalArgumentException("Type mismatch: Cannot assign tensor of type " + tensor.get().type() + " to field of type " + this.dataType.getTensorType());
        }
        this.tensor = tensor;
    }

    @Override
    public void serialize(Field field, FieldWriter writer) {
        writer.write((FieldBase)field, this);
    }

    @Override
    public void deserialize(Field field, FieldReader reader) {
        reader.read((FieldBase)field, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TensorFieldValue)) {
            return false;
        }
        TensorFieldValue other = (TensorFieldValue)o;
        if (!this.dataType.getTensorType().equals((Object)other.dataType.getTensorType())) {
            return false;
        }
        return this.tensor.equals(other.tensor);
    }

    @Override
    public Object getWrappedValue() {
        return this.tensor.orElse(null);
    }
}

