/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.idstring;

import com.yahoo.document.idstring.IdIdString;
import com.yahoo.text.Text;
import com.yahoo.text.Utf8String;
import java.util.OptionalInt;

public abstract class IdString {
    private final Scheme scheme;
    private final String namespace;
    private final String namespaceSpecific;
    private Utf8String cache;

    public boolean hasDocType() {
        return false;
    }

    public String getDocType() {
        return "";
    }

    public boolean hasGroup() {
        return false;
    }

    public boolean hasNumber() {
        return false;
    }

    public long getNumber() {
        return 0L;
    }

    public String getGroup() {
        return "";
    }

    public static IdString createIdString(String id) {
        IdString.validateTextString(id);
        return IdString.parseAndCreate(id);
    }

    public static IdString createFromSerialized(String id) {
        IdString.validateNoZeroBytes(id);
        return IdString.parseAndCreate(id);
    }

    private static void validateTextString(String id) {
        OptionalInt illegalCodePoint = Text.validateTextString((String)id);
        if (illegalCodePoint.isPresent()) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Contains illegal code point 0x" + Integer.toHexString(illegalCodePoint.getAsInt()).toUpperCase());
        }
    }

    private static void validateNoZeroBytes(String id) {
        for (int i = 0; i < id.length(); ++i) {
            if (id.codePointAt(i) != 0) continue;
            throw new IllegalArgumentException("Unparseable id '" + id + "': Contains illegal zero byte code point");
        }
    }

    private static IdString parseAndCreate(String id) {
        int schemePos = id.indexOf(":");
        if (schemePos < 0) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Scheme missing");
        }
        String schemeStr = id.substring(0, schemePos);
        int currPos = schemePos + 1;
        int colonPos = id.indexOf(":", currPos);
        if (colonPos < 0) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Namespace missing");
        }
        String namespace = id.substring(currPos, colonPos);
        if (namespace.length() == 0) {
            throw new IllegalArgumentException("Unparseable id '" + id + "': Namespace must be non-empty");
        }
        currPos = colonPos + 1;
        if (schemeStr.equals("id")) {
            colonPos = id.indexOf(":", currPos);
            if (colonPos < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': Document type missing");
            }
            String type = id.substring(currPos, colonPos);
            currPos = colonPos + 1;
            if ((colonPos = id.indexOf(":", currPos)) < 0) {
                throw new IllegalArgumentException("Unparseable id '" + id + "': Key/value section missing");
            }
            String keyValues = id.substring(currPos, colonPos);
            currPos = colonPos + 1;
            return new IdIdString(namespace, type, keyValues, id.substring(currPos));
        }
        throw new IllegalArgumentException("Unknown id scheme '" + schemeStr + "'");
    }

    protected IdString(Scheme scheme, String namespace, String namespaceSpecific) {
        this.scheme = scheme;
        this.namespace = namespace;
        this.namespaceSpecific = namespaceSpecific;
    }

    public Scheme getType() {
        return this.scheme;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceSpecific() {
        return this.namespaceSpecific;
    }

    public abstract long getLocation();

    public String getSchemeParameters() {
        return "";
    }

    public abstract String getSchemeSpecific();

    public boolean equals(Object o) {
        return o instanceof IdString && o.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private Utf8String createToString() {
        return new Utf8String(this.scheme.toString() + this.getSchemeParameters() + ":" + this.namespace + ":" + this.getSchemeSpecific() + this.namespaceSpecific);
    }

    public String toString() {
        if (this.cache == null) {
            this.cache = this.createToString();
        }
        return this.cache.toString();
    }

    public Utf8String toUtf8() {
        if (this.cache == null) {
            this.cache = this.createToString();
        }
        return this.cache;
    }

    public static enum Scheme {
        id;

    }
}

