/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.compress.CompressionType;
import com.yahoo.config.InnerNode;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CompressionConfig;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.log.LogLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentTypeManagerConfigurer
implements ConfigSubscriber.SingleSubscriber<DocumentmanagerConfig> {
    private static final Logger log = Logger.getLogger(DocumentTypeManagerConfigurer.class.getName());
    private DocumentTypeManager managerToConfigure;

    public DocumentTypeManagerConfigurer(DocumentTypeManager manager) {
        this.managerToConfigure = manager;
    }

    private static CompressionConfig makeCompressionConfig(DocumentmanagerConfig.Datatype.Structtype cfg) {
        return new CompressionConfig(DocumentTypeManagerConfigurer.toCompressorType(cfg.compresstype()), cfg.compresslevel(), cfg.compressthreshold(), cfg.compressminsize());
    }

    public static CompressionType toCompressorType(DocumentmanagerConfig.Datatype.Structtype.Compresstype.Enum value) {
        switch (value) {
            case NONE: {
                return CompressionType.NONE;
            }
            case LZ4: {
                return CompressionType.LZ4;
            }
            case UNCOMPRESSABLE: {
                return CompressionType.INCOMPRESSIBLE;
            }
        }
        throw new IllegalArgumentException("Compression type " + (Object)((Object)value) + " is not supported");
    }

    public static ConfigSubscriber configure(DocumentTypeManager manager, String configId) {
        return new DocumentTypeManagerConfigurer(manager).configure(configId);
    }

    public ConfigSubscriber configure(String configId) {
        ConfigSubscriber subscriber = new ConfigSubscriber();
        subscriber.subscribe((ConfigSubscriber.SingleSubscriber)this, DocumentmanagerConfig.class, configId);
        return subscriber;
    }

    static void configureNewManager(DocumentmanagerConfig config, DocumentTypeManager manager) {
        if (config == null) {
            return;
        }
        DocumentTypeManagerConfigurer.setupAnnotationTypesWithoutPayloads(config, manager);
        DocumentTypeManagerConfigurer.setupAnnotationRefTypes(config, manager);
        log.log((Level)LogLevel.DEBUG, "Configuring document manager with " + config.datatype().size() + " data types.");
        ArrayList<DocumentmanagerConfig.Datatype> failed = new ArrayList<DocumentmanagerConfig.Datatype>();
        failed.addAll(config.datatype());
        while (!failed.isEmpty()) {
            ArrayList<DocumentmanagerConfig.Datatype> tmp = failed;
            failed = new ArrayList();
            for (int i = 0; i < tmp.size(); ++i) {
                DocumentmanagerConfig.Datatype thisDataType = (DocumentmanagerConfig.Datatype)((Object)tmp.get(i));
                int id = thisDataType.id();
                try {
                    DocumentTypeManagerConfigurer.registerTypeIdMapping(config, manager, thisDataType, id);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    failed.add(thisDataType);
                }
            }
        }
        DocumentTypeManagerConfigurer.addStructInheritance(config, manager);
        DocumentTypeManagerConfigurer.addAnnotationTypePayloads(config, manager);
        DocumentTypeManagerConfigurer.addAnnotationTypeInheritance(config, manager);
        manager.replaceTemporaryTypes();
    }

    private static void registerTypeIdMapping(DocumentmanagerConfig config, DocumentTypeManager manager, DocumentmanagerConfig.Datatype thisDataType, int id) {
        for (DocumentmanagerConfig.Datatype.Arraytype arraytype : thisDataType.arraytype()) {
            DocumentTypeManagerConfigurer.registerArrayType(manager, id, arraytype);
        }
        for (InnerNode innerNode : thisDataType.maptype()) {
            DocumentTypeManagerConfigurer.registerMapType(manager, id, (DocumentmanagerConfig.Datatype.Maptype)innerNode);
        }
        for (InnerNode innerNode : thisDataType.weightedsettype()) {
            DocumentTypeManagerConfigurer.registerWeightedSetType(manager, id, (DocumentmanagerConfig.Datatype.Weightedsettype)innerNode);
        }
        for (InnerNode innerNode : thisDataType.structtype()) {
            DocumentTypeManagerConfigurer.registerStructType(config, manager, id, (DocumentmanagerConfig.Datatype.Structtype)innerNode);
        }
        for (InnerNode innerNode : thisDataType.documenttype()) {
            DocumentTypeManagerConfigurer.registerDocumentType(manager, (DocumentmanagerConfig.Datatype.Documenttype)innerNode);
        }
        for (InnerNode innerNode : thisDataType.referencetype()) {
            DocumentTypeManagerConfigurer.registerReferenceType(manager, id, (DocumentmanagerConfig.Datatype.Referencetype)innerNode);
        }
    }

    private static void registerArrayType(DocumentTypeManager manager, int id, DocumentmanagerConfig.Datatype.Arraytype array) {
        DataType nestedType = manager.getDataType(array.datatype(), "");
        ArrayDataType type = new ArrayDataType(nestedType, id);
        manager.register(type);
    }

    private static void registerMapType(DocumentTypeManager manager, int id, DocumentmanagerConfig.Datatype.Maptype map) {
        DataType keyType = manager.getDataType(map.keytype(), "");
        DataType valType = manager.getDataType(map.valtype(), "");
        MapDataType type = new MapDataType(keyType, valType, id);
        manager.register(type);
    }

    private static void registerWeightedSetType(DocumentTypeManager manager, int id, DocumentmanagerConfig.Datatype.Weightedsettype wset) {
        DataType nestedType = manager.getDataType(wset.datatype(), "");
        WeightedSetDataType type = new WeightedSetDataType(nestedType, wset.createifnonexistant(), wset.removeifzero(), id);
        manager.register(type);
    }

    private static void registerDocumentType(DocumentTypeManager manager, DocumentmanagerConfig.Datatype.Documenttype doc) {
        StructDataType header = (StructDataType)manager.getDataType(doc.headerstruct(), "");
        StructDataType body = (StructDataType)manager.getDataType(doc.bodystruct(), "");
        for (Field field : body.getFields()) {
            field.setHeader(false);
        }
        DocumentType type = new DocumentType(doc.name(), header, body);
        for (DocumentmanagerConfig.Datatype.Documenttype.Inherits j : doc.inherits()) {
            DocumentmanagerConfig.Datatype.Documenttype.Inherits parent = j;
            DataTypeName name = new DataTypeName(parent.name());
            DocumentType parentType = manager.getDocumentType(name);
            if (parentType == null) {
                throw new IllegalArgumentException("Could not find document type '" + name.toString() + "'.");
            }
            type.inherit(parentType);
        }
        manager.register(type);
    }

    private static void registerStructType(DocumentmanagerConfig config, DocumentTypeManager manager, int id, DocumentmanagerConfig.Datatype.Structtype struct) {
        StructDataType type = new StructDataType(id, struct.name());
        if (config.enablecompression()) {
            CompressionConfig comp = DocumentTypeManagerConfigurer.makeCompressionConfig(struct);
            type.setCompressionConfig(comp);
        }
        for (DocumentmanagerConfig.Datatype.Structtype.Field j : struct.field()) {
            DataType fieldType;
            DocumentmanagerConfig.Datatype.Structtype.Field field = j;
            DataType dataType = fieldType = field.datatype() == id ? manager.getDataTypeAndReturnTemporary(field.datatype(), field.detailedtype()) : manager.getDataType(field.datatype(), field.detailedtype());
            if (field.id().size() == 1) {
                type.addField(new Field(field.name(), field.id().get(0).id(), fieldType, true));
                continue;
            }
            type.addField(new Field(field.name(), fieldType, true));
        }
        manager.register(type);
    }

    private static void registerReferenceType(DocumentTypeManager manager, int id, DocumentmanagerConfig.Datatype.Referencetype refType) {
        ReferenceDataType referenceType;
        if (manager.hasDataType(refType.target_type_id())) {
            DocumentType targetDocType = (DocumentType)manager.getDataType(refType.target_type_id());
            referenceType = new ReferenceDataType(targetDocType, id);
        } else {
            TemporaryStructuredDataType temporaryTargetType = TemporaryStructuredDataType.createById(refType.target_type_id());
            referenceType = new ReferenceDataType(temporaryTargetType, id);
        }
        manager.register(referenceType);
    }

    public static DocumentTypeManager configureNewManager(DocumentmanagerConfig config) {
        DocumentTypeManager manager = new DocumentTypeManager();
        if (config == null) {
            return manager;
        }
        DocumentTypeManagerConfigurer.configureNewManager(config, manager);
        return manager;
    }

    public void configure(DocumentmanagerConfig config) {
        DocumentTypeManager manager = DocumentTypeManagerConfigurer.configureNewManager(config);
        int defaultTypeCount = new DocumentTypeManager().getDataTypes().size();
        if (this.managerToConfigure.getDataTypes().size() != defaultTypeCount) {
            log.log((Level)LogLevel.DEBUG, "Live document config overwritten with new config.");
        }
        this.managerToConfigure.assign(manager);
    }

    private static void setupAnnotationRefTypes(DocumentmanagerConfig config, DocumentTypeManager manager) {
        for (int i = 0; i < config.datatype().size(); ++i) {
            DocumentmanagerConfig.Datatype thisDataType = config.datatype(i);
            int id = thisDataType.id();
            Iterator<DocumentmanagerConfig.Datatype.Annotationreftype> iterator = thisDataType.annotationreftype().iterator();
            while (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Annotationreftype o;
                DocumentmanagerConfig.Datatype.Annotationreftype annRefType = o = iterator.next();
                AnnotationType annotationType = manager.getAnnotationTypeRegistry().getType(annRefType.annotation());
                if (annotationType == null) {
                    throw new IllegalArgumentException("Found reference to " + annRefType.annotation() + ", which does not exist!");
                }
                AnnotationReferenceDataType type = new AnnotationReferenceDataType(annotationType, id);
                manager.register(type);
            }
        }
    }

    private static void setupAnnotationTypesWithoutPayloads(DocumentmanagerConfig config, DocumentTypeManager manager) {
        for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
            AnnotationType annotationType = new AnnotationType(annType.name(), annType.id());
            manager.getAnnotationTypeRegistry().register(annotationType);
        }
    }

    private static void addAnnotationTypePayloads(DocumentmanagerConfig config, DocumentTypeManager manager) {
        for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
            AnnotationType annotationType = manager.getAnnotationTypeRegistry().getType(annType.id());
            DataType payload = manager.getDataType(annType.datatype(), "");
            if (payload.equals(DataType.NONE)) continue;
            annotationType.setDataType(payload);
        }
    }

    private static void addAnnotationTypeInheritance(DocumentmanagerConfig config, DocumentTypeManager manager) {
        for (DocumentmanagerConfig.Annotationtype annType : config.annotationtype()) {
            if (annType.inherits().size() <= 0) continue;
            AnnotationType inheritedType = manager.getAnnotationTypeRegistry().getType(annType.inherits(0).id());
            AnnotationType type = manager.getAnnotationTypeRegistry().getType(annType.id());
            type.inherit(inheritedType);
        }
    }

    private static void addStructInheritance(DocumentmanagerConfig config, DocumentTypeManager manager) {
        for (int i = 0; i < config.datatype().size(); ++i) {
            DocumentmanagerConfig.Datatype thisDataType = config.datatype(i);
            int id = thisDataType.id();
            Iterator<DocumentmanagerConfig.Datatype.Structtype> iterator = thisDataType.structtype().iterator();
            while (iterator.hasNext()) {
                DocumentmanagerConfig.Datatype.Structtype o;
                DocumentmanagerConfig.Datatype.Structtype struct = o = iterator.next();
                StructDataType thisStruct = (StructDataType)manager.getDataType(id, "");
                for (DocumentmanagerConfig.Datatype.Structtype.Inherits parent : struct.inherits()) {
                    StructDataType parentStruct = (StructDataType)manager.getDataType(parent.name());
                    thisStruct.inherit(parentStruct);
                }
            }
        }
    }
}

