/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.serialization;

import com.yahoo.collections.Tuple2;
import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AlternateSpanList;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanNodeParent;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;
import com.yahoo.document.predicate.BinaryFormat;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.document.serialization.DocumentDeserializer;
import com.yahoo.document.serialization.SerializationException;
import com.yahoo.document.serialization.VespaDocumentSerializer42;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.text.Utf8;
import com.yahoo.text.Utf8Array;
import com.yahoo.text.Utf8String;
import com.yahoo.vespa.objects.FieldBase;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

@Deprecated
public class VespaDocumentDeserializer42
extends VespaDocumentSerializer42
implements DocumentDeserializer {
    private final Compressor compressor = new Compressor();
    private DocumentTypeManager manager;
    GrowableByteBuffer body;
    private short version;
    private List<SpanNode> spanNodes;
    private List<Annotation> annotations;
    private int[] stringPositions;

    VespaDocumentDeserializer42(DocumentTypeManager manager, GrowableByteBuffer header, GrowableByteBuffer body, short version) {
        super(header);
        this.manager = manager;
        this.body = body;
        this.version = version;
    }

    VespaDocumentDeserializer42(DocumentTypeManager manager, GrowableByteBuffer buf) {
        this(manager, buf, null, 8);
    }

    VespaDocumentDeserializer42(DocumentTypeManager manager, GrowableByteBuffer buf, GrowableByteBuffer body) {
        this(manager, buf, body, 8);
    }

    public final DocumentTypeManager getDocumentTypeManager() {
        return this.manager;
    }

    @Override
    public void read(Document document) {
        this.read(null, document);
    }

    @Override
    public void read(FieldBase field, Document doc) {
        this.version = this.getShort(null);
        if (this.version < 6 || this.version > 8) {
            throw new DeserializationException("Unknown version " + this.version + ", expected " + 8 + ".");
        }
        int dataLength = 0;
        int dataPos = 0;
        if (this.version < 7) {
            this.getInt2_4_8Bytes(null);
        } else {
            dataLength = this.getInt(null);
            dataPos = this.position();
        }
        doc.setId(this.readDocumentId());
        Byte content = this.getByte(null);
        doc.setDataType(this.readDocumentType());
        if ((content & 2) != 0) {
            doc.getHeader().deserialize(new Field("header"), this);
        }
        if ((content & 4) != 0) {
            doc.getBody().deserialize(new Field("body"), this);
        } else if (this.body != null) {
            GrowableByteBuffer header = this.getBuf();
            this.setBuf(this.body);
            this.body = null;
            doc.getBody().deserialize(new Field("body"), this);
            this.body = this.getBuf();
            this.setBuf(header);
        }
        if (this.version < 8) {
            int n = this.getInt(null);
        }
        if (this.version > 6 && dataLength != this.position() - dataPos) {
            throw new DeserializationException("Length mismatch");
        }
    }

    @Override
    public void read(FieldBase field, FieldValue value) {
        throw new IllegalArgumentException("read not implemented yet.");
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, Array<T> array) {
        int numElements = this.getNumCollectionElems();
        ArrayList<FieldValue> list = new ArrayList<FieldValue>(numElements);
        ArrayDataType type = array.getDataType();
        for (int i = 0; i < numElements; ++i) {
            if (this.version < 7) {
                this.getInt(null);
            }
            FieldValue fv = type.getNestedType().createFieldValue();
            fv.deserialize(null, this);
            list.add(fv);
        }
        array.clear();
        array.addAll(list);
    }

    @Override
    public <K extends FieldValue, V extends FieldValue> void read(FieldBase field, MapFieldValue<K, V> map) {
        int numElements = this.getNumCollectionElems();
        HashMap<FieldValue, FieldValue> hash = new HashMap<FieldValue, FieldValue>();
        MapDataType type = map.getDataType();
        for (int i = 0; i < numElements; ++i) {
            if (this.version < 7) {
                this.getInt(null);
            }
            FieldValue key = type.getKeyType().createFieldValue();
            FieldValue val = type.getValueType().createFieldValue();
            key.deserialize(null, this);
            val.deserialize(null, this);
            hash.put(key, val);
        }
        map.clear();
        map.putAll(hash);
    }

    private int getNumCollectionElems() {
        int numElements;
        if (this.version < 7) {
            this.getInt(null);
            numElements = this.getInt(null);
        } else {
            numElements = this.getInt1_2_4Bytes(null);
        }
        if (numElements < 0) {
            throw new DeserializationException("Bad number of array/map elements, " + numElements);
        }
        return numElements;
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, CollectionFieldValue<T> value) {
        throw new IllegalArgumentException("read not implemented yet.");
    }

    @Override
    public void read(FieldBase field, ByteFieldValue value) {
        value.assign(this.getByte(null));
    }

    @Override
    public void read(FieldBase field, DoubleFieldValue value) {
        value.assign(this.getDouble(null));
    }

    @Override
    public void read(FieldBase field, FloatFieldValue value) {
        value.assign(Float.valueOf(this.getFloat(null)));
    }

    @Override
    public void read(FieldBase field, IntegerFieldValue value) {
        value.assign(this.getInt(null));
    }

    @Override
    public void read(FieldBase field, LongFieldValue value) {
        value.assign(this.getLong(null));
    }

    @Override
    public void read(FieldBase field, Raw value) {
        int rawsize = this.getInt(null);
        byte[] rawBytes = this.getBytes(null, rawsize);
        value.assign(rawBytes);
    }

    @Override
    public void read(FieldBase field, PredicateFieldValue value) {
        int len = this.getInt(null);
        byte[] buf = this.getBytes(null, len);
        value.assign(BinaryFormat.decode((byte[])buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(FieldBase field, StringFieldValue value) {
        byte coding = this.getByte(null);
        int length = this.getInt1_4Bytes(null);
        byte[] stringArray = new byte[length - 1];
        this.buf.get(stringArray);
        this.buf.get();
        value.setUnChecked(Utf8.toString((byte[])stringArray));
        if ((coding & 0x40) == 64) {
            try {
                this.stringPositions = Utf8.calculateStringPositions((byte[])stringArray);
                int size = this.buf.getInt();
                int startPos = this.buf.position();
                int numSpanTrees = this.buf.getInt1_2_4Bytes();
                for (int i = 0; i < numSpanTrees; ++i) {
                    SpanTree tree = new SpanTree();
                    StringFieldValue treeName = new StringFieldValue();
                    treeName.deserialize(this);
                    tree.setName(treeName.getString());
                    value.setSpanTree(tree);
                    this.readSpanTree(tree, false);
                }
                this.buf.position(startPos + size);
            }
            finally {
                this.stringPositions = null;
            }
        }
    }

    @Override
    public void read(FieldBase field, TensorFieldValue value) {
        int encodedTensorLength = this.buf.getInt1_4Bytes();
        if (encodedTensorLength > 0) {
            byte[] encodedTensor = this.getBytes(null, encodedTensorLength);
            value.assign(TypedBinaryFormat.decode(Optional.of(value.getDataType().getTensorType()), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])encodedTensor)));
        } else {
            value.clear();
        }
    }

    @Override
    public void read(FieldBase field, ReferenceFieldValue value) {
        boolean documentIdPresent;
        boolean bl = documentIdPresent = this.buf.get() != 0;
        if (documentIdPresent) {
            value.assign(this.readDocumentId());
        } else {
            value.clear();
        }
    }

    @Override
    public void read(FieldBase fieldDef, Struct s) {
        int dataSize;
        s.setVersion(this.version);
        int startPos = this.position();
        if (this.version < 6) {
            throw new DeserializationException("Illegal document serialization version " + this.version);
        }
        if (this.version < 7) {
            long rSize = this.getInt2_4_8Bytes(null);
            if (rSize > Integer.MAX_VALUE) {
                throw new DeserializationException("Raw size of data block is too large.");
            }
            dataSize = (int)rSize;
        } else {
            dataSize = this.getInt(null);
        }
        byte comprCode = this.getByte(null);
        CompressionType compression = CompressionType.valueOf((byte)comprCode);
        int uncompressedSize = 0;
        if (compression != CompressionType.NONE && compression != CompressionType.INCOMPRESSIBLE) {
            long pSize = this.getInt2_4_8Bytes(null);
            if (pSize > Integer.MAX_VALUE) {
                throw new DeserializationException("Uncompressed size of data block is too large.");
            }
            uncompressedSize = (int)pSize;
        }
        int numberOfFields = this.getInt1_4Bytes(null);
        ArrayList<Tuple2> fieldIdsAndLengths = new ArrayList<Tuple2>(numberOfFields);
        for (int i = 0; i < numberOfFields; ++i) {
            fieldIdsAndLengths.add(new Tuple2((Object)this.getInt1_4Bytes(null), (Object)this.getInt2_4_8Bytes(null)));
        }
        GrowableByteBuffer bigBuf = this.buf;
        if (this.version < 7) {
            int headerSize = this.position() - startPos;
            dataSize -= headerSize;
        }
        byte[] destination = this.compressor.decompress(compression, this.getBuf().array(), this.position(), uncompressedSize, Optional.of(dataSize));
        this.position(this.position() + dataSize);
        this.buf = GrowableByteBuffer.wrap((byte[])destination);
        s.clear();
        StructDataType type = s.getDataType();
        for (int i = 0; i < numberOfFields; ++i) {
            Field structField = type.getField((Integer)((Tuple2)fieldIdsAndLengths.get((int)i)).first, this.version);
            if (structField == null) {
                this.position(this.position() + ((Long)((Tuple2)fieldIdsAndLengths.get((int)i)).second).intValue());
                continue;
            }
            int posBefore = this.position();
            FieldValue value = structField.getDataType().createFieldValue();
            value.deserialize(structField, this);
            s.setFieldValue(structField, value);
            this.position(posBefore + ((Long)((Tuple2)fieldIdsAndLengths.get((int)i)).second).intValue());
        }
        this.buf = bigBuf;
    }

    @Override
    public void read(FieldBase field, StructuredFieldValue value) {
        throw new IllegalArgumentException("read not implemented yet.");
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, WeightedSet<T> ws) {
        WeightedSetDataType type = ws.getDataType();
        this.getInt(null);
        int numElements = this.getInt(null);
        if (numElements < 0) {
            throw new DeserializationException("Bad number of weighted set elements, " + numElements);
        }
        ws.clearAndReserve(numElements * 2);
        for (int i = 0; i < numElements; ++i) {
            int size = this.getInt(null);
            FieldValue value = type.getNestedType().createFieldValue();
            value.deserialize(null, this);
            IntegerFieldValue weight = new IntegerFieldValue(this.getInt(null));
            ws.putUnChecked(value, weight);
        }
    }

    @Override
    public void read(FieldBase field, AnnotationReference value) {
        int seqId = this.buf.getInt1_2_4Bytes();
        try {
            Annotation a = this.annotations.get(seqId);
            value.setReferenceNoCompatibilityCheck(a);
        }
        catch (IndexOutOfBoundsException iiobe) {
            throw new SerializationException("Could not serialize AnnotationReference value, reference not found.", iiobe);
        }
    }

    private Utf8String deserializeAttributeString() throws DeserializationException {
        byte length = this.getByte(null);
        return new Utf8String((AbstractUtf8Array)this.parseNullTerminatedString(length));
    }

    private Utf8Array parseNullTerminatedString() {
        return VespaDocumentDeserializer42.parseNullTerminatedString(this.getBuf().getByteBuffer());
    }

    private Utf8Array parseNullTerminatedString(int lengthExcludingNull) {
        return VespaDocumentDeserializer42.parseNullTerminatedString(this.getBuf().getByteBuffer(), lengthExcludingNull);
    }

    static Utf8Array parseNullTerminatedString(ByteBuffer buf, int lengthExcludingNull) throws DeserializationException {
        Utf8Array utf8 = new Utf8Array(buf, lengthExcludingNull);
        buf.get();
        return utf8;
    }

    static Utf8Array parseNullTerminatedString(ByteBuffer buf) throws DeserializationException {
        int end = VespaDocumentDeserializer42.getFirstNullByte(buf);
        if (end == -1) {
            throw new DeserializationException("Could not locate terminating 0-byte for string");
        }
        return VespaDocumentDeserializer42.parseNullTerminatedString(buf, end - buf.position());
    }

    private static int getFirstNullByte(ByteBuffer buf) {
        int end = -1;
        int start = buf.position();
        try {
            byte dataByte;
            while ((dataByte = buf.get()) != 0) {
            }
            end = buf.position() - 1;
        }
        catch (Exception e) {
            // empty catch block
        }
        buf.position(start);
        return end;
    }

    @Override
    public void read(DocumentUpdate update) {
        short serializationVersion = this.getShort(null);
        update.setId(new DocumentId(this));
        byte contents = this.getByte(null);
        if ((contents & 1) == 0) {
            throw new DeserializationException("Cannot deserialize DocumentUpdate without doctype");
        }
        update.setDocumentType(this.readDocumentType());
        int size = this.getInt(null);
        for (int i = 0; i < size; ++i) {
            update.addFieldUpdate(new FieldUpdate(this, update.getDocumentType(), serializationVersion));
        }
    }

    @Override
    public void read(FieldPathUpdate update) {
        String fieldPath = this.getString(null);
        String whereClause = this.getString(null);
        update.setFieldPath(fieldPath);
        try {
            update.setWhereClause(whereClause);
        }
        catch (ParseException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void read(AssignFieldPathUpdate update) {
        byte flags = this.getByte(null);
        update.setRemoveIfZero((flags & 2) != 0);
        update.setCreateMissingPath((flags & 4) != 0);
        if ((flags & 1) != 0) {
            update.setExpression(this.getString(null));
        } else {
            DataType dt = update.getFieldPath().getResultingDataType();
            FieldValue fv = dt.createFieldValue();
            fv.deserialize(this);
            update.setNewValue(fv);
        }
    }

    @Override
    public void read(RemoveFieldPathUpdate update) {
    }

    @Override
    public void read(AddFieldPathUpdate update) {
        DataType dt = update.getFieldPath().getResultingDataType();
        FieldValue fv = dt.createFieldValue();
        dt.createFieldValue();
        fv.deserialize(this);
        if (!(fv instanceof Array)) {
            throw new DeserializationException("Add only applicable to array types");
        }
        update.setNewValues((Array)fv);
    }

    public ValueUpdate getValueUpdate(DataType superType, DataType subType) {
        int vuTypeId = this.getInt(null);
        ValueUpdate.ValueUpdateClassID op = ValueUpdate.ValueUpdateClassID.getID(vuTypeId);
        if (op == null) {
            throw new IllegalArgumentException("Read type " + vuTypeId + " of bytebuffer, but this is not a legal value update type.");
        }
        switch (op) {
            case ADD: {
                FieldValue fval = subType.createFieldValue();
                fval.deserialize(this);
                int weight = this.getInt(null);
                return new AddValueUpdate(fval, weight);
            }
            case ARITHMETIC: {
                int opId = this.getInt(null);
                ArithmeticValueUpdate.Operator operator = ArithmeticValueUpdate.Operator.getID(opId);
                double operand = this.getDouble(null);
                return new ArithmeticValueUpdate(operator, operand);
            }
            case ASSIGN: {
                byte contents = this.getByte(null);
                FieldValue fval = null;
                if (contents == 1) {
                    fval = superType.createFieldValue();
                    fval.deserialize(this);
                }
                return new AssignValueUpdate(fval);
            }
            case CLEAR: {
                return new ClearValueUpdate();
            }
            case MAP: {
                if (superType instanceof ArrayDataType) {
                    CollectionDataType type = (CollectionDataType)superType;
                    IntegerFieldValue index = new IntegerFieldValue();
                    index.deserialize(this);
                    ValueUpdate update = this.getValueUpdate(type.getNestedType(), null);
                    return new MapValueUpdate(index, update);
                }
                if (superType instanceof WeightedSetDataType) {
                    CollectionDataType type = (CollectionDataType)superType;
                    FieldValue fval = type.getNestedType().createFieldValue();
                    fval.deserialize(this);
                    ValueUpdate update = this.getValueUpdate(DataType.INT, null);
                    return new MapValueUpdate(fval, update);
                }
                throw new DeserializationException("MapValueUpdate only works for arrays and weighted sets");
            }
            case REMOVE: {
                FieldValue fval = ((CollectionDataType)superType).getNestedType().createFieldValue();
                fval.deserialize(this);
                return new RemoveValueUpdate(fval);
            }
        }
        throw new DeserializationException("Could not deserialize ValueUpdate, unknown valueUpdateClassID type " + vuTypeId);
    }

    @Override
    public void read(FieldUpdate fieldUpdate) {
        int fieldId = this.getInt(null);
        Field field = fieldUpdate.getDocumentType().getField(fieldId, fieldUpdate.getSerializationVersion());
        if (field == null) {
            throw new DeserializationException("Cannot deserialize FieldUpdate, field fieldId " + fieldId + " not found in " + fieldUpdate.getDocumentType());
        }
        fieldUpdate.setField(field);
        int size = this.getInt(null);
        for (int i = 0; i < size; ++i) {
            if (field.getDataType() instanceof CollectionDataType) {
                CollectionDataType collType = (CollectionDataType)field.getDataType();
                fieldUpdate.addValueUpdate(this.getValueUpdate(collType, collType.getNestedType()));
                continue;
            }
            fieldUpdate.addValueUpdate(this.getValueUpdate(field.getDataType(), null));
        }
    }

    @Override
    public DocumentId readDocumentId() {
        Utf8String uri = new Utf8String((AbstractUtf8Array)VespaDocumentDeserializer42.parseNullTerminatedString(this.getBuf().getByteBuffer()));
        return DocumentId.createFromSerialized(uri.toString());
    }

    @Override
    public DocumentType readDocumentType() {
        Utf8Array docTypeName = this.parseNullTerminatedString();
        short ignored = this.getShort(null);
        DocumentType docType = this.manager.getDocumentType(new DataTypeName(docTypeName));
        if (docType == null) {
            throw new DeserializationException("No known document type with name " + new Utf8String((AbstractUtf8Array)docTypeName).toString());
        }
        return docType;
    }

    private SpanNode readSpanNode() {
        SpanNode retval;
        byte type = this.buf.get();
        this.buf.position(this.buf.position() - 1);
        if ((type & 1) == 1) {
            retval = new Span();
            if (this.spanNodes != null) {
                this.spanNodes.add(retval);
            }
            this.read((Span)retval);
        } else if ((type & 2) == 2) {
            retval = new SpanList();
            if (this.spanNodes != null) {
                this.spanNodes.add(retval);
            }
            this.read((SpanList)retval);
        } else if ((type & 4) == 4) {
            retval = new AlternateSpanList();
            if (this.spanNodes != null) {
                this.spanNodes.add(retval);
            }
            this.read((AlternateSpanList)retval);
        } else {
            throw new DeserializationException("Cannot read SpanNode of type " + type);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSpanTree(SpanTree tree, boolean readName) {
        if (this.spanNodes != null || this.annotations != null) {
            throw new SerializationException("Deserialization of nested SpanTrees is not supported.");
        }
        this.spanNodes = new ArrayList<SpanNode>();
        this.annotations = new ArrayList<Annotation>();
        try {
            int i;
            if (readName) {
                StringFieldValue treeName = new StringFieldValue();
                treeName.deserialize(this);
                tree.setName(treeName.getString());
            }
            SpanNode root = this.readSpanNode();
            tree.setRoot(root);
            int numAnnotations = this.buf.getInt1_2_4Bytes();
            for (i = 0; i < numAnnotations; ++i) {
                Annotation a = new Annotation();
                this.annotations.add(a);
            }
            for (i = 0; i < numAnnotations; ++i) {
                this.read(this.annotations.get(i));
            }
            for (Annotation a : this.annotations) {
                tree.annotate(a);
            }
            for (SpanNode node : this.spanNodes) {
                if (!(node instanceof Span)) continue;
                this.correctIndexes((Span)node);
            }
        }
        finally {
            this.spanNodes = null;
            this.annotations = null;
        }
    }

    @Override
    public void read(SpanTree tree) {
        this.readSpanTree(tree, true);
    }

    @Override
    public void read(Annotation annotation) {
        int annotationTypeId = this.buf.getInt();
        AnnotationType type = this.manager.getAnnotationTypeRegistry().getType(annotationTypeId);
        if (type == null) {
            throw new DeserializationException("Cannot deserialize annotation of type " + annotationTypeId + " (unknown type)");
        }
        annotation.setType(type);
        byte features = this.buf.get();
        int length = this.buf.getInt1_2_4Bytes();
        if ((features & 1) == 1) {
            int spanNodeId = this.buf.getInt1_2_4Bytes();
            try {
                SpanNode node = this.spanNodes.get(spanNodeId);
                annotation.setSpanNode(node);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new DeserializationException("Could not deserialize annotation, associated span node not found ", ioobe);
            }
        }
        if ((features & 2) == 2) {
            int dataTypeId = this.buf.getInt();
            if (dataTypeId != type.getDataType().getId()) {
                this.buf.position(this.buf.position() + length - 4);
            } else {
                FieldValue value = type.getDataType().createFieldValue();
                value.deserialize(this);
                annotation.setFieldValue(value);
            }
        }
    }

    @Override
    public void read(Span span) {
        byte type = this.buf.get();
        if ((type & 1) != 1) {
            throw new DeserializationException("Cannot deserialize Span with type " + type);
        }
        span.setFrom(this.buf.getInt1_2_4Bytes());
        span.setLength(this.buf.getInt1_2_4Bytes());
    }

    private void correctIndexes(Span span) {
        if (this.stringPositions == null) {
            throw new DeserializationException("Cannot deserialize Span, no access to parent StringFieldValue.");
        }
        int fromIndex = this.stringPositions[span.getFrom()];
        int toIndex = this.stringPositions[span.getTo()];
        int length = toIndex - fromIndex;
        span.setFrom(fromIndex);
        span.setLength(length);
    }

    @Override
    public void read(SpanList spanList) {
        byte type = this.buf.get();
        if ((type & 2) != 2) {
            throw new DeserializationException("Cannot deserialize SpanList with type " + type);
        }
        List<SpanNode> nodes = this.readSpanList(spanList);
        for (SpanNode node : nodes) {
            spanList.add(node);
        }
    }

    @Override
    public void read(AlternateSpanList altSpanList) {
        byte type = this.buf.get();
        if ((type & 4) != 4) {
            throw new DeserializationException("Cannot deserialize AlternateSpanList with type " + type);
        }
        int numSubTrees = this.buf.getInt1_2_4Bytes();
        for (int i = 0; i < numSubTrees; ++i) {
            double prob = this.buf.getDouble();
            List<SpanNode> list = this.readSpanList(altSpanList);
            if (i == 0) {
                for (SpanNode node : list) {
                    altSpanList.add(node);
                }
                altSpanList.setProbability(0, prob);
                continue;
            }
            altSpanList.addChildren(i, list, prob);
        }
    }

    private List<SpanNode> readSpanList(SpanNodeParent parent) {
        int size = this.buf.getInt1_2_4Bytes();
        ArrayList<SpanNode> spanList = new ArrayList<SpanNode>();
        for (int i = 0; i < size; ++i) {
            spanList.add(this.readSpanNode());
        }
        return spanList;
    }
}

