/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.serialization.DocumentSerializerFactory;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.DocumentUpdateWriter;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.io.GrowableByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class DocumentUpdate
extends DocumentOperation
implements Iterable<FieldPathUpdate> {
    public static final int CLASSID = 4102;
    private DocumentId docId;
    private final List<FieldUpdate> fieldUpdates;
    private final List<FieldPathUpdate> fieldPathUpdates;
    private DocumentType documentType;
    private Boolean createIfNonExistent;

    public DocumentUpdate(DocumentType docType, DocumentId docId) {
        this.docId = docId;
        this.documentType = docType;
        this.fieldUpdates = new ArrayList<FieldUpdate>();
        this.fieldPathUpdates = new ArrayList<FieldPathUpdate>();
    }

    public DocumentUpdate(DocumentUpdateReader reader) {
        this.docId = null;
        this.documentType = null;
        this.fieldUpdates = new ArrayList<FieldUpdate>();
        this.fieldPathUpdates = new ArrayList<FieldPathUpdate>();
        reader.read(this);
    }

    public DocumentUpdate(DocumentType docType, String docId) {
        this(docType, new DocumentId(docId));
    }

    @Override
    public DocumentId getId() {
        return this.docId;
    }

    public void setId(DocumentId id) {
        this.docId = id;
    }

    private void verifyType(Document doc) {
        if (!this.documentType.equals(doc.getDataType())) {
            throw new IllegalArgumentException("Document " + doc.getId() + " with type " + doc.getDataType() + " must have same type as update, which is type " + this.documentType);
        }
    }

    public DocumentUpdate applyTo(Document doc) {
        this.verifyType(doc);
        for (FieldUpdate fieldUpdate : this.fieldUpdates) {
            fieldUpdate.applyTo(doc);
        }
        for (FieldPathUpdate fieldPathUpdate : this.fieldPathUpdates) {
            fieldPathUpdate.applyTo(doc);
        }
        return this;
    }

    public DocumentUpdate prune(Document doc) {
        this.verifyType(doc);
        Iterator<FieldUpdate> iter = this.fieldUpdates.iterator();
        while (iter.hasNext()) {
            FieldValue currentValue;
            FieldUpdate update = iter.next();
            if (update.isEmpty()) continue;
            ValueUpdate last = update.getValueUpdate(update.size() - 1);
            if (last instanceof AssignValueUpdate) {
                currentValue = doc.getFieldValue(update.getField());
                if (currentValue == null || !currentValue.equals(last.getValue())) continue;
                iter.remove();
                continue;
            }
            if (!(last instanceof ClearValueUpdate)) continue;
            currentValue = doc.getFieldValue(update.getField());
            if (currentValue == null) {
                iter.remove();
                continue;
            }
            FieldValue copy = currentValue.clone();
            copy.clear();
            if (!currentValue.equals(copy)) continue;
            iter.remove();
        }
        return this;
    }

    @Deprecated
    public List<FieldUpdate> getFieldUpdates() {
        return Collections.unmodifiableList(this.fieldUpdates);
    }

    public Collection<FieldUpdate> fieldUpdates() {
        return Collections.unmodifiableCollection(this.fieldUpdates);
    }

    @Deprecated
    public List<FieldPathUpdate> getFieldPathUpdates() {
        return Collections.unmodifiableList(this.fieldPathUpdates);
    }

    public Collection<FieldPathUpdate> fieldPathUpdates() {
        return Collections.unmodifiableCollection(this.fieldPathUpdates);
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType type) {
        this.documentType = type;
    }

    @Deprecated
    public FieldUpdate getFieldUpdate(int index) {
        return this.fieldUpdates.get(index);
    }

    @Deprecated
    public FieldUpdate setFieldUpdate(int index, FieldUpdate upd) {
        FieldUpdate old = this.fieldUpdates.get(index);
        this.fieldUpdates.set(index, upd);
        return old;
    }

    public FieldUpdate getFieldUpdate(Field field) {
        return this.getFieldUpdateById(field.getId());
    }

    public void clearFieldUpdates() {
        this.fieldUpdates.clear();
    }

    public FieldUpdate getFieldUpdate(String fieldName) {
        Field field = this.documentType.getField(fieldName);
        return field != null ? this.getFieldUpdate(field) : null;
    }

    private FieldUpdate getFieldUpdateById(Integer fieldId) {
        for (FieldUpdate fieldUpdate : this.fieldUpdates) {
            if (fieldUpdate.getField().getId() != fieldId.intValue()) continue;
            return fieldUpdate;
        }
        return null;
    }

    public void setFieldUpdates(Collection<FieldUpdate> fieldUpdates) {
        if (fieldUpdates == null) {
            throw new NullPointerException("The field updates of a document update can not be null");
        }
        this.clearFieldUpdates();
        this.addFieldUpdates(fieldUpdates);
    }

    public void addFieldUpdates(Collection<FieldUpdate> fieldUpdates) {
        for (FieldUpdate fieldUpdate : fieldUpdates) {
            this.addFieldUpdate(fieldUpdate);
        }
    }

    public int size() {
        return this.fieldUpdates.size();
    }

    public DocumentUpdate addFieldUpdate(FieldUpdate update) {
        int fieldId = update.getField().getId();
        if (this.documentType.getField(fieldId) == null) {
            throw new IllegalArgumentException("Document type '" + this.documentType.getName() + "' does not have field '" + update.getField().getName() + "'.");
        }
        FieldUpdate prevUpdate = this.getFieldUpdateById(fieldId);
        if (prevUpdate != update) {
            if (prevUpdate != null) {
                prevUpdate.addAll(update);
            } else {
                this.fieldUpdates.add(update);
            }
        }
        return this;
    }

    public DocumentUpdate addFieldPathUpdate(FieldPathUpdate fieldPathUpdate) {
        this.fieldPathUpdates.add(fieldPathUpdate);
        return this;
    }

    public void addAll(DocumentUpdate update) {
        if (update == null) {
            return;
        }
        if (!this.docId.equals(update.docId)) {
            throw new IllegalArgumentException("Expected " + this.docId + ", got " + update.docId + ".");
        }
        if (!this.documentType.equals(update.documentType)) {
            throw new IllegalArgumentException("Expected " + this.documentType + ", got " + update.documentType + ".");
        }
        this.addFieldUpdates(update.fieldUpdates());
        for (FieldPathUpdate pathUpd : update.fieldPathUpdates) {
            this.addFieldPathUpdate(pathUpd);
        }
    }

    @Deprecated
    public FieldUpdate removeFieldUpdate(int index) {
        return this.fieldUpdates.remove(index);
    }

    public FieldUpdate removeFieldUpdate(Field field) {
        Iterator<FieldUpdate> it = this.fieldUpdates.iterator();
        while (it.hasNext()) {
            FieldUpdate fieldUpdate = it.next();
            if (!fieldUpdate.getField().equals(field)) continue;
            it.remove();
            return fieldUpdate;
        }
        return null;
    }

    public FieldUpdate removeFieldUpdate(String fieldName) {
        Field field = this.documentType.getField(fieldName);
        return field != null ? this.removeFieldUpdate(field) : null;
    }

    public DocumentType getType() {
        return this.documentType;
    }

    public final void serialize(GrowableByteBuffer buf) {
        this.serialize(DocumentSerializerFactory.create42(buf));
    }

    public void serialize(DocumentUpdateWriter data) {
        data.write(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentUpdate)) {
            return false;
        }
        DocumentUpdate that = (DocumentUpdate)o;
        if (this.docId != null ? !this.docId.equals(that.docId) : that.docId != null) {
            return false;
        }
        if (this.documentType != null ? !this.documentType.equals(that.documentType) : that.documentType != null) {
            return false;
        }
        if (this.fieldPathUpdates != null ? !this.fieldPathUpdates.equals(that.fieldPathUpdates) : that.fieldPathUpdates != null) {
            return false;
        }
        if (this.fieldUpdates != null ? !this.fieldUpdates.equals(that.fieldUpdates) : that.fieldUpdates != null) {
            return false;
        }
        return this.getCreateIfNonExistent() == ((DocumentUpdate)o).getCreateIfNonExistent();
    }

    public int hashCode() {
        int result = this.docId != null ? this.docId.hashCode() : 0;
        result = 31 * result + (this.fieldUpdates != null ? this.fieldUpdates.hashCode() : 0);
        result = 31 * result + (this.fieldPathUpdates != null ? this.fieldPathUpdates.hashCode() : 0);
        result = 31 * result + (this.documentType != null ? this.documentType.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("update of document '");
        string.append(this.docId);
        string.append("': ");
        string.append("create-if-non-existent=");
        string.append(this.getCreateIfNonExistent());
        string.append(": ");
        string.append("[");
        for (FieldUpdate fieldUpdate : this.fieldUpdates) {
            string.append(fieldUpdate).append(" ");
        }
        string.append("]");
        if (this.fieldPathUpdates.size() > 0) {
            string.append(" [ ");
            for (FieldPathUpdate up : this.fieldPathUpdates) {
                string.append(up.toString()).append(" ");
            }
            string.append(" ]");
        }
        return string.toString();
    }

    @Override
    public Iterator<FieldPathUpdate> iterator() {
        return this.fieldPathUpdates.iterator();
    }

    public boolean isEmpty() {
        return this.fieldUpdates.isEmpty() && this.fieldPathUpdates.isEmpty();
    }

    public void setCreateIfNonExistent(boolean value) {
        this.createIfNonExistent = value;
    }

    public boolean getCreateIfNonExistent() {
        return this.createIfNonExistent != null && this.createIfNonExistent != false;
    }

    public Optional<Boolean> getOptionalCreateIfNonExistent() {
        return Optional.ofNullable(this.createIfNonExistent);
    }
}

