/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.FieldPath;
import com.yahoo.document.MapDataType;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.objects.ObjectVisitor;

public class WeightedSetDataType
extends CollectionDataType {
    public static int classId = WeightedSetDataType.registerClass((int)4151, WeightedSetDataType.class);
    private boolean createIfNonExistent = false;
    private boolean removeIfZero = false;
    private boolean tag = false;

    public WeightedSetDataType(DataType nestedType, boolean createIfNonExistent, boolean removeIfZero) {
        this(nestedType, createIfNonExistent, removeIfZero, 0);
        if (nestedType == STRING && createIfNonExistent && removeIfZero) {
            this.setId(18);
        } else {
            this.setId(this.getName().toLowerCase().hashCode());
        }
    }

    public WeightedSetDataType(DataType nestedType, boolean createIfNonExistent, boolean removeIfZero, int id) {
        super(WeightedSetDataType.createName(nestedType, createIfNonExistent, removeIfZero), id, nestedType);
        this.createIfNonExistent = createIfNonExistent;
        this.removeIfZero = removeIfZero;
    }

    public WeightedSetDataType(String typeName, int code, DataType nestedType, boolean createIfNonExistent, boolean removeIfZero) {
        super(typeName != null ? WeightedSetDataType.createName(nestedType, createIfNonExistent, removeIfZero) : null, code, nestedType);
        if (code >= 0 && code <= DataType.lastPredefinedDataTypeId() && code != 18) {
            throw new IllegalArgumentException("Cannot create a weighted set datatype with code " + code);
        }
        this.createIfNonExistent = createIfNonExistent;
        this.removeIfZero = removeIfZero;
    }

    @Override
    public WeightedSetDataType clone() {
        return (WeightedSetDataType)super.clone();
    }

    public void setTag(boolean tag) {
        this.tag = tag;
    }

    public boolean isTag() {
        return this.tag;
    }

    private static String createName(DataType nested, boolean createIfNonExistent, boolean removeIfZero) {
        if (nested == DataType.STRING && createIfNonExistent && removeIfZero) {
            return "tag";
        }
        String name = "WeightedSet<" + nested.getName() + ">";
        if (createIfNonExistent) {
            name = name + ";Add";
        }
        if (removeIfZero) {
            name = name + ";Remove";
        }
        return name;
    }

    @Override
    public WeightedSet createFieldValue() {
        return new WeightedSet((DataType)this);
    }

    @Override
    public Class getValueClass() {
        return WeightedSet.class;
    }

    public boolean createIfNonExistent() {
        return this.createIfNonExistent;
    }

    public boolean removeIfZero() {
        return this.removeIfZero;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("removeIfZero", (Object)this.removeIfZero);
        visitor.visit("createIfNonExistent", (Object)this.createIfNonExistent);
    }

    @Override
    public FieldPath buildFieldPath(String remainFieldName) {
        return MapDataType.buildFieldPath(remainFieldName, this.getNestedType(), DataType.INT);
    }
}

