/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.fieldpathupdate;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentType;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.fieldpathupdate.AddFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.fieldpathupdate.RemoveFieldPathUpdate;
import com.yahoo.document.select.DocumentSelector;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.ResultList;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.serialization.DocumentUpdateReader;
import com.yahoo.document.serialization.VespaDocumentSerializerHead;

public abstract class FieldPathUpdate {
    private FieldPath fieldPath;
    private DocumentSelector selector;
    private String originalFieldPath;
    private String whereClause;
    private Type updType;
    private DocumentType docType;

    public FieldPathUpdate(Type updType, DocumentType docType, String fieldPath, String whereClause) {
        this.updType = updType;
        this.docType = docType;
        try {
            this.setWhereClause(whereClause);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        this.setFieldPath(fieldPath);
    }

    public FieldPathUpdate(Type updType, DocumentType docType, DocumentUpdateReader reader) {
        this(updType, docType);
        reader.read(this);
    }

    public FieldPathUpdate(Type updType, DocumentType docType) {
        this.updType = updType;
        this.docType = docType;
    }

    public Type getUpdateType() {
        return this.updType;
    }

    public DocumentType getDocumentType() {
        return this.docType;
    }

    public void setFieldPath(String fieldPath) {
        this.originalFieldPath = fieldPath;
        this.fieldPath = this.docType.buildFieldPath(fieldPath);
    }

    public FieldPath getFieldPath() {
        return this.fieldPath;
    }

    public String getOriginalFieldPath() {
        return this.originalFieldPath;
    }

    public void setWhereClause(String whereClause) throws ParseException {
        this.whereClause = whereClause;
        this.selector = null;
        if (whereClause != null && !whereClause.equals("")) {
            this.selector = new DocumentSelector(whereClause);
        }
    }

    public DocumentSelector getWhereClause() {
        return this.selector;
    }

    public String getOriginalWhereClause() {
        return this.whereClause;
    }

    public void applyTo(Document doc) {
        if (this.selector == null) {
            FieldPathIteratorHandler handler = this.getIteratorHandler(doc);
            doc.iterateNested(this.fieldPath, 0, handler);
        } else {
            ResultList results = this.selector.getMatchingResultList(new DocumentPut(doc));
            for (ResultList.ResultPair rp : results.getResults()) {
                if (rp.getResult() != Result.TRUE) continue;
                FieldPathIteratorHandler handler = this.getIteratorHandler(doc);
                handler.getVariables().clear();
                handler.getVariables().putAll(rp.getVariables());
                doc.iterateNested(this.fieldPath, 0, handler);
            }
        }
    }

    public void serialize(VespaDocumentSerializerHead data) {
        data.write(this);
    }

    public static FieldPathUpdate create(Type type, DocumentType docType, DocumentUpdateReader reader) {
        switch (type) {
            case ASSIGN: {
                return new AssignFieldPathUpdate(docType, reader);
            }
            case ADD: {
                return new AddFieldPathUpdate(docType, reader);
            }
            case REMOVE: {
                return new RemoveFieldPathUpdate(docType, reader);
            }
        }
        throw new IllegalArgumentException("Field path update type '" + (Object)((Object)type) + "' not supported.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPathUpdate that = (FieldPathUpdate)o;
        if (this.docType != null ? !this.docType.equals(that.docType) : that.docType != null) {
            return false;
        }
        if (this.originalFieldPath != null ? !this.originalFieldPath.equals(that.originalFieldPath) : that.originalFieldPath != null) {
            return false;
        }
        return !(this.whereClause != null ? !this.whereClause.equals(that.whereClause) : that.whereClause != null);
    }

    public int hashCode() {
        int result = this.originalFieldPath != null ? this.originalFieldPath.hashCode() : 0;
        result = 31 * result + (this.whereClause != null ? this.whereClause.hashCode() : 0);
        result = 31 * result + (this.docType != null ? this.docType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "fieldpath=\"" + this.originalFieldPath + "\"" + (this.whereClause != null ? " where=\"" + this.whereClause + "\"" : "");
    }

    abstract FieldPathIteratorHandler getIteratorHandler(Document var1);

    public static enum Type {
        ASSIGN(0),
        REMOVE(1),
        ADD(2);

        private final int code;

        private Type(int code) {
            this.code = code;
        }

        public static Type valueOf(int code) {
            for (Type type : Type.values()) {
                if (type.code != code) continue;
                return type;
            }
            throw new IllegalArgumentException("Field path update type " + code + " not supported.");
        }

        public int getCode() {
            return this.code;
        }
    }
}

