/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespaxmlparser;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.serialization.DeserializationException;
import com.yahoo.document.serialization.FieldReader;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.FieldBase;
import com.yahoo.vespaxmlparser.VespaXMLReader;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.codec.binary.Base64;

public class VespaXMLFieldReader
extends VespaXMLReader
implements FieldReader {
    private static final BigInteger UINT_MAX = new BigInteger("4294967296");
    private static final BigInteger ULONG_MAX = new BigInteger("18446744073709551616");
    private Optional<String> condition = Optional.empty();

    public VespaXMLFieldReader(String fileName, DocumentTypeManager docTypeManager) throws Exception {
        super(fileName, docTypeManager);
    }

    public VespaXMLFieldReader(InputStream stream, DocumentTypeManager docTypeManager) throws Exception {
        super(stream, docTypeManager);
    }

    public VespaXMLFieldReader(XMLStreamReader reader, DocumentTypeManager docTypeManager) {
        super(reader, docTypeManager);
    }

    public Optional<String> getCondition() {
        return this.condition;
    }

    @Override
    public void read(FieldBase field, Document document) {
        try {
            DocumentType doctype;
            if (this.reader.getEventType() != 1 || !"document".equals(this.reader.getName().toString())) {
                while (this.reader.hasNext() && (this.reader.getEventType() != 1 || !"document".equals(this.reader.getName().toString()))) {
                    this.reader.next();
                }
            }
            String typeName = null;
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                String attributeName = this.reader.getAttributeName(i).toString();
                if ("documentid".equals(attributeName) || "id".equals(attributeName)) {
                    document.setId(new DocumentId(this.reader.getAttributeValue(i)));
                    continue;
                }
                if ("documenttype".equals(attributeName) || "type".equals(attributeName)) {
                    typeName = this.reader.getAttributeValue(i);
                    continue;
                }
                if (!"condition".equals(attributeName)) continue;
                this.condition = Optional.of(this.reader.getAttributeValue(i));
            }
            if (document.getId() != null && field == null) {
                field = new FieldBase(document.getId().toString());
            }
            if ((doctype = this.docTypeManager.getDocumentType(typeName)) == null) {
                throw this.newDeserializeException(field, "Must specify an existing document type, not '" + typeName + "'");
            }
            document.setDataType(doctype);
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type == 1) {
                    Field f = doctype.getField(this.reader.getName().toString());
                    if (f == null) {
                        throw this.newDeserializeException(field, "Field " + this.reader.getName() + " not found.");
                    }
                    FieldValue fv = f.getDataType().createFieldValue();
                    fv.deserialize(f, this);
                    document.setFieldValue(f, fv);
                    this.skipToEnd(f.getName());
                    continue;
                }
                if (type != 2) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, Array<T> value) {
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type == 1) {
                    if (!"item".equals(this.reader.getName().toString())) continue;
                    FieldValue fv = value.getDataType().getNestedType().createFieldValue();
                    this.deserializeFieldValue(field, fv);
                    value.add(fv);
                    this.skipToEnd("item");
                    continue;
                }
                if (type != 2) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    void readKeyAndValue(FieldBase field, KeyAndValue val, MapDataType dt) throws XMLStreamException {
        while (this.reader.hasNext()) {
            int type = this.reader.next();
            if (type == 1) {
                if ("key".equals(this.reader.getName().toString())) {
                    val.key = dt.getKeyType().createFieldValue();
                    this.deserializeFieldValue(field, val.key);
                    this.skipToEnd("key");
                    continue;
                }
                if ("value".equals(this.reader.getName().toString())) {
                    val.value = dt.getValueType().createFieldValue();
                    this.deserializeFieldValue(field, val.value);
                    this.skipToEnd("value");
                    continue;
                }
                throw this.newDeserializeException("Illegal element inside map item: " + this.reader.getName());
            }
            if (type != 2) continue;
            return;
        }
    }

    @Override
    public <K extends FieldValue, V extends FieldValue> void read(FieldBase field, MapFieldValue<K, V> map) {
        try {
            MapDataType dt = map.getDataType();
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type == 1) {
                    if ("item".equals(this.reader.getName().toString())) {
                        KeyAndValue kv = new KeyAndValue();
                        this.readKeyAndValue(field, kv, dt);
                        if (kv.key == null || kv.value == null) {
                            throw this.newDeserializeException(field, "Map items must specify both key and value");
                        }
                        map.put(kv.key, kv.value);
                        this.skipToEnd("item");
                        continue;
                    }
                    throw this.newDeserializeException(field, "Illegal tag " + this.reader.getName() + " expected 'item'");
                }
                if (type != 2) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, Struct value) {
        try {
            boolean base64 = VespaXMLFieldReader.isBase64EncodedElement(this.reader);
            boolean foundField = false;
            StringBuilder positionBuilder = null;
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type == 1) {
                    Field structField = value.getField(this.reader.getName().toString());
                    if (structField == null) {
                        throw this.newDeserializeException(field, "Field " + this.reader.getName() + " not found.");
                    }
                    FieldValue fieldValue = structField.getDataType().createFieldValue();
                    fieldValue.deserialize(structField, this);
                    value.setFieldValue(structField, fieldValue);
                    this.skipToEnd(structField.getName());
                    foundField = true;
                    continue;
                }
                if (type == 4) {
                    if (foundField) continue;
                    String chars = this.reader.getText();
                    if (positionBuilder == null) {
                        positionBuilder = new StringBuilder(chars);
                        continue;
                    }
                    positionBuilder.append(chars);
                    continue;
                }
                if (type != 2) continue;
                if (positionBuilder != null) {
                    this.assignPositionFieldFromStringIfNonEmpty(value, positionBuilder.toString(), base64);
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    private void assignPositionFieldFromStringIfNonEmpty(Struct value, String elementText, boolean base64) {
        String str = base64 ? Utf8.toString((byte[])new Base64().decode(elementText)) : elementText;
        if ((str = str.trim()).isEmpty()) {
            return;
        }
        StructDataType valueType = value.getDataType();
        if (((DataType)valueType).equals(PositionDataType.INSTANCE)) {
            value.assign(PositionDataType.fromString(str));
        }
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, WeightedSet<T> value) {
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                if (type == 1) {
                    if ("item".equals(this.reader.getName().toString())) {
                        FieldValue fv = value.getDataType().getNestedType().createFieldValue();
                        int weight = 1;
                        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                            if (!"weight".equals(this.reader.getAttributeName(i).toString())) continue;
                            weight = Integer.parseInt(this.reader.getAttributeValue(i));
                        }
                        this.deserializeFieldValue(field, fv);
                        value.put((T)fv, weight);
                        this.skipToEnd("item");
                        continue;
                    }
                    throw this.newDeserializeException(field, "Illegal tag " + this.reader.getName() + " expected 'item'");
                }
                if (type != 2) continue;
                return;
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, ByteFieldValue value) {
        try {
            String dataParsed = this.reader.getElementText();
            try {
                value.assign(new Byte(dataParsed));
            }
            catch (Exception e) {
                throw this.newDeserializeException(field, "Invalid byte \"" + dataParsed + "\".");
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, DoubleFieldValue value) {
        try {
            String dataParsed = this.reader.getElementText();
            try {
                value.assign(new Double(dataParsed));
            }
            catch (Exception e) {
                throw this.newDeserializeException(field, "Invalid double \"" + dataParsed + "\".");
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, FloatFieldValue value) {
        try {
            String dataParsed = this.reader.getElementText();
            try {
                value.assign(new Float(dataParsed));
            }
            catch (Exception e) {
                throw this.newDeserializeException(field, "Invalid float \"" + dataParsed + "\".");
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    private RuntimeException newDeserializeException(FieldBase field, String msg) {
        return this.newDeserializeException("Field '" + (field == null ? "null" : field.getName()) + "': " + msg);
    }

    private RuntimeException newException(FieldBase field, Exception e) {
        return this.newDeserializeException("Field '" + (field == null ? "null" : field.getName()) + "': " + e.getMessage());
    }

    @Override
    public void read(FieldBase field, IntegerFieldValue value) {
        try {
            BigInteger val;
            String dataParsed = this.reader.getElementText();
            try {
                val = dataParsed.startsWith("0x") ? new BigInteger(dataParsed.substring(2), 16) : (dataParsed.startsWith("0") && dataParsed.length() > 1 ? new BigInteger(dataParsed.substring(1), 8) : new BigInteger(dataParsed));
            }
            catch (Exception e) {
                throw this.newDeserializeException(field, "Invalid integer \"" + dataParsed + "\".");
            }
            if (val.bitLength() > 32) {
                throw this.newDeserializeException(field, "Invalid integer \"" + dataParsed + "\". Out of range.");
            }
            if (val.bitLength() == 32) {
                if (val.compareTo(BigInteger.ZERO) == 1) {
                    val = val.subtract(UINT_MAX);
                } else {
                    throw this.newDeserializeException(field, "Invalid integer \"" + dataParsed + "\". Out of range.");
                }
            }
            value.assign(val.intValue());
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, LongFieldValue value) {
        try {
            BigInteger val;
            String dataParsed = this.reader.getElementText();
            try {
                val = dataParsed.startsWith("0x") ? new BigInteger(dataParsed.substring(2), 16) : (dataParsed.startsWith("0") && dataParsed.length() > 1 ? new BigInteger(dataParsed.substring(1), 8) : new BigInteger(dataParsed));
            }
            catch (Exception e) {
                throw this.newDeserializeException(field, "Invalid long \"" + dataParsed + "\".");
            }
            if (val.bitLength() > 64) {
                throw this.newDeserializeException(field, "Invalid long \"" + dataParsed + "\". Out of range.");
            }
            if (val.compareTo(BigInteger.ZERO) == 1 && val.bitLength() == 64) {
                val = val.subtract(ULONG_MAX);
            }
            value.assign(val.longValue());
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, Raw value) {
        try {
            if (VespaXMLFieldReader.isBase64EncodedElement(this.reader)) {
                value.assign(new Base64().decode(this.reader.getElementText()));
            } else {
                value.assign(this.reader.getElementText().getBytes());
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, PredicateFieldValue value) {
        try {
            if (VespaXMLFieldReader.isBase64EncodedElement(this.reader)) {
                value.assign(Predicate.fromBinary((byte[])new Base64().decode(this.reader.getElementText())));
            } else {
                value.assign(Predicate.fromString((String)this.reader.getElementText()));
            }
        }
        catch (XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, StringFieldValue value) {
        try {
            if (VespaXMLFieldReader.isBase64EncodedElement(this.reader)) {
                throw new IllegalArgumentException("Attribute binaryencoding=base64 is not allowed for fields of type 'string'. To represent binary data, use type 'raw'.");
            }
            value.assign(this.reader.getElementText());
        }
        catch (IllegalArgumentException | XMLStreamException e) {
            throw this.newException(field, e);
        }
    }

    @Override
    public void read(FieldBase field, TensorFieldValue value) {
        VespaXMLFieldReader.throwOnlyJsonSupportedException(field, "TENSOR");
    }

    @Override
    public void read(FieldBase field, ReferenceFieldValue value) {
        VespaXMLFieldReader.throwOnlyJsonSupportedException(field, "REFERENCE");
    }

    private static void throwOnlyJsonSupportedException(FieldBase field, String fieldType) {
        throw new DeserializationException("Field '" + (field != null ? field.getName() : "null") + "': XML input for fields of type " + fieldType + " is not supported. Please use JSON input instead.");
    }

    @Override
    public void read(FieldBase field, AnnotationReference value) {
        System.out.println("Annotation value read!");
    }

    private void deserializeFieldValue(FieldBase field, FieldValue value) {
        value.deserialize(field instanceof Field ? (Field)field : null, this);
    }

    public DocumentId readDocumentId() {
        return null;
    }

    public DocumentType readDocumentType() {
        return null;
    }

    public DocumentTypeManager getDocumentTypeManager() {
        return this.docTypeManager;
    }

    @Override
    public <T extends FieldValue> void read(FieldBase field, CollectionFieldValue<T> value) {
        System.out.println("Should not be called!!!");
    }

    @Override
    public void read(FieldBase field, StructuredFieldValue value) {
        System.out.println("Should not be called!!!");
    }

    @Override
    public void read(FieldBase field, FieldValue value) {
        System.out.println("SHOULD NEVER BE CALLED? " + field.toString());
    }

    public byte getByte(FieldBase fieldBase) {
        return 0;
    }

    public short getShort(FieldBase fieldBase) {
        return 0;
    }

    public int getInt(FieldBase fieldBase) {
        return 0;
    }

    public long getLong(FieldBase fieldBase) {
        return 0L;
    }

    public float getFloat(FieldBase fieldBase) {
        return 0.0f;
    }

    public double getDouble(FieldBase fieldBase) {
        return 0.0;
    }

    public byte[] getBytes(FieldBase fieldBase, int i) {
        return new byte[0];
    }

    public String getString(FieldBase fieldBase) {
        return null;
    }

    class KeyAndValue {
        FieldValue key = null;
        FieldValue value = null;

        KeyAndValue() {
        }
    }
}

