/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.json.JsonReader;
import com.yahoo.vespaxmlparser.FeedReader;
import com.yahoo.vespaxmlparser.VespaXMLFeedReader;
import java.io.InputStream;

public class JsonFeedReader
implements FeedReader {
    private final JsonReader reader;
    private InputStream stream;
    private static final JsonFactory jsonFactory = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    public JsonFeedReader(InputStream stream, DocumentTypeManager docMan) {
        this.reader = new JsonReader(docMan, stream, jsonFactory);
        this.stream = stream;
    }

    @Override
    public void read(VespaXMLFeedReader.Operation operation) throws Exception {
        DocumentOperation documentOperation = this.reader.next();
        if (documentOperation == null) {
            this.stream.close();
            operation.setInvalid();
            return;
        }
        if (documentOperation instanceof DocumentUpdate) {
            operation.setDocumentUpdate((DocumentUpdate)documentOperation);
        } else if (documentOperation instanceof DocumentRemove) {
            operation.setRemove(documentOperation.getId());
        } else if (documentOperation instanceof DocumentPut) {
            operation.setDocument(((DocumentPut)documentOperation).getDocument());
        } else {
            throw new IllegalStateException("Got unknown class from JSON reader: " + documentOperation.getClass().getName());
        }
        operation.setCondition(documentOperation.getCondition());
    }
}

