/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.collections.Pair;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.FieldPath;
import com.yahoo.document.MapDataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.UriFieldValue;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;

public abstract class DataType
extends Identifiable
implements Serializable,
Comparable<DataType> {
    public static int classId = DataType.registerClass((int)4146, DataType.class);
    public static final NumericDataType NONE = new NumericDataType("none", -1, IntegerFieldValue.class, IntegerFieldValue.getFactory());
    public static final NumericDataType INT = new NumericDataType("int", 0, IntegerFieldValue.class, IntegerFieldValue.getFactory());
    public static final NumericDataType FLOAT = new NumericDataType("float", 1, FloatFieldValue.class, FloatFieldValue.getFactory());
    public static final PrimitiveDataType STRING = new PrimitiveDataType("string", 2, StringFieldValue.class, StringFieldValue.getFactory());
    public static final PrimitiveDataType RAW = new PrimitiveDataType("raw", 3, Raw.class, Raw.getFactory());
    public static final NumericDataType LONG = new NumericDataType("long", 4, LongFieldValue.class, LongFieldValue.getFactory());
    public static final NumericDataType DOUBLE = new NumericDataType("double", 5, DoubleFieldValue.class, DoubleFieldValue.getFactory());
    public static final DocumentType DOCUMENT = new DocumentType("document");
    public static final PrimitiveDataType URI = new PrimitiveDataType("uri", 10, UriFieldValue.class, new UriFieldValue.Factory());
    public static final NumericDataType BYTE = new NumericDataType("byte", 16, ByteFieldValue.class, ByteFieldValue.getFactory());
    public static final PrimitiveDataType PREDICATE = new PrimitiveDataType("predicate", 20, PredicateFieldValue.class, PredicateFieldValue.getFactory());
    public static final int tensorDataTypeCode = 21;
    public static final WeightedSetDataType TAG = new WeightedSetDataType(STRING, true, true);
    private boolean registered = false;
    private String name;
    private int dataTypeId;
    private static final CopyOnWriteHashMap<Pair, Constructor> constructorCache = new CopyOnWriteHashMap();

    public static int lastPredefinedDataTypeId() {
        return 21;
    }

    protected DataType(String name, int dataTypeId) {
        this.name = name;
        this.dataTypeId = dataTypeId;
    }

    public DataType clone() {
        return (DataType)super.clone();
    }

    void setRegistered() {
        this.registered = true;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public abstract FieldValue createFieldValue();

    protected FieldValue createByReflection(Object arg) {
        block4: {
            Class valClass = this.getValueClass();
            if (valClass != null) {
                Pair key = new Pair((Object)valClass, arg.getClass());
                Constructor cstr = (Constructor)constructorCache.get((Object)key);
                try {
                    if (cstr == null) {
                        cstr = valClass.getConstructor((Class)key.getSecond());
                        constructorCache.put((Object)key, cstr);
                    }
                    return (FieldValue)cstr.newInstance(arg);
                }
                catch (ReflectiveOperationException e) {
                    if (!(e instanceof InvocationTargetException)) break block4;
                    throw new IllegalArgumentException(e.getCause().getMessage(), e.getCause());
                }
            }
        }
        return null;
    }

    public FieldValue createFieldValue(Object arg) {
        if (arg == null) {
            return this.createFieldValue();
        }
        FieldValue val = this.createByReflection(arg);
        if (val == null && (val = this.createFieldValue()) != null) {
            val.assign(arg);
        }
        return val;
    }

    public abstract Class getValueClass();

    public abstract boolean isValueCompatible(FieldValue var1);

    public final boolean isAssignableFrom(DataType dataType) {
        return this.isValueCompatible(dataType.createFieldValue());
    }

    public static ArrayDataType getArray(DataType type) {
        return new ArrayDataType(type);
    }

    public static MapDataType getMap(DataType key, DataType value) {
        return new MapDataType(key, value);
    }

    public static WeightedSetDataType getWeightedSet(DataType type) {
        return DataType.getWeightedSet(type, false, false);
    }

    public static WeightedSetDataType getWeightedSet(DataType type, boolean createIfNonExistent, boolean removeIfZero) {
        return new WeightedSetDataType(type, createIfNonExistent, removeIfZero);
    }

    public static TensorDataType getTensor(TensorType type) {
        return new TensorDataType(type);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.dataTypeId;
    }

    public void setId(int id) {
        this.dataTypeId = id;
    }

    public final void register(DocumentTypeManager manager) {
        this.register(manager, new LinkedList<DataType>());
    }

    protected void register(DocumentTypeManager manager, List<DataType> seenTypes) {
        manager.registerSingleType(this);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataType)) {
            return false;
        }
        DataType type = (DataType)other;
        return this.name.equals(type.name) && this.dataTypeId == type.dataTypeId;
    }

    public String toString() {
        return "datatype " + this.name + " (code: " + this.dataTypeId + ")";
    }

    public int getCode() {
        return this.dataTypeId;
    }

    public FieldPath buildFieldPath(String fieldPathString) {
        if (fieldPathString.length() > 0) {
            throw new IllegalArgumentException("Datatype " + this.toString() + " does not support further recursive structure: " + fieldPathString);
        }
        return new FieldPath();
    }

    public PrimitiveDataType getPrimitiveType() {
        return null;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("name", (Object)this.name);
        visitor.visit("id", (Object)this.dataTypeId);
    }

    static String skipDotInString(String remaining, int endPos) {
        if (remaining.length() < endPos + 2) {
            return "";
        }
        if (remaining.charAt(endPos + 1) == '.') {
            return remaining.substring(endPos + 2);
        }
        return remaining.substring(endPos + 1);
    }

    @Override
    public int compareTo(DataType dataType) {
        return Integer.valueOf(this.dataTypeId).compareTo(dataType.dataTypeId);
    }

    public boolean isMultivalue() {
        return false;
    }
}

