/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.rule;

import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.select.BucketSet;
import com.yahoo.document.select.Context;
import com.yahoo.document.select.OrderingSpecification;
import com.yahoo.document.select.ResultList;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.rule.ExpressionNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class LogicNode
implements ExpressionNode {
    public static final int NOP = 0;
    public static final int OR = 1;
    public static final int AND = 2;
    private final List<NodeItem> items = new ArrayList<NodeItem>();

    public List<NodeItem> getItems() {
        return this.items;
    }

    public LogicNode add(String operator, ExpressionNode node) {
        this.items.add(new NodeItem(this.stringToOperator(operator), node));
        return this;
    }

    @Override
    public BucketSet getBucketSet(BucketIdFactory factory) {
        Stack<BucketItem> buf = new Stack<BucketItem>();
        for (NodeItem item : this.items) {
            if (!buf.isEmpty()) {
                while (buf.peek().operator > item.operator) {
                    this.combineBuckets(buf);
                }
            }
            buf.push(new BucketItem(item.operator, item.node.getBucketSet(factory)));
        }
        while (buf.size() > 1) {
            this.combineBuckets(buf);
        }
        return ((BucketItem)buf.pop()).buckets;
    }

    @Override
    public OrderingSpecification getOrdering(int order) {
        Stack<OrderingItem> buf = new Stack<OrderingItem>();
        for (NodeItem item : this.items) {
            if (!buf.isEmpty()) {
                while (buf.peek().operator > item.operator) {
                    this.pickOrdering(buf);
                }
            }
            buf.push(new OrderingItem(item.operator, item.node.getOrdering(order)));
        }
        while (buf.size() > 1) {
            this.pickOrdering(buf);
        }
        return ((OrderingItem)buf.pop()).ordering;
    }

    private OrderingSpecification pickOrdering(OrderingSpecification a, OrderingSpecification b, boolean isAnd) {
        if (a.getWidthBits() == b.getWidthBits() && a.getDivisionBits() == b.getDivisionBits() && a.getOrder() == b.getOrder()) {
            if (a.getOrder() == OrderingSpecification.ASCENDING && isAnd || a.getOrder() == OrderingSpecification.DESCENDING && !isAnd) {
                return new OrderingSpecification(a.getOrder(), Math.max(a.getOrderingStart(), b.getOrderingStart()), b.getWidthBits(), a.getDivisionBits());
            }
            return new OrderingSpecification(a.getOrder(), Math.min(a.getOrderingStart(), b.getOrderingStart()), b.getWidthBits(), a.getDivisionBits());
        }
        return null;
    }

    private void pickOrdering(Stack<OrderingItem> buf) {
        OrderingItem rhs = buf.pop();
        OrderingItem lhs = buf.pop();
        switch (rhs.operator) {
            case 2: {
                if (lhs.ordering == null) {
                    lhs.ordering = rhs.ordering;
                    break;
                }
                if (rhs.ordering == null) break;
                lhs.ordering = this.pickOrdering(lhs.ordering, rhs.ordering, true);
                break;
            }
            case 1: {
                if (lhs.ordering != null && rhs.ordering != null) {
                    lhs.ordering = this.pickOrdering(lhs.ordering, rhs.ordering, false);
                    break;
                }
                lhs.ordering = null;
                break;
            }
            default: {
                lhs.ordering = null;
            }
        }
        buf.push(lhs);
    }

    private void combineBuckets(Stack<BucketItem> buf) {
        BucketItem rhs = buf.pop();
        BucketItem lhs = buf.pop();
        switch (rhs.operator) {
            case 2: {
                if (lhs.buckets == null) {
                    lhs.buckets = rhs.buckets;
                    break;
                }
                if (rhs.buckets == null) break;
                lhs.buckets = lhs.buckets.intersection(rhs.buckets);
                break;
            }
            case 1: {
                if (lhs.buckets == null) break;
                if (rhs.buckets == null) {
                    lhs.buckets = null;
                    break;
                }
                lhs.buckets = lhs.buckets.union(rhs.buckets);
                break;
            }
            default: {
                throw new IllegalStateException("Arithmetic operator " + rhs.operator + " not supported.");
            }
        }
        buf.push(lhs);
    }

    @Override
    public Object evaluate(Context context) {
        Stack<ValueItem> buf = new Stack<ValueItem>();
        for (NodeItem item : this.items) {
            if (!buf.isEmpty()) {
                while (buf.peek().operator > item.operator) {
                    this.combineValues(buf);
                }
            }
            buf.push(new ValueItem(item.operator, ResultList.toResultList(item.node.evaluate(context))));
        }
        while (buf.size() > 1) {
            this.combineValues(buf);
        }
        return ((ValueItem)buf.pop()).value;
    }

    private void combineValues(Stack<ValueItem> buf) {
        ValueItem rhs = buf.pop();
        ValueItem lhs = buf.pop();
        switch (rhs.operator) {
            case 2: {
                buf.push(new ValueItem(lhs.operator, lhs.value.combineAND(rhs.value)));
                break;
            }
            case 1: {
                buf.push(new ValueItem(lhs.operator, lhs.value.combineOR(rhs.value)));
                break;
            }
            default: {
                throw new IllegalStateException("Arithmetic operator " + rhs.operator + " not supported.");
            }
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (NodeItem item : this.items) {
            if (item.operator != 0) {
                ret.append(" ").append(this.operatorToString(item.operator)).append(" ");
            }
            ret.append(item.node);
        }
        return ret.toString();
    }

    public String operatorToString(int operator) {
        switch (operator) {
            case 0: {
                return null;
            }
            case 1: {
                return "or";
            }
            case 2: {
                return "and";
            }
        }
        throw new IllegalStateException("Logical operator " + operator + " not supported.");
    }

    private int stringToOperator(String operator) {
        if (operator == null) {
            return 0;
        }
        if (operator.equalsIgnoreCase("or")) {
            return 1;
        }
        if (operator.equalsIgnoreCase("and")) {
            return 2;
        }
        throw new IllegalStateException("Logical operator '" + operator + "' not supported.");
    }

    public final class NodeItem {
        private int operator;
        private ExpressionNode node;

        public NodeItem(int operator, ExpressionNode node) {
            this.operator = operator;
            this.node = node;
        }

        public int getOperator() {
            return this.operator;
        }

        public ExpressionNode getNode() {
            return this.node;
        }
    }

    private final class OrderingItem {
        private int operator;
        private OrderingSpecification ordering;

        public OrderingItem(int operator, OrderingSpecification orderSpec) {
            this.operator = operator;
            this.ordering = orderSpec;
        }
    }

    private final class BucketItem {
        private int operator;
        private BucketSet buckets;

        public BucketItem(int operator, BucketSet buckets) {
            this.operator = operator;
            this.buckets = buckets;
        }
    }

    private final class ValueItem {
        private int operator;
        private ResultList value;

        public ValueItem(int operator, ResultList value) {
            this.operator = operator;
            this.value = value;
        }
    }
}

