/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.rule;

import com.yahoo.collections.BobHash;
import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.FieldPathIteratorHandler;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.select.BucketSet;
import com.yahoo.document.select.Context;
import com.yahoo.document.select.OrderingSpecification;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.ResultList;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.rule.ExpressionNode;
import java.util.ArrayList;
import java.util.List;

public class AttributeNode
implements ExpressionNode {
    private ExpressionNode value;
    private final List<Item> items = new ArrayList<Item>();

    public AttributeNode(ExpressionNode value, List items) {
        this.value = value;
        for (Object obj : items) {
            if (obj instanceof Item) {
                this.items.add((Item)obj);
                continue;
            }
            throw new IllegalStateException("Can not add an instance of " + obj.getClass().getName() + " as a function item.");
        }
    }

    public ExpressionNode getValue() {
        return this.value;
    }

    public AttributeNode setValue(ExpressionNode value) {
        this.value = value;
        return this;
    }

    public List<Item> getItems() {
        return this.items;
    }

    @Override
    public BucketSet getBucketSet(BucketIdFactory factory) {
        return null;
    }

    @Override
    public Object evaluate(Context context) {
        String pos = this.value.toString();
        Object obj = this.value.evaluate(context);
        StringBuilder builder = new StringBuilder();
        for (Item item : this.items) {
            if (obj == null) {
                throw new IllegalStateException("Can not invoke '" + item + "' on '" + pos + "' because that term evaluated to null.");
            }
            if (item.getType() != 1) {
                if (builder.length() > 0) {
                    builder.append(".");
                }
                builder.append(item.getName());
            } else {
                if (builder.length() > 0) {
                    obj = AttributeNode.evaluateFieldPath(builder.toString(), obj);
                    builder = new StringBuilder();
                }
                obj = AttributeNode.evaluateFunction(item.getName(), obj);
            }
            pos = pos + "." + item;
        }
        if (builder.length() > 0) {
            obj = AttributeNode.evaluateFieldPath(builder.toString(), obj);
        }
        return obj;
    }

    private static Object applyFunction(String function, Object value) {
        if (function.equalsIgnoreCase("abs")) {
            if (Number.class.isInstance(value)) {
                Number nValue = (Number)value;
                if (value instanceof Double) {
                    return nValue.doubleValue() * (double)(nValue.doubleValue() < 0.0 ? -1 : 1);
                }
                if (value instanceof Float) {
                    return Float.valueOf(nValue.floatValue() * (float)(nValue.floatValue() < 0.0f ? -1 : 1));
                }
                if (value instanceof Long) {
                    return nValue.longValue() * (long)(nValue.longValue() < 0L ? -1 : 1);
                }
                if (value instanceof Integer) {
                    return nValue.intValue() * (nValue.intValue() < 0 ? -1 : 1);
                }
            }
            throw new IllegalStateException("Function 'abs' is only available for numerical values.");
        }
        if (function.equalsIgnoreCase("hash")) {
            return BobHash.hash((String)value.toString());
        }
        if (function.equalsIgnoreCase("lowercase")) {
            return value.toString().toLowerCase();
        }
        if (function.equalsIgnoreCase("uppercase")) {
            return value.toString().toUpperCase();
        }
        throw new IllegalStateException("Function '" + function + "' is not supported.");
    }

    private static Object evaluateFieldPath(String fieldPth, Object value) {
        if (value instanceof DocumentPut) {
            Document doc = ((DocumentPut)value).getDocument();
            FieldPath fieldPath = doc.getDataType().buildFieldPath(fieldPth);
            IteratorHandler handler = new IteratorHandler();
            doc.iterateNested(fieldPath, 0, handler);
            return handler.values;
        }
        if (value instanceof DocumentUpdate) {
            return Result.INVALID;
        }
        return Result.FALSE;
    }

    private static Object evaluateFunction(String function, Object value) {
        if (value instanceof VariableValueList) {
            VariableValueList retVal = new VariableValueList();
            for (ResultList.VariableValue val : (VariableValueList)value) {
                retVal.add(new ResultList.VariableValue((FieldPathIteratorHandler.VariableMap)val.getVariables().clone(), AttributeNode.applyFunction(function, val.getValue())));
            }
            return retVal;
        }
        return AttributeNode.applyFunction(function, value);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.value);
        for (Item item : this.items) {
            ret.append(".").append(item);
        }
        return ret.toString();
    }

    @Override
    public OrderingSpecification getOrdering(int order) {
        return null;
    }

    public static class Item {
        public static final int ATTRIBUTE = 0;
        public static final int FUNCTION = 1;
        private String name;
        private int type = 0;

        public Item(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Item setName(String name) {
            this.name = name;
            return this;
        }

        public int getType() {
            return this.type;
        }

        public Item setType(int type) {
            this.type = type;
            return this;
        }

        public String toString() {
            return this.name + (this.type == 1 ? "()" : "");
        }
    }

    static class IteratorHandler
    extends FieldPathIteratorHandler {
        VariableValueList values = new VariableValueList();

        IteratorHandler() {
        }

        @Override
        public void onPrimitive(FieldValue fv) {
            this.values.add(new ResultList.VariableValue((FieldPathIteratorHandler.VariableMap)this.getVariables().clone(), fv));
        }
    }

    public static class VariableValueList
    extends ArrayList<ResultList.VariableValue> {
    }
}

