/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import com.google.common.collect.ImmutableList;
import com.yahoo.collections.MD5;
import com.yahoo.document.DataType;
import com.yahoo.document.annotation.Annotation;
import java.util.Collection;

public class AnnotationType
implements Comparable<AnnotationType> {
    private final int id;
    private final String name;
    private DataType dataType;
    private AnnotationType superType = null;

    public AnnotationType(String name) {
        this(name, null);
    }

    public AnnotationType(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType;
        this.id = this.computeHash();
    }

    public AnnotationType(String name, DataType dataType, int id) {
        this.name = name;
        this.dataType = dataType;
        this.id = id;
    }

    public AnnotationType(String name, int id) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getId() {
        return this.id;
    }

    private int computeHash() {
        return new MD5().hash(this.name);
    }

    public boolean isValueCompatible(Annotation structValue) {
        return structValue.getType().inherits(this);
    }

    public void inherit(AnnotationType type) {
        if (this.superType != null) {
            throw new IllegalArgumentException("Already inherits type " + this.superType + ", multiple inheritance not currently supported.");
        }
        this.superType = type;
    }

    public Collection<AnnotationType> getInheritedTypes() {
        if (this.superType == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.superType);
    }

    public boolean inherits(AnnotationType type) {
        if (this.equals(type)) {
            return true;
        }
        return this.superType != null && this.superType.inherits(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationType)) {
            return false;
        }
        AnnotationType that = (AnnotationType)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.name).append(" (id ").append(this.id);
        if (this.dataType != null) {
            strb.append(", data type ").append(this.dataType);
        }
        strb.append(")");
        return strb.toString();
    }

    @Override
    public int compareTo(AnnotationType annotationType) {
        if (annotationType == null) {
            return 1;
        }
        if (this.id < annotationType.id) {
            return -1;
        }
        if (this.id > annotationType.id) {
            return 1;
        }
        return 0;
    }
}

