/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select;

import com.yahoo.document.DocumentOperation;
import com.yahoo.document.select.Context;
import com.yahoo.document.select.OrderingSpecification;
import com.yahoo.document.select.Result;
import com.yahoo.document.select.ResultList;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.select.parser.SelectInput;
import com.yahoo.document.select.parser.SelectParser;
import com.yahoo.document.select.parser.TokenMgrError;
import com.yahoo.document.select.rule.ExpressionNode;

public class DocumentSelector {
    private ExpressionNode expression;

    public DocumentSelector(String selector) throws ParseException {
        SelectInput input = new SelectInput(selector);
        try {
            SelectParser parser = new SelectParser(input);
            this.expression = parser.expression();
        }
        catch (TokenMgrError e) {
            ParseException t = new ParseException("Tokenization error parsing document selector '" + selector + "'");
            throw (ParseException)t.initCause(e);
        }
        catch (ParseException | RuntimeException e) {
            ParseException t = new ParseException("Exception parsing document selector '" + selector + "'");
            throw (ParseException)t.initCause(e instanceof ParseException ? new ParseException(input.formatException(e.getMessage())) : e);
        }
    }

    public Result accepts(DocumentOperation op) {
        return this.accepts(new Context(op));
    }

    public Result accepts(Context context) {
        return Result.toResult(this.expression.evaluate(context));
    }

    public ResultList getMatchingResultList(DocumentOperation op) {
        return this.getMatchingResultList(new Context(op));
    }

    public ResultList getMatchingResultList(Context context) {
        return ResultList.toResultList(this.expression.evaluate(context));
    }

    public String toString() {
        return this.expression.toString();
    }

    public OrderingSpecification getOrdering(int order) {
        return this.expression.getOrdering(order);
    }

    public void visit(Visitor visitor) {
        this.expression.accept(visitor);
    }
}

