/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DocumenttypesConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "3cec1835d5d5454672870b13108f57db";
    public static final String CONFIG_DEF_NAME = "documenttypes";
    public static final String CONFIG_DEF_NAMESPACE = "document";
    public static final String CONFIG_DEF_VERSION = "15";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=document", "enablecompression bool default=false", "documenttype[].id int", "documenttype[].name string", "documenttype[].version int default=0", "documenttype[].headerstruct int", "documenttype[].bodystruct int", "documenttype[].inherits[].id int", "documenttype[].datatype[].id int", "documenttype[].datatype[].type enum {STRUCT, ARRAY, WSET, MAP, ANNOTATIONREF, PRIMITIVE, TENSOR}", "documenttype[].datatype[].array.element.id int default=0", "documenttype[].datatype[].map.key.id int default=0", "documenttype[].datatype[].map.value.id int default=0", "documenttype[].datatype[].wset.key.id int default=0", "documenttype[].datatype[].wset.createifnonexistent bool default=false", "documenttype[].datatype[].wset.removeifzero bool default=false", "documenttype[].datatype[].annotationref.annotation.id int default=0", "documenttype[].datatype[].sstruct.name string default=\"\"", "documenttype[].datatype[].sstruct.version int default=0", "documenttype[].datatype[].sstruct.compression.type enum {NONE, LZ4} default=NONE", "documenttype[].datatype[].sstruct.compression.level int default=0", "documenttype[].datatype[].sstruct.compression.threshold int default=95", "documenttype[].datatype[].sstruct.compression.minsize int default=200", "documenttype[].datatype[].sstruct.field[].name string", "documenttype[].datatype[].sstruct.field[].id int", "documenttype[].datatype[].sstruct.field[].id_v6 int", "documenttype[].datatype[].sstruct.field[].datatype int", "documenttype[].datatype[].sstruct.field[].detailedtype string default=\"\"", "documenttype[].annotationtype[].id int", "documenttype[].annotationtype[].name string", "documenttype[].annotationtype[].datatype int default=-1", "documenttype[].annotationtype[].inherits[].id int", "documenttype[].fieldsets{}.fields[] string", "documenttype[].referencetype[].id int", "documenttype[].referencetype[].target_type_id int"};
    private final BooleanNode enablecompression;
    private final InnerNodeVector<Documenttype> documenttype;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public DocumenttypesConfig(Builder builder) {
        this(builder, true);
    }

    private DocumenttypesConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for documenttypes must be initialized: " + builder.__uninitialized);
        }
        this.enablecompression = builder.enablecompression == null ? new BooleanNode(false) : new BooleanNode(builder.enablecompression.booleanValue());
        this.documenttype = Documenttype.createVector(builder.documenttype);
    }

    public boolean enablecompression() {
        return this.enablecompression.value();
    }

    public List<Documenttype> documenttype() {
        return this.documenttype;
    }

    public Documenttype documenttype(int i) {
        return (Documenttype)((Object)this.documenttype.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DocumenttypesConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Documenttype
    extends InnerNode {
        private final IntegerNode id;
        private final StringNode name;
        private final IntegerNode version;
        private final IntegerNode headerstruct;
        private final IntegerNode bodystruct;
        private final InnerNodeVector<Inherits> inherits;
        private final InnerNodeVector<Datatype> datatype;
        private final InnerNodeVector<Annotationtype> annotationtype;
        private final Map<String, Fieldsets> fieldsets;
        private final InnerNodeVector<Referencetype> referencetype;

        @Deprecated
        private Documenttype() {
            this(new Builder(), false);
        }

        public Documenttype(Builder builder) {
            this(builder, true);
        }

        private Documenttype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
            this.headerstruct = builder.headerstruct == null ? new IntegerNode() : new IntegerNode(builder.headerstruct.intValue());
            this.bodystruct = builder.bodystruct == null ? new IntegerNode() : new IntegerNode(builder.bodystruct.intValue());
            this.inherits = Inherits.createVector(builder.inherits);
            this.datatype = Datatype.createVector(builder.datatype);
            this.annotationtype = Annotationtype.createVector(builder.annotationtype);
            this.fieldsets = Fieldsets.createMap(builder.fieldsets);
            this.referencetype = Referencetype.createVector(builder.referencetype);
        }

        public int id() {
            return this.id.value();
        }

        public String name() {
            return this.name.value();
        }

        public int version() {
            return this.version.value();
        }

        public int headerstruct() {
            return this.headerstruct.value();
        }

        public int bodystruct() {
            return this.bodystruct.value();
        }

        public List<Inherits> inherits() {
            return this.inherits;
        }

        public Inherits inherits(int i) {
            return (Inherits)((Object)this.inherits.get(i));
        }

        public List<Datatype> datatype() {
            return this.datatype;
        }

        public Datatype datatype(int i) {
            return (Datatype)((Object)this.datatype.get(i));
        }

        public List<Annotationtype> annotationtype() {
            return this.annotationtype;
        }

        public Annotationtype annotationtype(int i) {
            return (Annotationtype)((Object)this.annotationtype.get(i));
        }

        public Map<String, Fieldsets> fieldsets() {
            return Collections.unmodifiableMap(this.fieldsets);
        }

        public Fieldsets fieldsets(String key) {
            return this.fieldsets.get(key);
        }

        public List<Referencetype> referencetype() {
            return this.referencetype;
        }

        public Referencetype referencetype(int i) {
            return (Referencetype)((Object)this.referencetype.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
            return changes;
        }

        private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
            ArrayList<Documenttype> elems = new ArrayList<Documenttype>();
            for (Builder b : builders) {
                elems.add(new Documenttype(b));
            }
            return new InnerNodeVector(elems, (InnerNode)new Documenttype());
        }

        public static final class Referencetype
        extends InnerNode {
            private final IntegerNode id;
            private final IntegerNode target_type_id;

            @Deprecated
            private Referencetype() {
                this(new Builder(), false);
            }

            public Referencetype(Builder builder) {
                this(builder, true);
            }

            private Referencetype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].referencetype[] must be initialized: " + builder.__uninitialized);
                }
                this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
                this.target_type_id = builder.target_type_id == null ? new IntegerNode() : new IntegerNode(builder.target_type_id.intValue());
            }

            public int id() {
                return this.id.value();
            }

            public int target_type_id() {
                return this.target_type_id.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Referencetype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("referencetype");
                return changes;
            }

            private static InnerNodeVector<Referencetype> createVector(List<Builder> builders) {
                ArrayList<Referencetype> elems = new ArrayList<Referencetype>();
                for (Builder b : builders) {
                    elems.add(new Referencetype(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Referencetype());
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "target_type_id"));
                private Integer id = null;
                private Integer target_type_id = null;

                public Builder() {
                }

                public Builder(Referencetype config) {
                    this.id(config.id());
                    this.target_type_id(config.target_type_id());
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    if (__superior.target_type_id != null) {
                        this.target_type_id(__superior.target_type_id);
                    }
                    return this;
                }

                public Builder id(int __value) {
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                private Builder id(String __value) {
                    return this.id(Integer.valueOf(__value));
                }

                public Builder target_type_id(int __value) {
                    this.target_type_id = __value;
                    this.__uninitialized.remove("target_type_id");
                    return this;
                }

                private Builder target_type_id(String __value) {
                    return this.target_type_id(Integer.valueOf(__value));
                }
            }
        }

        public static final class Fieldsets
        extends InnerNode {
            private final LeafNodeVector<String, StringNode> fields;

            public Fieldsets(Builder builder) {
                this(builder, true);
            }

            private Fieldsets(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].fieldsets{} must be initialized: " + builder.__uninitialized);
                }
                this.fields = new LeafNodeVector(builder.fields, (LeafNode)new StringNode());
            }

            public List<String> fields() {
                return this.fields.asList();
            }

            public String fields(int i) {
                return ((StringNode)this.fields.get(i)).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
                return changes;
            }

            private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
                LinkedHashMap<String, Fieldsets> ret = new LinkedHashMap<String, Fieldsets>();
                for (String key : builders.keySet()) {
                    ret.put(key, new Fieldsets(builders.get(key)));
                }
                return Collections.unmodifiableMap(ret);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public List<String> fields = new ArrayList<String>();

                public Builder() {
                }

                public Builder(Fieldsets config) {
                    this.fields(config.fields());
                }

                private Builder override(Builder __superior) {
                    if (!__superior.fields.isEmpty()) {
                        this.fields.addAll(__superior.fields);
                    }
                    return this;
                }

                public Builder fields(String __value) {
                    this.fields.add(__value);
                    return this;
                }

                public Builder fields(Collection<String> __values) {
                    this.fields.addAll(__values);
                    return this;
                }
            }
        }

        public static final class Annotationtype
        extends InnerNode {
            private final IntegerNode id;
            private final StringNode name;
            private final IntegerNode datatype;
            private final InnerNodeVector<Inherits> inherits;

            @Deprecated
            private Annotationtype() {
                this(new Builder(), false);
            }

            public Annotationtype(Builder builder) {
                this(builder, true);
            }

            private Annotationtype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].annotationtype[] must be initialized: " + builder.__uninitialized);
                }
                this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.datatype = builder.datatype == null ? new IntegerNode(-1) : new IntegerNode(builder.datatype.intValue());
                this.inherits = Inherits.createVector(builder.inherits);
            }

            public int id() {
                return this.id.value();
            }

            public String name() {
                return this.name.value();
            }

            public int datatype() {
                return this.datatype.value();
            }

            public List<Inherits> inherits() {
                return this.inherits;
            }

            public Inherits inherits(int i) {
                return (Inherits)((Object)this.inherits.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
                return changes;
            }

            private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
                ArrayList<Annotationtype> elems = new ArrayList<Annotationtype>();
                for (Builder b : builders) {
                    elems.add(new Annotationtype(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Annotationtype());
            }

            public static final class Inherits
            extends InnerNode {
                private final IntegerNode id;

                @Deprecated
                private Inherits() {
                    this(new Builder(), false);
                }

                public Inherits(Builder builder) {
                    this(builder, true);
                }

                private Inherits(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].annotationtype[].inherits[] must be initialized: " + builder.__uninitialized);
                    }
                    this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
                }

                public int id() {
                    return this.id.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                    return changes;
                }

                private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                    ArrayList<Inherits> elems = new ArrayList<Inherits>();
                    for (Builder b : builders) {
                        elems.add(new Inherits(b));
                    }
                    return new InnerNodeVector(elems, (InnerNode)new Inherits());
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
                    private Integer id = null;

                    public Builder() {
                    }

                    public Builder(Inherits config) {
                        this.id(config.id());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.id != null) {
                            this.id(__superior.id);
                        }
                        return this;
                    }

                    public Builder id(int __value) {
                        this.id = __value;
                        this.__uninitialized.remove("id");
                        return this;
                    }

                    private Builder id(String __value) {
                        return this.id(Integer.valueOf(__value));
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "name"));
                private Integer id = null;
                private String name = null;
                private Integer datatype = null;
                public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();

                public Builder() {
                }

                public Builder(Annotationtype config) {
                    this.id(config.id());
                    this.name(config.name());
                    this.datatype(config.datatype());
                    for (Inherits i : config.inherits()) {
                        this.inherits(new Inherits.Builder(i));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.datatype != null) {
                        this.datatype(__superior.datatype);
                    }
                    if (!__superior.inherits.isEmpty()) {
                        this.inherits.addAll(__superior.inherits);
                    }
                    return this;
                }

                public Builder id(int __value) {
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                private Builder id(String __value) {
                    return this.id(Integer.valueOf(__value));
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder datatype(int __value) {
                    this.datatype = __value;
                    return this;
                }

                private Builder datatype(String __value) {
                    return this.datatype(Integer.valueOf(__value));
                }

                public Builder inherits(Inherits.Builder __builder) {
                    this.inherits.add(__builder);
                    return this;
                }

                public Builder inherits(List<Inherits.Builder> __builders) {
                    this.inherits = __builders;
                    return this;
                }
            }
        }

        public static final class Datatype
        extends InnerNode {
            private final IntegerNode id;
            private final Type type;
            private final Array array;
            private final Map map;
            private final Wset wset;
            private final Annotationref annotationref;
            private final Sstruct sstruct;

            @Deprecated
            private Datatype() {
                this(new Builder(), false);
            }

            public Datatype(Builder builder) {
                this(builder, true);
            }

            private Datatype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[] must be initialized: " + builder.__uninitialized);
                }
                this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
                this.type = builder.type == null ? new Type() : new Type(builder.type);
                this.array = new Array(builder.array, throwIfUninitialized);
                this.map = new Map(builder.map, throwIfUninitialized);
                this.wset = new Wset(builder.wset, throwIfUninitialized);
                this.annotationref = new Annotationref(builder.annotationref, throwIfUninitialized);
                this.sstruct = new Sstruct(builder.sstruct, throwIfUninitialized);
            }

            public int id() {
                return this.id.value();
            }

            public Type.Enum type() {
                return (Type.Enum)((Object)this.type.value());
            }

            public Array array() {
                return this.array;
            }

            public Map map() {
                return this.map;
            }

            public Wset wset() {
                return this.wset;
            }

            public Annotationref annotationref() {
                return this.annotationref;
            }

            public Sstruct sstruct() {
                return this.sstruct;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Datatype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("datatype");
                return changes;
            }

            private static InnerNodeVector<Datatype> createVector(List<Builder> builders) {
                ArrayList<Datatype> elems = new ArrayList<Datatype>();
                for (Builder b : builders) {
                    elems.add(new Datatype(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Datatype());
            }

            public static final class Sstruct
            extends InnerNode {
                private final StringNode name;
                private final IntegerNode version;
                private final Compression compression;
                private final InnerNodeVector<Field> field;

                public Sstruct(Builder builder) {
                    this(builder, true);
                }

                private Sstruct(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].sstruct must be initialized: " + builder.__uninitialized);
                    }
                    this.name = builder.name == null ? new StringNode("") : new StringNode(builder.name);
                    this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                    this.compression = new Compression(builder.compression, throwIfUninitialized);
                    this.field = Field.createVector(builder.field);
                }

                public String name() {
                    return this.name.value();
                }

                public int version() {
                    return this.version.value();
                }

                public Compression compression() {
                    return this.compression;
                }

                public List<Field> field() {
                    return this.field;
                }

                public Field field(int i) {
                    return (Field)((Object)this.field.get(i));
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Sstruct newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("sstruct");
                    return changes;
                }

                public static final class Field
                extends InnerNode {
                    private final StringNode name;
                    private final IntegerNode id;
                    private final IntegerNode id_v6;
                    private final IntegerNode datatype;
                    private final StringNode detailedtype;

                    @Deprecated
                    private Field() {
                        this(new Builder(), false);
                    }

                    public Field(Builder builder) {
                        this(builder, true);
                    }

                    private Field(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].sstruct.field[] must be initialized: " + builder.__uninitialized);
                        }
                        this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                        this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
                        this.id_v6 = builder.id_v6 == null ? new IntegerNode() : new IntegerNode(builder.id_v6.intValue());
                        this.datatype = builder.datatype == null ? new IntegerNode() : new IntegerNode(builder.datatype.intValue());
                        this.detailedtype = builder.detailedtype == null ? new StringNode("") : new StringNode(builder.detailedtype);
                    }

                    public String name() {
                        return this.name.value();
                    }

                    public int id() {
                        return this.id.value();
                    }

                    public int id_v6() {
                        return this.id_v6.value();
                    }

                    public int datatype() {
                        return this.datatype.value();
                    }

                    public String detailedtype() {
                        return this.detailedtype.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                        return changes;
                    }

                    private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                        ArrayList<Field> elems = new ArrayList<Field>();
                        for (Builder b : builders) {
                            elems.add(new Field(b));
                        }
                        return new InnerNodeVector(elems, (InnerNode)new Field());
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "id", "id_v6", "datatype"));
                        private String name = null;
                        private Integer id = null;
                        private Integer id_v6 = null;
                        private Integer datatype = null;
                        private String detailedtype = null;

                        public Builder() {
                        }

                        public Builder(Field config) {
                            this.name(config.name());
                            this.id(config.id());
                            this.id_v6(config.id_v6());
                            this.datatype(config.datatype());
                            this.detailedtype(config.detailedtype());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.name != null) {
                                this.name(__superior.name);
                            }
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            if (__superior.id_v6 != null) {
                                this.id_v6(__superior.id_v6);
                            }
                            if (__superior.datatype != null) {
                                this.datatype(__superior.datatype);
                            }
                            if (__superior.detailedtype != null) {
                                this.detailedtype(__superior.detailedtype);
                            }
                            return this;
                        }

                        public Builder name(String __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.name = __value;
                            this.__uninitialized.remove("name");
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            this.__uninitialized.remove("id");
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }

                        public Builder id_v6(int __value) {
                            this.id_v6 = __value;
                            this.__uninitialized.remove("id_v6");
                            return this;
                        }

                        private Builder id_v6(String __value) {
                            return this.id_v6(Integer.valueOf(__value));
                        }

                        public Builder datatype(int __value) {
                            this.datatype = __value;
                            this.__uninitialized.remove("datatype");
                            return this;
                        }

                        private Builder datatype(String __value) {
                            return this.datatype(Integer.valueOf(__value));
                        }

                        public Builder detailedtype(String __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.detailedtype = __value;
                            return this;
                        }
                    }
                }

                public static final class Compression
                extends InnerNode {
                    private final Type type;
                    private final IntegerNode level;
                    private final IntegerNode threshold;
                    private final IntegerNode minsize;

                    public Compression(Builder builder) {
                        this(builder, true);
                    }

                    private Compression(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].sstruct.compression must be initialized: " + builder.__uninitialized);
                        }
                        this.type = builder.type == null ? new Type(Type.NONE) : new Type(builder.type);
                        this.level = builder.level == null ? new IntegerNode(0) : new IntegerNode(builder.level.intValue());
                        this.threshold = builder.threshold == null ? new IntegerNode(95) : new IntegerNode(builder.threshold.intValue());
                        this.minsize = builder.minsize == null ? new IntegerNode(200) : new IntegerNode(builder.minsize.intValue());
                    }

                    public Type.Enum type() {
                        return (Type.Enum)((Object)this.type.value());
                    }

                    public int level() {
                        return this.level.value();
                    }

                    public int threshold() {
                        return this.threshold.value();
                    }

                    public int minsize() {
                        return this.minsize.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
                        return changes;
                    }

                    public static final class Type
                    extends EnumNode<Enum> {
                        public static final Enum NONE = Enum.NONE;
                        public static final Enum LZ4 = Enum.LZ4;

                        public Type() {
                            this.value = null;
                        }

                        public Type(Enum enumValue) {
                            super(enumValue != null);
                            this.value = enumValue;
                        }

                        protected boolean doSetValue(@NonNull String name) {
                            try {
                                this.value = Enum.valueOf(name);
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                return false;
                            }
                        }

                        public static enum Enum {
                            NONE,
                            LZ4;

                        }
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Type.Enum type = null;
                        private Integer level = null;
                        private Integer threshold = null;
                        private Integer minsize = null;

                        public Builder() {
                        }

                        public Builder(Compression config) {
                            this.type(config.type());
                            this.level(config.level());
                            this.threshold(config.threshold());
                            this.minsize(config.minsize());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.type != null) {
                                this.type(__superior.type);
                            }
                            if (__superior.level != null) {
                                this.level(__superior.level);
                            }
                            if (__superior.threshold != null) {
                                this.threshold(__superior.threshold);
                            }
                            if (__superior.minsize != null) {
                                this.minsize(__superior.minsize);
                            }
                            return this;
                        }

                        public Builder type(Type.Enum __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.type = __value;
                            return this;
                        }

                        private Builder type(String __value) {
                            return this.type(Type.Enum.valueOf(__value));
                        }

                        public Builder level(int __value) {
                            this.level = __value;
                            return this;
                        }

                        private Builder level(String __value) {
                            return this.level(Integer.valueOf(__value));
                        }

                        public Builder threshold(int __value) {
                            this.threshold = __value;
                            return this;
                        }

                        private Builder threshold(String __value) {
                            return this.threshold(Integer.valueOf(__value));
                        }

                        public Builder minsize(int __value) {
                            this.minsize = __value;
                            return this;
                        }

                        private Builder minsize(String __value) {
                            return this.minsize(Integer.valueOf(__value));
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private String name = null;
                    private Integer version = null;
                    public Compression.Builder compression = new Compression.Builder();
                    public List<Field.Builder> field = new ArrayList<Field.Builder>();

                    public Builder() {
                    }

                    public Builder(Sstruct config) {
                        this.name(config.name());
                        this.version(config.version());
                        this.compression(new Compression.Builder(config.compression()));
                        for (Field f : config.field()) {
                            this.field(new Field.Builder(f));
                        }
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.version != null) {
                            this.version(__superior.version);
                        }
                        this.compression(this.compression.override(__superior.compression));
                        if (!__superior.field.isEmpty()) {
                            this.field.addAll(__superior.field);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        return this;
                    }

                    public Builder version(int __value) {
                        this.version = __value;
                        return this;
                    }

                    private Builder version(String __value) {
                        return this.version(Integer.valueOf(__value));
                    }

                    public Builder compression(Compression.Builder __builder) {
                        this.compression = __builder;
                        return this;
                    }

                    public Builder field(Field.Builder __builder) {
                        this.field.add(__builder);
                        return this;
                    }

                    public Builder field(List<Field.Builder> __builders) {
                        this.field = __builders;
                        return this;
                    }
                }
            }

            public static final class Annotationref
            extends InnerNode {
                private final Annotation annotation;

                public Annotationref(Builder builder) {
                    this(builder, true);
                }

                private Annotationref(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].annotationref must be initialized: " + builder.__uninitialized);
                    }
                    this.annotation = new Annotation(builder.annotation, throwIfUninitialized);
                }

                public Annotation annotation() {
                    return this.annotation;
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Annotationref newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationref");
                    return changes;
                }

                public static final class Annotation
                extends InnerNode {
                    private final IntegerNode id;

                    public Annotation(Builder builder) {
                        this(builder, true);
                    }

                    private Annotation(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].annotationref.annotation must be initialized: " + builder.__uninitialized);
                        }
                        this.id = builder.id == null ? new IntegerNode(0) : new IntegerNode(builder.id.intValue());
                    }

                    public int id() {
                        return this.id.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Annotation newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("annotation");
                        return changes;
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Integer id = null;

                        public Builder() {
                        }

                        public Builder(Annotation config) {
                            this.id(config.id());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public Annotation.Builder annotation = new Annotation.Builder();

                    public Builder() {
                    }

                    public Builder(Annotationref config) {
                        this.annotation(new Annotation.Builder(config.annotation()));
                    }

                    private Builder override(Builder __superior) {
                        this.annotation(this.annotation.override(__superior.annotation));
                        return this;
                    }

                    public Builder annotation(Annotation.Builder __builder) {
                        this.annotation = __builder;
                        return this;
                    }
                }
            }

            public static final class Wset
            extends InnerNode {
                private final Key key;
                private final BooleanNode createifnonexistent;
                private final BooleanNode removeifzero;

                public Wset(Builder builder) {
                    this(builder, true);
                }

                private Wset(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].wset must be initialized: " + builder.__uninitialized);
                    }
                    this.key = new Key(builder.key, throwIfUninitialized);
                    this.createifnonexistent = builder.createifnonexistent == null ? new BooleanNode(false) : new BooleanNode(builder.createifnonexistent.booleanValue());
                    this.removeifzero = builder.removeifzero == null ? new BooleanNode(false) : new BooleanNode(builder.removeifzero.booleanValue());
                }

                public Key key() {
                    return this.key;
                }

                public boolean createifnonexistent() {
                    return this.createifnonexistent.value();
                }

                public boolean removeifzero() {
                    return this.removeifzero.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Wset newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("wset");
                    return changes;
                }

                public static final class Key
                extends InnerNode {
                    private final IntegerNode id;

                    public Key(Builder builder) {
                        this(builder, true);
                    }

                    private Key(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].wset.key must be initialized: " + builder.__uninitialized);
                        }
                        this.id = builder.id == null ? new IntegerNode(0) : new IntegerNode(builder.id.intValue());
                    }

                    public int id() {
                        return this.id.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Key newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("key");
                        return changes;
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Integer id = null;

                        public Builder() {
                        }

                        public Builder(Key config) {
                            this.id(config.id());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public Key.Builder key = new Key.Builder();
                    private Boolean createifnonexistent = null;
                    private Boolean removeifzero = null;

                    public Builder() {
                    }

                    public Builder(Wset config) {
                        this.key(new Key.Builder(config.key()));
                        this.createifnonexistent(config.createifnonexistent());
                        this.removeifzero(config.removeifzero());
                    }

                    private Builder override(Builder __superior) {
                        this.key(this.key.override(__superior.key));
                        if (__superior.createifnonexistent != null) {
                            this.createifnonexistent(__superior.createifnonexistent);
                        }
                        if (__superior.removeifzero != null) {
                            this.removeifzero(__superior.removeifzero);
                        }
                        return this;
                    }

                    public Builder key(Key.Builder __builder) {
                        this.key = __builder;
                        return this;
                    }

                    public Builder createifnonexistent(boolean __value) {
                        this.createifnonexistent = __value;
                        return this;
                    }

                    private Builder createifnonexistent(String __value) {
                        return this.createifnonexistent(Boolean.valueOf(__value));
                    }

                    public Builder removeifzero(boolean __value) {
                        this.removeifzero = __value;
                        return this;
                    }

                    private Builder removeifzero(String __value) {
                        return this.removeifzero(Boolean.valueOf(__value));
                    }
                }
            }

            public static final class Map
            extends InnerNode {
                private final Key key;
                private final Value value;

                public Map(Builder builder) {
                    this(builder, true);
                }

                private Map(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].map must be initialized: " + builder.__uninitialized);
                    }
                    this.key = new Key(builder.key, throwIfUninitialized);
                    this.value = new Value(builder.value, throwIfUninitialized);
                }

                public Key key() {
                    return this.key;
                }

                public Value value() {
                    return this.value;
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Map newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("map");
                    return changes;
                }

                public static final class Value
                extends InnerNode {
                    private final IntegerNode id;

                    public Value(Builder builder) {
                        this(builder, true);
                    }

                    private Value(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].map.value must be initialized: " + builder.__uninitialized);
                        }
                        this.id = builder.id == null ? new IntegerNode(0) : new IntegerNode(builder.id.intValue());
                    }

                    public int id() {
                        return this.id.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Value newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("value");
                        return changes;
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Integer id = null;

                        public Builder() {
                        }

                        public Builder(Value config) {
                            this.id(config.id());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }
                    }
                }

                public static final class Key
                extends InnerNode {
                    private final IntegerNode id;

                    public Key(Builder builder) {
                        this(builder, true);
                    }

                    private Key(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].map.key must be initialized: " + builder.__uninitialized);
                        }
                        this.id = builder.id == null ? new IntegerNode(0) : new IntegerNode(builder.id.intValue());
                    }

                    public int id() {
                        return this.id.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Key newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("key");
                        return changes;
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Integer id = null;

                        public Builder() {
                        }

                        public Builder(Key config) {
                            this.id(config.id());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public Key.Builder key = new Key.Builder();
                    public Value.Builder value = new Value.Builder();

                    public Builder() {
                    }

                    public Builder(Map config) {
                        this.key(new Key.Builder(config.key()));
                        this.value(new Value.Builder(config.value()));
                    }

                    private Builder override(Builder __superior) {
                        this.key(this.key.override(__superior.key));
                        this.value(this.value.override(__superior.value));
                        return this;
                    }

                    public Builder key(Key.Builder __builder) {
                        this.key = __builder;
                        return this;
                    }

                    public Builder value(Value.Builder __builder) {
                        this.value = __builder;
                        return this;
                    }
                }
            }

            public static final class Array
            extends InnerNode {
                private final Element element;

                public Array(Builder builder) {
                    this(builder, true);
                }

                private Array(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].array must be initialized: " + builder.__uninitialized);
                    }
                    this.element = new Element(builder.element, throwIfUninitialized);
                }

                public Element element() {
                    return this.element;
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Array newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("array");
                    return changes;
                }

                public static final class Element
                extends InnerNode {
                    private final IntegerNode id;

                    public Element(Builder builder) {
                        this(builder, true);
                    }

                    private Element(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].datatype[].array.element must be initialized: " + builder.__uninitialized);
                        }
                        this.id = builder.id == null ? new IntegerNode(0) : new IntegerNode(builder.id.intValue());
                    }

                    public int id() {
                        return this.id.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Element newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("element");
                        return changes;
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Integer id = null;

                        public Builder() {
                        }

                        public Builder(Element config) {
                            this.id(config.id());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public Element.Builder element = new Element.Builder();

                    public Builder() {
                    }

                    public Builder(Array config) {
                        this.element(new Element.Builder(config.element()));
                    }

                    private Builder override(Builder __superior) {
                        this.element(this.element.override(__superior.element));
                        return this;
                    }

                    public Builder element(Element.Builder __builder) {
                        this.element = __builder;
                        return this;
                    }
                }
            }

            public static final class Type
            extends EnumNode<Enum> {
                public static final Enum STRUCT = Enum.STRUCT;
                public static final Enum ARRAY = Enum.ARRAY;
                public static final Enum WSET = Enum.WSET;
                public static final Enum MAP = Enum.MAP;
                public static final Enum ANNOTATIONREF = Enum.ANNOTATIONREF;
                public static final Enum PRIMITIVE = Enum.PRIMITIVE;
                public static final Enum TENSOR = Enum.TENSOR;

                public Type() {
                    this.value = null;
                }

                public Type(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(@NonNull String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    STRUCT,
                    ARRAY,
                    WSET,
                    MAP,
                    ANNOTATIONREF,
                    PRIMITIVE,
                    TENSOR;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "type"));
                private Integer id = null;
                private Type.Enum type = null;
                public Array.Builder array = new Array.Builder();
                public Map.Builder map = new Map.Builder();
                public Wset.Builder wset = new Wset.Builder();
                public Annotationref.Builder annotationref = new Annotationref.Builder();
                public Sstruct.Builder sstruct = new Sstruct.Builder();

                public Builder() {
                }

                public Builder(Datatype config) {
                    this.id(config.id());
                    this.type(config.type());
                    this.array(new Array.Builder(config.array()));
                    this.map(new Map.Builder(config.map()));
                    this.wset(new Wset.Builder(config.wset()));
                    this.annotationref(new Annotationref.Builder(config.annotationref()));
                    this.sstruct(new Sstruct.Builder(config.sstruct()));
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    this.array(this.array.override(__superior.array));
                    this.map(this.map.override(__superior.map));
                    this.wset(this.wset.override(__superior.wset));
                    this.annotationref(this.annotationref.override(__superior.annotationref));
                    this.sstruct(this.sstruct.override(__superior.sstruct));
                    return this;
                }

                public Builder id(int __value) {
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                private Builder id(String __value) {
                    return this.id(Integer.valueOf(__value));
                }

                public Builder type(Type.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    this.__uninitialized.remove("type");
                    return this;
                }

                private Builder type(String __value) {
                    return this.type(Type.Enum.valueOf(__value));
                }

                public Builder array(Array.Builder __builder) {
                    this.array = __builder;
                    return this;
                }

                public Builder map(Map.Builder __builder) {
                    this.map = __builder;
                    return this;
                }

                public Builder wset(Wset.Builder __builder) {
                    this.wset = __builder;
                    return this;
                }

                public Builder annotationref(Annotationref.Builder __builder) {
                    this.annotationref = __builder;
                    return this;
                }

                public Builder sstruct(Sstruct.Builder __builder) {
                    this.sstruct = __builder;
                    return this;
                }
            }
        }

        public static final class Inherits
        extends InnerNode {
            private final IntegerNode id;

            @Deprecated
            private Inherits() {
                this(new Builder(), false);
            }

            public Inherits(Builder builder) {
                this(builder, true);
            }

            private Inherits(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documenttypes.documenttype[].inherits[] must be initialized: " + builder.__uninitialized);
                }
                this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            }

            public int id() {
                return this.id.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                return changes;
            }

            private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                ArrayList<Inherits> elems = new ArrayList<Inherits>();
                for (Builder b : builders) {
                    elems.add(new Inherits(b));
                }
                return new InnerNodeVector(elems, (InnerNode)new Inherits());
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
                private Integer id = null;

                public Builder() {
                }

                public Builder(Inherits config) {
                    this.id(config.id());
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    return this;
                }

                public Builder id(int __value) {
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                private Builder id(String __value) {
                    return this.id(Integer.valueOf(__value));
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id", "name", "headerstruct", "bodystruct"));
            private Integer id = null;
            private String name = null;
            private Integer version = null;
            private Integer headerstruct = null;
            private Integer bodystruct = null;
            public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();
            public List<Datatype.Builder> datatype = new ArrayList<Datatype.Builder>();
            public List<Annotationtype.Builder> annotationtype = new ArrayList<Annotationtype.Builder>();
            public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<String, Fieldsets.Builder>();
            public List<Referencetype.Builder> referencetype = new ArrayList<Referencetype.Builder>();

            public Builder() {
            }

            public Builder(Documenttype config) {
                this.id(config.id());
                this.name(config.name());
                this.version(config.version());
                this.headerstruct(config.headerstruct());
                this.bodystruct(config.bodystruct());
                for (Inherits inherits : config.inherits()) {
                    this.inherits(new Inherits.Builder(inherits));
                }
                for (Datatype datatype : config.datatype()) {
                    this.datatype(new Datatype.Builder(datatype));
                }
                for (Annotationtype annotationtype : config.annotationtype()) {
                    this.annotationtype(new Annotationtype.Builder(annotationtype));
                }
                for (Map.Entry entry : config.fieldsets().entrySet()) {
                    this.fieldsets((String)entry.getKey(), new Fieldsets.Builder((Fieldsets)((Object)entry.getValue())));
                }
                for (Referencetype referencetype : config.referencetype()) {
                    this.referencetype(new Referencetype.Builder(referencetype));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.version != null) {
                    this.version(__superior.version);
                }
                if (__superior.headerstruct != null) {
                    this.headerstruct(__superior.headerstruct);
                }
                if (__superior.bodystruct != null) {
                    this.bodystruct(__superior.bodystruct);
                }
                if (!__superior.inherits.isEmpty()) {
                    this.inherits.addAll(__superior.inherits);
                }
                if (!__superior.datatype.isEmpty()) {
                    this.datatype.addAll(__superior.datatype);
                }
                if (!__superior.annotationtype.isEmpty()) {
                    this.annotationtype.addAll(__superior.annotationtype);
                }
                this.fieldsets(__superior.fieldsets);
                if (!__superior.referencetype.isEmpty()) {
                    this.referencetype.addAll(__superior.referencetype);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder version(int __value) {
                this.version = __value;
                return this;
            }

            private Builder version(String __value) {
                return this.version(Integer.valueOf(__value));
            }

            public Builder headerstruct(int __value) {
                this.headerstruct = __value;
                this.__uninitialized.remove("headerstruct");
                return this;
            }

            private Builder headerstruct(String __value) {
                return this.headerstruct(Integer.valueOf(__value));
            }

            public Builder bodystruct(int __value) {
                this.bodystruct = __value;
                this.__uninitialized.remove("bodystruct");
                return this;
            }

            private Builder bodystruct(String __value) {
                return this.bodystruct(Integer.valueOf(__value));
            }

            public Builder inherits(Inherits.Builder __builder) {
                this.inherits.add(__builder);
                return this;
            }

            public Builder inherits(List<Inherits.Builder> __builders) {
                this.inherits = __builders;
                return this;
            }

            public Builder datatype(Datatype.Builder __builder) {
                this.datatype.add(__builder);
                return this;
            }

            public Builder datatype(List<Datatype.Builder> __builders) {
                this.datatype = __builders;
                return this;
            }

            public Builder annotationtype(Annotationtype.Builder __builder) {
                this.annotationtype.add(__builder);
                return this;
            }

            public Builder annotationtype(List<Annotationtype.Builder> __builders) {
                this.annotationtype = __builders;
                return this;
            }

            public Builder fieldsets(String __key, Fieldsets.Builder __value) {
                this.fieldsets.put(__key, __value);
                return this;
            }

            public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
                this.fieldsets.putAll(__values);
                return this;
            }

            public Builder referencetype(Referencetype.Builder __builder) {
                this.referencetype.add(__builder);
                return this;
            }

            public Builder referencetype(List<Referencetype.Builder> __builders) {
                this.referencetype = __builders;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean enablecompression = null;
        public List<Documenttype.Builder> documenttype = new ArrayList<Documenttype.Builder>();

        public Builder() {
        }

        public Builder(DocumenttypesConfig config) {
            this.enablecompression(config.enablecompression());
            for (Documenttype d : config.documenttype()) {
                this.documenttype(new Documenttype.Builder(d));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.enablecompression != null) {
                this.enablecompression(__superior.enablecompression);
            }
            if (!__superior.documenttype.isEmpty()) {
                this.documenttype.addAll(__superior.documenttype);
            }
            return this;
        }

        public Builder enablecompression(boolean __value) {
            this.enablecompression = __value;
            return this;
        }

        private Builder enablecompression(String __value) {
            return this.enablecompression(Boolean.valueOf(__value));
        }

        public Builder documenttype(Documenttype.Builder __builder) {
            this.documenttype.add(__builder);
            return this;
        }

        public Builder documenttype(List<Documenttype.Builder> __builders) {
            this.documenttype = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DocumenttypesConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DocumenttypesConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DocumenttypesConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

