/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docprocs.indexing;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.fieldpathupdate.AssignFieldPathUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespa.indexinglanguage.AdapterFactory;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DocumentScript {
    private final DocumentType documentType;
    private final Set<String> inputFields;
    private final ScriptExpression expression;

    public DocumentScript(DocumentType documentType, Collection<String> inputFields, ScriptExpression expression) {
        this.documentType = documentType;
        this.inputFields = new HashSet<String>(inputFields);
        this.expression = expression;
        expression.verify(documentType);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Document execute(AdapterFactory adapterFactory, Document document) {
        for (Map.Entry entry : document) {
            this.requireThatFieldIsDeclaredInDocument((Field)entry.getKey());
            this.removeAnyLinguisticsSpanTree((FieldValue)entry.getValue());
        }
        return this.expression.execute(adapterFactory, document);
    }

    public DocumentUpdate execute(AdapterFactory adapterFactory, DocumentUpdate update) {
        for (FieldUpdate fieldUpdate : update.fieldUpdates()) {
            this.requireThatFieldIsDeclaredInDocument(fieldUpdate.getField());
            for (ValueUpdate valueUpdate : fieldUpdate.getValueUpdates()) {
                this.removeAnyLinguisticsSpanTree(valueUpdate);
            }
        }
        for (FieldUpdate fieldUpdate : update.fieldPathUpdates()) {
            this.requireThatFieldIsDeclaredInDocument(fieldUpdate.getFieldPath().get(0).getFieldRef());
            if (!(fieldUpdate instanceof AssignFieldPathUpdate)) continue;
            this.removeAnyLinguisticsSpanTree(((AssignFieldPathUpdate)fieldUpdate).getFieldValue());
        }
        return Expression.execute((Expression)this.expression, (AdapterFactory)adapterFactory, (DocumentUpdate)update);
    }

    private void requireThatFieldIsDeclaredInDocument(Field field) {
        if (field != null && !this.inputFields.contains(field.getName())) {
            throw new IllegalArgumentException("Field '" + field.getName() + "' is not part of the declared " + this.documentType);
        }
    }

    private void removeAnyLinguisticsSpanTree(ValueUpdate<?> valueUpdate) {
        if (valueUpdate instanceof MapValueUpdate) {
            this.removeAnyLinguisticsSpanTree(((MapValueUpdate)valueUpdate).getUpdate());
        } else {
            this.removeAnyLinguisticsSpanTree(valueUpdate.getValue());
        }
    }

    private void removeAnyLinguisticsSpanTree(FieldValue value) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (!(value instanceof StringFieldValue)) break block4;
                            ((StringFieldValue)value).removeSpanTree("linguistics");
                            break block5;
                        }
                        if (!(value instanceof Array)) break block6;
                        Array arr = (Array)value;
                        for (FieldValue fieldValue : arr.getValues()) {
                            this.removeAnyLinguisticsSpanTree(fieldValue);
                        }
                        break block5;
                    }
                    if (!(value instanceof WeightedSet)) break block7;
                    WeightedSet wset = (WeightedSet)value;
                    for (FieldValue fieldValue : wset.keySet()) {
                        this.removeAnyLinguisticsSpanTree(fieldValue);
                    }
                    break block5;
                }
                if (!(value instanceof MapFieldValue)) break block8;
                MapFieldValue map = (MapFieldValue)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.removeAnyLinguisticsSpanTree((FieldValue)entry.getKey());
                    this.removeAnyLinguisticsSpanTree((FieldValue)entry.getValue());
                }
                break block5;
            }
            if (!(value instanceof StructuredFieldValue)) break block5;
            StructuredFieldValue struct = (StructuredFieldValue)value;
            Iterator it = struct.iterator();
            while (it.hasNext()) {
                this.removeAnyLinguisticsSpanTree((FieldValue)((Map.Entry)it.next()).getValue());
            }
        }
    }

    public String toString() {
        return "indexing script for '" + this.documentType + "' given inputs " + this.inputFields + ": " + this.expression;
    }
}

