/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc.messagebus;

import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.SystemTimer;
import com.yahoo.container.core.document.ContainerDocumentConfig;
import com.yahoo.docproc.AbstractConcreteDocumentFactory;
import com.yahoo.docproc.Processing;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentRemove;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.documentapi.messagebus.protocol.PutDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.RemoveDocumentMessage;
import com.yahoo.documentapi.messagebus.protocol.UpdateDocumentMessage;
import com.yahoo.messagebus.Message;
import java.util.List;
import java.util.logging.Logger;

class ProcessingFactory {
    private static final Logger log = Logger.getLogger(ProcessingFactory.class.getName());
    private final ComponentRegistry<AbstractConcreteDocumentFactory> docFactoryRegistry;
    private final ContainerDocumentConfig containerDocConfig;
    private final String serviceName;

    public ProcessingFactory(ComponentRegistry<AbstractConcreteDocumentFactory> docFactoryRegistry, ContainerDocumentConfig containerDocConfig, String serviceName) {
        this.docFactoryRegistry = docFactoryRegistry;
        this.containerDocConfig = containerDocConfig;
        this.serviceName = serviceName;
    }

    public List<Processing> fromMessage(Message message) {
        return switch (message.getType()) {
            case 100004 -> {
                PutDocumentMessage putMessage = (PutDocumentMessage)message;
                DocumentPut putOperation = new DocumentPut(this.createPutDocument(putMessage));
                putOperation.setCondition(putMessage.getCondition());
                putOperation.setCreateIfNonExistent(putMessage.getCreateIfNonExistent());
                yield List.of(this.createProcessing((DocumentOperation)putOperation, message));
            }
            case 100006 -> {
                UpdateDocumentMessage updateMessage = (UpdateDocumentMessage)message;
                DocumentUpdate updateOperation = updateMessage.getDocumentUpdate();
                updateOperation.setCondition(updateMessage.getCondition());
                yield List.of(this.createProcessing((DocumentOperation)updateOperation, message));
            }
            case 100005 -> {
                RemoveDocumentMessage removeMessage = (RemoveDocumentMessage)message;
                DocumentRemove removeOperation = new DocumentRemove(removeMessage.getDocumentId());
                removeOperation.setCondition(removeMessage.getCondition());
                yield List.of(this.createProcessing((DocumentOperation)removeOperation, message));
            }
            default -> List.of();
        };
    }

    private Document createPutDocument(PutDocumentMessage msg) {
        Document document = msg.getDocumentPut().getDocument();
        String typeName = document.getDataType().getName();
        ContainerDocumentConfig.Doctype typeConfig = this.getDocumentConfig(typeName);
        if (typeConfig == null) {
            return document;
        }
        return this.createConcreteDocument(document, typeConfig);
    }

    private Document createConcreteDocument(Document document, ContainerDocumentConfig.Doctype typeConfig) {
        String componentId = typeConfig.factorycomponent();
        AbstractConcreteDocumentFactory cdf = (AbstractConcreteDocumentFactory)((Object)this.docFactoryRegistry.getComponent(new ComponentId(componentId)));
        if (cdf == null) {
            log.fine(() -> "Unable to get document factory component '" + componentId + "' from document factory registry.");
            return document;
        }
        try {
            return cdf.getDocumentCopy(document.getDataType().getName(), (StructuredFieldValue)document, document.getId());
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("error in document with id '" + document.getId() + "'", e);
        }
    }

    private ContainerDocumentConfig.Doctype getDocumentConfig(String name) {
        for (ContainerDocumentConfig.Doctype type : this.containerDocConfig.doctype()) {
            if (!name.equals(type.type())) continue;
            return type;
        }
        return null;
    }

    private Processing createProcessing(DocumentOperation documentOperation, Message message) {
        Processing processing = new Processing();
        processing.addDocumentOperation(documentOperation);
        processing.setServiceName(this.serviceName);
        processing.setExpiresAt(SystemTimer.INSTANCE.instant().plusMillis(message.getTimeRemainingNow()));
        processing.setVariable("route", message.getRoute());
        processing.setVariable("timeout", message.getTimeRemaining());
        return processing;
    }
}

