/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.util;

import com.yahoo.config.docproc.SplitterJoinerDocumentProcessorConfig;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.datatypes.Array;
import com.yahoo.log.LogLevel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SplitterDocumentProcessor
extends DocumentProcessor {
    private static Logger log = Logger.getLogger(SplitterDocumentProcessor.class.getName());
    private String documentTypeName;
    private String arrayFieldName;
    private String contextFieldName;
    DocumentTypeManager manager;

    public SplitterDocumentProcessor(SplitterJoinerDocumentProcessorConfig cfg, DocumentmanagerConfig documentmanagerConfig) {
        this.documentTypeName = cfg.documentTypeName();
        this.arrayFieldName = cfg.arrayFieldName();
        this.contextFieldName = cfg.contextFieldName();
        this.manager = DocumentTypeManagerConfigurer.configureNewManager((DocumentmanagerConfig)documentmanagerConfig);
        SplitterDocumentProcessor.validate(this.manager, this.documentTypeName, this.arrayFieldName);
    }

    @Override
    public DocumentProcessor.Progress process(Processing processing) {
        if (processing.getDocumentOperations().size() != 1) {
            log.log((Level)LogLevel.DEBUG, "More than one document given, returning. (Was given " + processing.getDocumentOperations().size() + " documents).");
            return DocumentProcessor.Progress.DONE;
        }
        if (!SplitterDocumentProcessor.doProcessOuterDocument(processing.getDocumentOperations().get(0), this.documentTypeName)) {
            return DocumentProcessor.Progress.DONE;
        }
        Document outerDoc = ((DocumentPut)processing.getDocumentOperations().get(0)).getDocument();
        Array innerDocuments = (Array)outerDoc.getFieldValue(this.arrayFieldName);
        if (innerDocuments == null) {
            log.log((Level)LogLevel.DEBUG, "The given Document does not have a field value for field " + this.arrayFieldName + ", returning. (Was given " + outerDoc + ").");
            return DocumentProcessor.Progress.DONE;
        }
        if (innerDocuments.size() == 0) {
            log.log((Level)LogLevel.DEBUG, "The given Document does not have any elements in array field " + this.arrayFieldName + ", returning. (Was given " + outerDoc + ").");
            return DocumentProcessor.Progress.DONE;
        }
        this.split(processing, (Array<Document>)innerDocuments);
        return DocumentProcessor.Progress.DONE;
    }

    private void split(Processing processing, Array<Document> innerDocuments) {
        processing.setVariable(this.contextFieldName, processing.getDocumentOperations().get(0));
        processing.getDocumentOperations().clear();
        processing.getDocumentOperations().addAll(innerDocuments.stream().map(DocumentPut::new).collect(Collectors.toList()));
        innerDocuments.clear();
    }

    static void validate(DocumentTypeManager manager, String documentTypeName, String arrayFieldName) {
        DocumentType docType = manager.getDocumentType(documentTypeName);
        if (docType == null) {
            throw new IllegalStateException("The document type " + documentTypeName + " is not deployed.");
        }
        if (docType.getField(arrayFieldName) == null) {
            throw new IllegalStateException("The document type " + documentTypeName + " does not have a field named " + arrayFieldName + ".");
        }
        if (!(docType.getField(arrayFieldName).getDataType() instanceof ArrayDataType)) {
            throw new IllegalStateException("The data type of the field named " + arrayFieldName + " in document type " + documentTypeName + " is not an array type");
        }
        ArrayDataType fieldDataType = (ArrayDataType)docType.getField(arrayFieldName).getDataType();
        if (!(fieldDataType.getNestedType() instanceof DocumentType)) {
            throw new IllegalStateException("The data type of the field named " + arrayFieldName + " in document type " + documentTypeName + " is not an array of Document.");
        }
    }

    static boolean doProcessOuterDocument(Object o, String documentTypeName) {
        if (!(o instanceof DocumentOperation)) {
            if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, o + " is not a DocumentOperation.");
            }
            return false;
        }
        DocumentOperation outerDocOp = (DocumentOperation)o;
        if (!(outerDocOp instanceof DocumentPut)) {
            if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, "Given DocumentOperation is not a DocumentPut, returning. (Was given " + outerDocOp + ").");
            }
            return false;
        }
        Document outerDoc = ((DocumentPut)outerDocOp).getDocument();
        DocumentType type = outerDoc.getDataType();
        if (!type.getName().equalsIgnoreCase(documentTypeName)) {
            if (log.isLoggable((Level)LogLevel.DEBUG)) {
                log.log((Level)LogLevel.DEBUG, "Given Document is of wrong type, returning. (Was given " + outerDoc + ").");
            }
            return false;
        }
        return true;
    }
}

