/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc;

import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.docproc.Call;
import com.yahoo.docproc.CallStack;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.ProcessingEndpoint;
import com.yahoo.document.DocumentOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Processing {
    private String service = null;
    private CallStack callStack = null;
    private final List<DocumentOperation> documentOperations;
    private List<DocumentOperation> documentsToAdd = null;
    private Map<String, Object> context = null;
    private ProcessingEndpoint endpoint = null;
    private ComponentRegistry<DocprocService> docprocServiceRegistry = null;
    private boolean operationsGotten = false;

    public Processing() {
        this.documentOperations = new ArrayList<DocumentOperation>(1);
    }

    public static Processing of(DocumentOperation documentOperation) {
        return new Processing(documentOperation);
    }

    private Processing(DocumentOperation documentOperation) {
        this();
        this.addDocumentOperation(documentOperation);
    }

    Processing(String service, DocumentOperation documentOperation, CallStack callStack, ProcessingEndpoint endp) {
        this.service = service;
        this.documentOperations = new ArrayList<DocumentOperation>(1);
        this.documentOperations.add(documentOperation);
        this.callStack = callStack;
        this.endpoint = endp;
    }

    public Processing(String service, DocumentOperation documentOperation, CallStack callStack) {
        this(service, documentOperation, callStack, null);
    }

    private Processing(String service, List<DocumentOperation> documentOpsAndUpdates, CallStack callStack, ProcessingEndpoint endp, boolean unused) {
        this.service = service;
        this.documentOperations = new ArrayList<DocumentOperation>(documentOpsAndUpdates.size());
        this.documentOperations.addAll(documentOpsAndUpdates);
        this.callStack = callStack;
        this.endpoint = endp;
    }

    static Processing createProcessingFromDocumentOperations(String service, List<DocumentOperation> documentOpsAndUpdates, CallStack callStack, ProcessingEndpoint endp) {
        return new Processing(service, documentOpsAndUpdates, callStack, endp, false);
    }

    public static Processing createProcessingFromDocumentOperations(String service, List<DocumentOperation> documentsAndUpdates, CallStack callStack) {
        return new Processing(service, documentsAndUpdates, callStack, null, false);
    }

    @Deprecated(forRemoval=true, since="7")
    public ComponentRegistry<DocprocService> getDocprocServiceRegistry() {
        return this.docprocServiceRegistry;
    }

    @Deprecated(forRemoval=true, since="7")
    public void setDocprocServiceRegistry(ComponentRegistry<DocprocService> docprocServiceRegistry) {
        this.docprocServiceRegistry = docprocServiceRegistry;
    }

    public String getServiceName() {
        if (this.service == null) {
            return "default";
        }
        return this.service;
    }

    public void setServiceName(String service) {
        this.service = service;
    }

    @Deprecated(forRemoval=true, since="7")
    public DocprocService getService() {
        if (this.docprocServiceRegistry != null) {
            return (DocprocService)((Object)this.docprocServiceRegistry.getComponent(this.getServiceName()));
        }
        return null;
    }

    public Object getVariable(String name) {
        if (this.context == null) {
            return null;
        }
        return this.context.get(name);
    }

    public Iterator<Map.Entry<String, Object>> getVariableAndNameIterator() {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        return this.context.entrySet().iterator();
    }

    public void clearVariables() {
        if (this.context == null) {
            return;
        }
        this.context.clear();
    }

    public void setVariable(String name, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.context.put(name, value);
    }

    public Object removeVariable(String name) {
        if (this.context == null) {
            return null;
        }
        return this.context.remove(name);
    }

    public boolean hasVariable(String name) {
        return this.context != null && this.context.containsKey(name);
    }

    ProcessingEndpoint getEndpoint() {
        return this.endpoint;
    }

    void setEndpoint(ProcessingEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void addDocumentOperation(DocumentOperation documentOperation) {
        if (this.documentsToAdd == null) {
            this.documentsToAdd = new ArrayList<DocumentOperation>(1);
        }
        this.documentsToAdd.add(documentOperation);
    }

    private void updateDocumentOperations() {
        if (this.documentsToAdd != null) {
            this.documentOperations.addAll(this.documentsToAdd);
            this.documentsToAdd.clear();
        }
    }

    public List<DocumentOperation> getDocumentOperations() {
        this.updateDocumentOperations();
        return this.documentOperations;
    }

    public CallStack callStack() {
        return this.callStack;
    }

    void setCallStack(CallStack callStack) {
        this.callStack = callStack;
    }

    List<DocumentOperation> getOnceOperationsToBeProcessed() {
        if (this.operationsGotten) {
            return Collections.emptyList();
        }
        this.operationsGotten = true;
        return this.getDocumentOperations();
    }

    public String toString() {
        Call call;
        Object previousCall = "";
        if (this.callStack != null && (call = this.callStack.getLastPopped()) != null) {
            previousCall = "Last call: " + call;
        }
        if (this.documentOperations.size() == 1) {
            return "Processing of " + this.documentOperations.get(0) + ". " + (String)previousCall;
        }
        Object listString = this.documentOperations.toString();
        if (((String)listString).length() > 100) {
            listString = ((String)listString).substring(0, 99);
            listString = (String)listString + "...]";
        }
        return "Processing of " + (String)listString + ". " + (String)previousCall;
    }
}

