/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc.messagebus;

import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.container.core.document.ContainerDocumentConfig;
import com.yahoo.docproc.AbstractConcreteDocumentFactory;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.HandledProcessingException;
import com.yahoo.docproc.Processing;
import com.yahoo.docproc.TransientFailureException;
import com.yahoo.docproc.jdisc.RequestContext;
import com.yahoo.docproc.jdisc.messagebus.MessageFactory;
import com.yahoo.docproc.jdisc.messagebus.ProcessingFactory;
import com.yahoo.docproc.jdisc.messagebus.ResponseMerger;
import com.yahoo.document.DocumentOperation;
import com.yahoo.documentapi.messagebus.protocol.DocumentMessage;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.RequestDispatch;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.jdisc.MbusRequest;
import com.yahoo.messagebus.jdisc.MbusResponse;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MbusRequestContext
implements RequestContext,
ResponseHandler {
    private static final Logger log = Logger.getLogger(MbusRequestContext.class.getName());
    private static final CopyOnWriteHashMap<String, URI> uriCache = new CopyOnWriteHashMap();
    private final AtomicBoolean deserialized = new AtomicBoolean(false);
    private final AtomicBoolean responded = new AtomicBoolean(false);
    private final ProcessingFactory processingFactory;
    private final MessageFactory messageFactory;
    private final MbusRequest request;
    private final DocumentMessage requestMsg;
    private final ResponseHandler responseHandler;
    public static final String internalNoThrottledSource = "internalNoThrottledSource";
    private static final String internalNoThrottledSourcePath = "/internalNoThrottledSource";

    public MbusRequestContext(MbusRequest request, ResponseHandler responseHandler, ComponentRegistry<DocprocService> docprocServiceComponentRegistry, ComponentRegistry<AbstractConcreteDocumentFactory> docFactoryRegistry, ContainerDocumentConfig containerDocConfig) {
        this.request = request;
        this.requestMsg = (DocumentMessage)request.getMessage();
        this.responseHandler = responseHandler;
        this.processingFactory = new ProcessingFactory(docprocServiceComponentRegistry, docFactoryRegistry, containerDocConfig, this.getServiceName());
        this.messageFactory = MbusRequestContext.newMessageFactory(this.requestMsg);
    }

    @Override
    public List<Processing> getProcessings() {
        if (this.deserialized.getAndSet(true)) {
            return Collections.emptyList();
        }
        return this.processingFactory.fromMessage((Message)this.requestMsg);
    }

    @Override
    public void skip() {
        if (this.deserialized.get()) {
            throw new IllegalStateException("Can not skip processing after deserialization");
        }
        this.dispatchRequest((Message)this.requestMsg, this.getUri().getPath(), this.responseHandler);
    }

    @Override
    public void processingDone(List<Processing> processings) {
        ArrayList<DocumentMessage> messages = new ArrayList<DocumentMessage>();
        if (this.messageFactory != null) {
            for (Processing processing : processings) {
                for (DocumentOperation documentOperation : processing.getDocumentOperations()) {
                    messages.add(this.messageFactory.fromDocumentOperation(processing, documentOperation));
                }
            }
        }
        log.log(Level.FINE, () -> "Forwarding " + messages.size() + " messages from " + processings.size() + " processings.");
        if (messages.isEmpty()) {
            this.dispatchResponse(200);
            return;
        }
        long inputSequenceId = this.requestMsg.getSequenceId();
        ResponseMerger responseHandler = new ResponseMerger((Message)this.requestMsg, messages.size(), this);
        int numMsgWithOriginalSequenceId = 0;
        for (Message message : messages) {
            if (message.getSequenceId() != inputSequenceId) continue;
            ++numMsgWithOriginalSequenceId;
        }
        for (Message message : messages) {
            String path = internalNoThrottledSourcePath;
            if (numMsgWithOriginalSequenceId == 1 && message.getSequenceId() == inputSequenceId) {
                path = this.getUri().getPath();
            }
            this.dispatchRequest(message, path, responseHandler);
        }
    }

    @Override
    public void processingFailed(Exception exception) {
        RequestContext.ErrorCode errorCode = exception instanceof TransientFailureException ? RequestContext.ErrorCode.ERROR_ABORTED : RequestContext.ErrorCode.ERROR_PROCESSING_FAILURE;
        StringBuilder errorMsg = new StringBuilder("Processing failed.");
        if (exception instanceof HandledProcessingException) {
            errorMsg.append(" Error message: ").append(exception.getMessage());
        } else if (exception != null) {
            errorMsg.append(" Error message: ").append(exception.toString());
        }
        errorMsg.append(" -- See Vespa log for details.");
        this.processingFailed(errorCode, errorMsg.toString());
    }

    @Override
    public void processingFailed(RequestContext.ErrorCode errorCode, String errorMsg) {
        MbusResponse response = new MbusResponse(errorCode.getDiscStatus(), (Reply)this.requestMsg.createReply());
        response.getReply().addError(new Error(errorCode.getDocumentProtocolStatus(), errorMsg));
        ResponseDispatch.newInstance((Response)response, (ByteBuffer[])new ByteBuffer[0]).dispatch((ResponseHandler)this);
    }

    @Override
    public URI getUri() {
        return this.request.getUri();
    }

    @Override
    public String getServiceName() {
        String path = this.getUri().getPath();
        return path.substring(7, path.length());
    }

    @Override
    public boolean isProcessable() {
        DocumentMessage msg = this.requestMsg;
        switch (msg.getType()) {
            case 100004: 
            case 100005: 
            case 100006: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasExpired() {
        return this.requestMsg.isExpired();
    }

    public ContentChannel handleResponse(Response response) {
        if (this.responded.getAndSet(true)) {
            return null;
        }
        Reply reply = ((MbusResponse)response).getReply();
        reply.swapState((Routable)this.requestMsg);
        return this.responseHandler.handleResponse(response);
    }

    private void dispatchResponse(int status) {
        ResponseDispatch.newInstance((Response)new MbusResponse(status, (Reply)this.requestMsg.createReply()), (ByteBuffer[])new ByteBuffer[0]).dispatch((ResponseHandler)this);
    }

    private void dispatchRequest(final Message msg, final String uriPath, final ResponseHandler handler) {
        try {
            new RequestDispatch(){

                protected Request newRequest() {
                    return new MbusRequest((Request)MbusRequestContext.this.request, (URI)uriCache.computeIfAbsent((Object)uriPath, __ -> URI.create("mbus://remotehost" + uriPath)), msg);
                }

                public ContentChannel handleResponse(Response response) {
                    return handler.handleResponse(response);
                }
            }.dispatch();
        }
        catch (Exception e) {
            this.dispatchResponse(500);
            e.printStackTrace();
        }
    }

    private static MessageFactory newMessageFactory(DocumentMessage message) {
        if (message == null) {
            return null;
        }
        if (message.getRoute() == null || !message.getRoute().hasHops()) {
            return null;
        }
        return new MessageFactory(message);
    }
}

