/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.util;

import com.yahoo.config.docproc.SplitterJoinerDocumentProcessorConfig;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.docproc.util.SplitterDocumentProcessor;
import com.yahoo.document.DocumentOperation;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.DocumentTypeManagerConfigurer;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JoinerDocumentProcessor
extends DocumentProcessor {
    private static Logger log = Logger.getLogger(JoinerDocumentProcessor.class.getName());
    private String documentTypeName;
    private String arrayFieldName;
    private String contextFieldName;
    private DocumentTypeManager manager;

    public JoinerDocumentProcessor(SplitterJoinerDocumentProcessorConfig cfg, DocumentmanagerConfig documentmanagerConfig) {
        this.documentTypeName = cfg.documentTypeName();
        this.arrayFieldName = cfg.arrayFieldName();
        this.contextFieldName = cfg.contextFieldName();
        this.manager = DocumentTypeManagerConfigurer.configureNewManager((DocumentmanagerConfig)documentmanagerConfig);
        SplitterDocumentProcessor.validate(this.manager, this.documentTypeName, this.arrayFieldName);
    }

    @Override
    public DocumentProcessor.Progress process(Processing processing) {
        if (!SplitterDocumentProcessor.doProcessOuterDocument(processing.getVariable(this.contextFieldName), this.documentTypeName)) {
            return DocumentProcessor.Progress.DONE;
        }
        DocumentPut outerDoc = (DocumentPut)processing.getVariable(this.contextFieldName);
        Array innerDocuments = (Array)outerDoc.getDocument().getFieldValue(this.arrayFieldName);
        if (innerDocuments == null) {
            Array empty;
            innerDocuments = empty = (Array)outerDoc.getDocument().getDataType().getField(this.arrayFieldName).getDataType().createFieldValue();
        }
        for (DocumentOperation op : processing.getDocumentOperations()) {
            if (op instanceof DocumentPut) {
                innerDocuments.add((FieldValue)((DocumentPut)op).getDocument());
                continue;
            }
            log.log(Level.FINE, "Skipping: " + op);
        }
        processing.getDocumentOperations().clear();
        processing.getDocumentOperations().add((DocumentOperation)outerDoc);
        processing.removeVariable(this.contextFieldName);
        return DocumentProcessor.Progress.DONE;
    }
}

