/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc;

import com.google.inject.Inject;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainsConfigurer;
import com.yahoo.component.chain.model.ChainsModel;
import com.yahoo.component.chain.model.ChainsModelBuilder;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.docproc.DocprocConfig;
import com.yahoo.config.docproc.SchemamappingConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.container.core.document.ContainerDocumentConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.docproc.AbstractConcreteDocumentFactory;
import com.yahoo.docproc.CallStack;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.jdisc.DocprocThreadManager;
import com.yahoo.docproc.jdisc.DocprocThreadPoolExecutor;
import com.yahoo.docproc.jdisc.DocumentProcessingHandlerParameters;
import com.yahoo.docproc.jdisc.DocumentProcessingTask;
import com.yahoo.docproc.jdisc.RequestContext;
import com.yahoo.docproc.jdisc.messagebus.MbusRequestContext;
import com.yahoo.docproc.proxy.SchemaMap;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.documentapi.ThroughputLimitQueue;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.jdisc.MbusRequest;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.statistics.Statistics;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentProcessingHandler
extends AbstractRequestHandler {
    private static Logger log = Logger.getLogger(DocumentProcessingHandler.class.getName());
    private final ComponentRegistry<DocprocService> docprocServiceRegistry;
    private final ComponentRegistry<AbstractConcreteDocumentFactory> docFactoryRegistry;
    private final ChainRegistry<DocumentProcessor> chainRegistry = new ChainRegistry();
    private DocprocThreadPoolExecutor threadPool;
    private final ScheduledThreadPoolExecutor laterExecutor = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DaemonThreadFactory("docproc-later-"));
    private ContainerDocumentConfig containerDocConfig;
    private final DocumentTypeManager documentTypeManager;

    public DocumentProcessingHandler(ComponentRegistry<DocprocService> docprocServiceRegistry, ComponentRegistry<DocumentProcessor> documentProcessorComponentRegistry, ComponentRegistry<AbstractConcreteDocumentFactory> docFactoryRegistry, DocprocThreadPoolExecutor threadPool, DocumentTypeManager documentTypeManager, ChainsModel chainsModel, SchemaMap schemaMap, Statistics statistics, Metric metric, ContainerDocumentConfig containerDocConfig) {
        this.docprocServiceRegistry = docprocServiceRegistry;
        this.docFactoryRegistry = docFactoryRegistry;
        this.threadPool = threadPool;
        this.containerDocConfig = containerDocConfig;
        this.documentTypeManager = documentTypeManager;
        DocprocService.schemaMap = schemaMap;
        threadPool.prestartCoreThread();
        this.laterExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.laterExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        if (chainsModel != null) {
            ChainsConfigurer.prepareChainRegistry(this.chainRegistry, (ChainsModel)chainsModel, documentProcessorComponentRegistry);
            for (Chain chain : this.chainRegistry.allComponents()) {
                log.config("Setting up call stack for chain " + chain.getId());
                DocprocService service = new DocprocService(chain.getId(), DocumentProcessingHandler.convertToCallStack((Chain<DocumentProcessor>)chain, statistics, metric), documentTypeManager);
                service.setInService(true);
                docprocServiceRegistry.register(service.getId(), (Object)service);
            }
        }
    }

    public DocumentProcessingHandler(ComponentRegistry<DocprocService> docprocServiceRegistry, ComponentRegistry<DocumentProcessor> documentProcessorComponentRegistry, ComponentRegistry<AbstractConcreteDocumentFactory> docFactoryRegistry, DocumentProcessingHandlerParameters params) {
        this(docprocServiceRegistry, documentProcessorComponentRegistry, docFactoryRegistry, new DocprocThreadPoolExecutor(params.getMaxNumThreads(), (BlockingQueue<Runnable>)(params.getMaxQueueTimeMs() > 0L ? new ThroughputLimitQueue(params.getMaxQueueTimeMs()) : (params.getMaxQueueTimeMs() < 0L ? new LinkedBlockingQueue() : new PriorityBlockingQueue())), new DocprocThreadManager(params.getMaxConcurrentFactor(), params.getDocumentExpansionFactor(), params.getContainerCoreMemoryMb(), params.getStatisticsManager(), params.getMetric())), params.getDocumentTypeManager(), params.getChainsModel(), params.getSchemaMap(), params.getStatisticsManager(), params.getMetric(), params.getContainerDocConfig());
    }

    @Inject
    public DocumentProcessingHandler(ComponentRegistry<DocumentProcessor> documentProcessorComponentRegistry, ComponentRegistry<AbstractConcreteDocumentFactory> docFactoryRegistry, ChainsConfig chainsConfig, SchemamappingConfig mappingConfig, DocumentmanagerConfig docManConfig, DocprocConfig docprocConfig, ContainerMbusConfig containerMbusConfig, ContainerDocumentConfig containerDocConfig, Statistics manager, Metric metric) {
        this((ComponentRegistry<DocprocService>)new ComponentRegistry(), documentProcessorComponentRegistry, docFactoryRegistry, new DocumentProcessingHandlerParameters().setMaxNumThreads(docprocConfig.numthreads()).setMaxConcurrentFactor(containerMbusConfig.maxConcurrentFactor()).setDocumentExpansionFactor(containerMbusConfig.documentExpansionFactor()).setContainerCoreMemoryMb(containerMbusConfig.containerCoreMemory()).setMaxQueueTimeMs(docprocConfig.maxqueuetimems()).setDocumentTypeManager(new DocumentTypeManager(docManConfig)).setChainsModel(ChainsModelBuilder.buildFromConfig((ChainsConfig)chainsConfig)).setSchemaMap(DocumentProcessingHandler.configureMapping(mappingConfig)).setStatisticsManager(manager).setMetric(metric).setContainerDocumentConfig(containerDocConfig));
    }

    protected void destroy() {
        this.threadPool.shutdown();
    }

    public ComponentRegistry<DocprocService> getDocprocServiceRegistry() {
        return this.docprocServiceRegistry;
    }

    public ChainRegistry<DocumentProcessor> getChains() {
        return this.chainRegistry;
    }

    private static SchemaMap configureMapping(SchemamappingConfig mappingConfig) {
        SchemaMap map = new SchemaMap();
        map.configure(mappingConfig);
        return map;
    }

    private static CallStack convertToCallStack(Chain<DocumentProcessor> chain, Statistics statistics, Metric metric) {
        CallStack stack = new CallStack(chain.getId().stringValue(), statistics, metric);
        for (DocumentProcessor processor : chain.components()) {
            processor.getFieldMap().putAll(DocprocService.schemaMap.chainMap(chain.getId().stringValue(), processor.getId().stringValue()));
            stack.addLast(processor);
        }
        return stack;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        if (!(request instanceof MbusRequest)) {
            throw new IllegalArgumentException("Request type not supported: " + request);
        }
        MbusRequestContext requestContext = new MbusRequestContext((MbusRequest)request, handler, this.docprocServiceRegistry, this.docFactoryRegistry, this.containerDocConfig);
        if (!requestContext.isProcessable()) {
            requestContext.skip();
            return null;
        }
        DocprocService service = (DocprocService)((Object)this.docprocServiceRegistry.getComponent(requestContext.getServiceName()));
        if (service == null) {
            log.log((Level)LogLevel.ERROR, "DocprocService for session '" + requestContext.getServiceName() + "' not found, returning request '" + requestContext + "'.");
            requestContext.processingFailed(RequestContext.ErrorCode.ERROR_PROCESSING_FAILURE, "DocprocService " + requestContext.getServiceName() + " not found.");
            return null;
        }
        if (service.getExecutor().getCallStack().size() == 0) {
            requestContext.skip();
            return null;
        }
        DocumentProcessingTask task = new DocumentProcessingTask(requestContext, this, service);
        this.submit(task);
        return null;
    }

    void submit(DocumentProcessingTask task) {
        if (this.threadPool.isAboveLimit()) {
            task.queueFull();
        } else {
            try {
                this.threadPool.execute(task);
            }
            catch (RejectedExecutionException ree) {
                task.queueFull();
            }
        }
    }

    void submit(DocumentProcessingTask task, long delay) {
        LaterTimerTask timerTask = new LaterTimerTask(task, delay);
        this.laterExecutor.schedule(timerTask, delay, TimeUnit.MILLISECONDS);
    }

    public DocumentTypeManager getDocumentTypeManager() {
        return this.documentTypeManager;
    }

    private class LaterTimerTask
    extends TimerTask {
        private DocumentProcessingTask processingTask;
        private long delay;

        private LaterTimerTask(DocumentProcessingTask processingTask, long delay) {
            this.delay = delay;
            log.log((Level)LogLevel.DEBUG, "Enqueueing in " + delay + " ms due to Progress.LATER: " + processingTask);
            this.processingTask = processingTask;
        }

        @Override
        public void run() {
            log.log((Level)LogLevel.DEBUG, "Submitting after having waited " + this.delay + " ms in LATER queue: " + this.processingTask);
            DocumentProcessingHandler.this.submit(this.processingTask);
        }
    }
}

