/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc;

import com.yahoo.docproc.jdisc.DocumentProcessingTask;
import com.yahoo.docproc.jdisc.metric.NullMetric;
import com.yahoo.document.DocumentUtil;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogLevel;
import com.yahoo.statistics.Statistics;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

class DocprocThreadManager {
    private static Logger log = Logger.getLogger(DocprocThreadManager.class.getName());
    private final long maxConcurrentByteSize;
    private final AtomicLong bytesStarted = new AtomicLong(0L);
    private final AtomicLong bytesFinished = new AtomicLong(0L);

    DocprocThreadManager(double maxConcurrentFactor, double documentExpansionFactor, int containerCoreMemoryMb) {
        this(maxConcurrentFactor, documentExpansionFactor, containerCoreMemoryMb, Statistics.nullImplementation, new NullMetric());
    }

    DocprocThreadManager(double maxConcurrentFactor, double documentExpansionFactor, int containerCoreMemoryMb, Statistics statistics, Metric metric) {
        this((long)((double)DocumentUtil.calculateMaxPendingSize((double)maxConcurrentFactor, (double)documentExpansionFactor, (int)containerCoreMemoryMb) * maxConcurrentFactor));
    }

    DocprocThreadManager(long maxConcurrentByteSize) {
        int MINCONCURRENTBYTES = 0x10000000;
        if (maxConcurrentByteSize < 0x10000000L) {
            maxConcurrentByteSize = 0x10000000L;
        }
        this.maxConcurrentByteSize = maxConcurrentByteSize;
        log.log(LogLevel.CONFIG, "Docproc service allowed to concurrently process " + (double)maxConcurrentByteSize / 1024.0 / 1024.0 + " megabytes of input data.");
    }

    boolean isAboveLimit() {
        return this.bytesFinished.get() - this.bytesStarted.get() > this.maxConcurrentByteSize;
    }

    void beforeExecute(DocumentProcessingTask task) {
        this.bytesStarted.getAndAdd(task.getApproxSize());
    }

    void afterExecute(DocumentProcessingTask task) {
        this.bytesFinished.getAndAdd(task.getApproxSize());
    }

    void shutdown() {
    }
}

