/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.docproc.jdisc;

import com.yahoo.collections.Tuple2;
import com.yahoo.docproc.Call;
import com.yahoo.docproc.CallStack;
import com.yahoo.docproc.DocprocExecutor;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.HandledProcessingException;
import com.yahoo.docproc.Processing;
import com.yahoo.docproc.jdisc.DocumentProcessingHandler;
import com.yahoo.docproc.jdisc.RequestContext;
import com.yahoo.log.LogLevel;
import com.yahoo.yolean.Exceptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocumentProcessingTask
implements Comparable<DocumentProcessingTask>,
Runnable {
    private static Logger log = Logger.getLogger(DocumentProcessingTask.class.getName());
    private final List<Processing> processings = new ArrayList<Processing>();
    private final List<Processing> processingsDone = new ArrayList<Processing>();
    private final DocumentProcessingHandler docprocHandler;
    private RequestContext requestContext;
    private int waitCounter;
    private static final AtomicLong seq = new AtomicLong();
    private final long seqNum = seq.getAndIncrement();
    private final DocprocService service;

    public DocumentProcessingTask(RequestContext requestContext, DocumentProcessingHandler docprocHandler, DocprocService service) {
        this.requestContext = requestContext;
        this.docprocHandler = docprocHandler;
        this.waitCounter = 10;
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                this.processings.addAll(this.requestContext.getProcessings());
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Deserialization of message failed.", e);
                this.requestContext.processingFailed(e);
                return;
            }
            DocprocExecutor executor = this.service.getExecutor();
            DocumentProcessor.Progress progress = this.process(executor);
            if (DocumentProcessor.Progress.LATER.equals(progress) && !this.processings.isEmpty()) {
                DocumentProcessor.LaterProgress laterProgress = (DocumentProcessor.LaterProgress)progress;
                this.docprocHandler.submit(this, laterProgress.getDelay());
            }
        }
        catch (Error error) {
            try {
                log.log((Level)LogLevel.FATAL, Exceptions.toMessageString((Throwable)error), error);
            }
            catch (Throwable throwable) {
            }
            finally {
                Runtime.getRuntime().halt(1);
            }
        }
    }

    boolean doWait() {
        --this.waitCounter;
        return this.waitCounter > 0;
    }

    private DocumentProcessor.Progress process(DocprocExecutor executor) {
        Iterator<Processing> iterator = this.processings.iterator();
        ArrayList<Tuple2> later = new ArrayList<Tuple2>();
        while (iterator.hasNext()) {
            DocumentProcessor.Progress progress;
            Processing processing = iterator.next();
            iterator.remove();
            if (this.requestContext.hasExpired()) {
                Call lastPopped;
                CallStack callStack;
                progress = DocumentProcessor.Progress.FAILED;
                String location = processing != null ? ((callStack = processing.callStack()) != null ? ((lastPopped = callStack.getLastPopped()) != null ? lastPopped.toString() : "empty call stack or no processors popped") : "no call stack") : "no processing instance";
                String errorMsg = processing + " failed, " + location;
                log.log(Level.FINE, "Time is up for '" + errorMsg + "'.");
                this.requestContext.processingFailed(RequestContext.ErrorCode.ERROR_PROCESSING_FAILURE, "Time is up.");
                return progress;
            }
            progress = DocumentProcessor.Progress.FAILED;
            try {
                progress = executor.process(processing);
            }
            catch (Exception e) {
                DocumentProcessingTask.logProcessingFailure(processing, e);
                this.requestContext.processingFailed(e);
                return progress;
            }
            if (DocumentProcessor.Progress.LATER.equals(progress)) {
                later.add(new Tuple2((Object)progress, (Object)processing));
                continue;
            }
            if (DocumentProcessor.Progress.DONE.equals(progress)) {
                this.processingsDone.add(processing);
                continue;
            }
            if (DocumentProcessor.Progress.FAILED.equals(progress)) {
                DocumentProcessingTask.logProcessingFailure(processing, null);
                this.requestContext.processingFailed(RequestContext.ErrorCode.ERROR_PROCESSING_FAILURE, progress.getReason().orElse("Document processing failed."));
                return progress;
            }
            if (!DocumentProcessor.Progress.PERMANENT_FAILURE.equals(progress)) continue;
            DocumentProcessingTask.logProcessingFailure(processing, null);
            this.requestContext.processingFailed(RequestContext.ErrorCode.ERROR_PROCESSING_FAILURE, progress.getReason().orElse("Document processing failed."));
            return progress;
        }
        if (!later.isEmpty()) {
            DocumentProcessor.LaterProgress shortestDelay = (DocumentProcessor.LaterProgress)((Tuple2)later.get((int)0)).first;
            for (Tuple2 tuple : later) {
                this.processings.add((Processing)tuple.second);
                if (((DocumentProcessor.LaterProgress)tuple.first).getDelay() >= shortestDelay.getDelay()) continue;
                shortestDelay = (DocumentProcessor.LaterProgress)tuple.first;
            }
            return shortestDelay;
        }
        this.requestContext.processingDone(this.processingsDone);
        return DocumentProcessor.Progress.DONE;
    }

    void queueFull() {
        this.requestContext.processingFailed(RequestContext.ErrorCode.ERROR_BUSY, "Queue temporarily full. Returning message " + this.requestContext + ". Will be automatically resent.");
    }

    @Override
    public int compareTo(DocumentProcessingTask other) {
        int res;
        int otherPriority;
        int ourPriority = this.requestContext.getPriority();
        int n = ourPriority == (otherPriority = other.requestContext.getPriority()) ? 0 : (res = ourPriority < otherPriority ? -1 : 1);
        if (res == 0) {
            res = this.seqNum == other.seqNum ? 0 : (this.seqNum < other.seqNum ? -1 : 1);
        }
        return res;
    }

    public String toString() {
        return "ProcessingTask{processings=" + this.processings + ", processingsDone=" + this.processingsDone + ", requestContext=" + this.requestContext + ", seqNum=" + this.seqNum + '}';
    }

    public int getApproxSize() {
        return this.requestContext.getApproxSize();
    }

    final long getSeqNum() {
        return this.seqNum;
    }

    private static void logProcessingFailure(Processing processing, Exception exception) {
        String errorMsg = processing + " failed at " + processing.callStack().getLastPopped();
        if (exception != null) {
            if (exception instanceof HandledProcessingException) {
                errorMsg = errorMsg + ". Error message: " + exception.getMessage();
                log.log(Level.WARNING, errorMsg);
                log.log(Level.FINE, "Chained exception:", exception);
            } else {
                log.log(Level.WARNING, errorMsg, exception);
            }
        } else {
            log.log(Level.WARNING, errorMsg);
        }
        if (exception != null) {
            StringWriter backtrace = new StringWriter();
            exception.printStackTrace(new PrintWriter(backtrace));
            log.log((Level)LogLevel.DEBUG, "Failed to process " + processing + ": " + backtrace.toString());
        }
    }
}

