/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime.providers;

import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtProviderOptions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class StringConfigProviderOptions
extends OrtProviderOptions {
    protected final Map<String, String> options = new LinkedHashMap<String, String>();

    protected StringConfigProviderOptions(long nativeHandle) {
        super(nativeHandle);
    }

    public void add(String key, String value) throws OrtException {
        this.checkClosed();
        Objects.requireNonNull(key, "Key must not be null");
        Objects.requireNonNull(value, "Value must not be null");
        this.options.put(key, value);
        this.add(StringConfigProviderOptions.getApiHandle(), this.nativeHandle, key, value);
    }

    public void parseOptionsString(String serializedForm) throws OrtException {
        String[] options;
        for (String o : options = serializedForm.split(";")) {
            if (o.isEmpty() || !o.contains("=")) continue;
            String[] curOption = o.split("=");
            if (curOption.length == 2 && !curOption[0].isEmpty() && !curOption[1].isEmpty()) {
                this.add(curOption[0], curOption[1]);
                continue;
            }
            throw new IllegalArgumentException("Failed to parse option from string '" + o + "'");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getOptionsString() + ")";
    }

    public String getOptionsString() {
        return this.options.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";", "", ";"));
    }

    protected abstract void add(long var1, long var3, String var5, String var6) throws OrtException;
}

