/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtUtil;
import ai.onnxruntime.SequenceInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OnnxSequence
implements OnnxValue {
    final long nativeHandle;
    private final long allocatorHandle;
    private final SequenceInfo info;

    OnnxSequence(long nativeHandle, long allocatorHandle, SequenceInfo info) {
        this.nativeHandle = nativeHandle;
        this.allocatorHandle = allocatorHandle;
        this.info = info;
    }

    @Override
    public OnnxValue.OnnxValueType getType() {
        return OnnxValue.OnnxValueType.ONNX_TYPE_SEQUENCE;
    }

    @Override
    public List<Object> getValue() throws OrtException {
        if (this.info.sequenceOfMaps) {
            ArrayList<Object> outputSequence = new ArrayList<Object>(this.info.length);
            for (int i = 0; i < this.info.length; ++i) {
                Object[] keys = this.getMapKeys(i);
                Object[] values = this.getMapValues(i);
                HashMap<Object, Object> map = new HashMap<Object, Object>(OrtUtil.capacityFromSize(keys.length));
                for (int j = 0; j < keys.length; ++j) {
                    map.put(keys[j], values[j]);
                }
                outputSequence.add(map);
            }
            return outputSequence;
        }
        switch (this.info.sequenceType) {
            case FLOAT: {
                float[] floats = this.getFloats(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                ArrayList<Object> boxed = new ArrayList<Object>(floats.length);
                for (float aFloat : floats) {
                    boxed.add(Float.valueOf(aFloat));
                }
                return boxed;
            }
            case DOUBLE: {
                return Arrays.stream(this.getDoubles(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle)).boxed().collect(Collectors.toList());
            }
            case INT64: {
                return Arrays.stream(this.getLongs(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle)).boxed().collect(Collectors.toList());
            }
            case STRING: {
                String[] strings = this.getStrings(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                ArrayList<Object> list = new ArrayList<Object>(strings.length);
                list.addAll(Arrays.asList(strings));
                return list;
            }
        }
        throw new OrtException("Unsupported type in a sequence, found " + (Object)((Object)this.info.sequenceType));
    }

    @Override
    public SequenceInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "OnnxSequence(info=" + this.info.toString() + ")";
    }

    @Override
    public void close() {
        this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    private Object[] getMapKeys(int index) throws OrtException {
        if (this.info.mapInfo.keyType == OnnxJavaType.STRING) {
            return this.getStringKeys(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, index);
        }
        return Arrays.stream(this.getLongKeys(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, index)).boxed().toArray();
    }

    private Object[] getMapValues(int index) throws OrtException {
        switch (this.info.mapInfo.valueType) {
            case STRING: {
                return this.getStringValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, index);
            }
            case INT64: {
                return Arrays.stream(this.getLongValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, index)).boxed().toArray();
            }
            case FLOAT: {
                float[] floats = this.getFloatValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, index);
                Object[] boxed = new Float[floats.length];
                for (int i = 0; i < floats.length; ++i) {
                    boxed[i] = Float.valueOf(floats[i]);
                }
                return boxed;
            }
            case DOUBLE: {
                return Arrays.stream(this.getDoubleValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, index)).boxed().toArray();
            }
        }
        throw new RuntimeException("Invalid or unknown valueType: " + (Object)((Object)this.info.mapInfo.valueType));
    }

    private native String[] getStringKeys(long var1, long var3, long var5, int var7) throws OrtException;

    private native long[] getLongKeys(long var1, long var3, long var5, int var7) throws OrtException;

    private native String[] getStringValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native long[] getLongValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native float[] getFloatValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native double[] getDoubleValues(long var1, long var3, long var5, int var7) throws OrtException;

    private native String[] getStrings(long var1, long var3, long var5) throws OrtException;

    private native long[] getLongs(long var1, long var3, long var5) throws OrtException;

    private native float[] getFloats(long var1, long var3, long var5) throws OrtException;

    private native double[] getDoubles(long var1, long var3, long var5) throws OrtException;

    private native void close(long var1, long var3);

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }
}

