/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.messagebus;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.messagebus.NetworkMultiplexerHolder;
import com.yahoo.messagebus.network.Identity;
import com.yahoo.messagebus.network.NetworkMultiplexer;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import java.util.function.Supplier;

public class NetworkMultiplexerProvider {
    private final Object monitor = new Object();
    private final Supplier<NetworkMultiplexer> nets = () -> net.get(NetworkMultiplexerProvider.asParameters(mbusConfig, identity));
    private NetworkMultiplexer net;

    @Inject
    public NetworkMultiplexerProvider(NetworkMultiplexerHolder net, ContainerMbusConfig mbusConfig) {
        this(net, mbusConfig, System.getProperty("config.id"));
    }

    public NetworkMultiplexerProvider(NetworkMultiplexerHolder net, ContainerMbusConfig mbusConfig, String identity) {
    }

    public static RPCNetworkParams asParameters(ContainerMbusConfig mbusConfig, SlobroksConfig slobroksConfig, String identity) {
        return NetworkMultiplexerProvider.asParameters(mbusConfig, identity).setSlobroksConfig(slobroksConfig);
    }

    private static RPCNetworkParams asParameters(ContainerMbusConfig mbusConfig, String identity) {
        return new RPCNetworkParams().setSlobrokConfigId(identity).setIdentity(new Identity(identity)).setListenPort(mbusConfig.port()).setNumTargetsPerSpec(mbusConfig.numconnectionspertarget()).setNumNetworkThreads(mbusConfig.numthreads()).setTransportEventsBeforeWakeup(mbusConfig.transport_events_before_wakeup()).setOptimization(RPCNetworkParams.Optimization.valueOf((String)mbusConfig.optimize_for().name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkMultiplexer net() {
        Object object = this.monitor;
        synchronized (object) {
            this.net = this.net != null ? this.net : this.nets.get();
            return this.net;
        }
    }
}

