/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc;

import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Reply;

public class StatusCodes {
    public static int fromMbusReply(Reply reply) {
        int statusCode = 200;
        int len = reply.getNumErrors();
        for (int i = 0; i < len; ++i) {
            statusCode = Math.max(statusCode, StatusCodes.fromMbusError(reply.getError(i)));
        }
        return statusCode;
    }

    public static int fromMbusError(Error error) {
        int errorCode = error.getCode();
        if (errorCode < 100000) {
            return 200;
        }
        if (errorCode < 200000) {
            return 307;
        }
        switch (errorCode) {
            case 200001: {
                return 423;
            }
            case 200002: {
                return 400;
            }
            case 200003: {
                return 404;
            }
            case 200005: {
                return 400;
            }
            case 200006: {
                return 400;
            }
            case 200007: {
                return 415;
            }
            case 200008: {
                return 415;
            }
            case 200009: {
                return 408;
            }
            case 200010: {
                return 505;
            }
            case 200011: {
                return 400;
            }
            case 200012: {
                return 423;
            }
            case 200013: {
                return 412;
            }
            case 200014: {
                return 412;
            }
            case 250000: {
                return 500;
            }
        }
        return 500;
    }

    public static Error toMbusError(int statusCode) {
        if (statusCode < 300) {
            return null;
        }
        if (statusCode < 400) {
            return new Error(150000, statusCode + " Redirection");
        }
        if (statusCode < 500) {
            return new Error(250000, statusCode + " Client Error");
        }
        if (statusCode < 600) {
            return new Error(250000, statusCode + " Server Error");
        }
        return new Error(250000, statusCode + " Unknown Error");
    }
}

