/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.messagebus;

import com.google.inject.Inject;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.jdisc.config.SessionConfig;
import com.yahoo.container.jdisc.messagebus.MbusServerProvider;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.jdisc.ReferencedResource;
import com.yahoo.messagebus.AllPassThrottlePolicy;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.jdisc.MbusClient;
import com.yahoo.messagebus.shared.ClientSession;
import com.yahoo.messagebus.shared.SharedSourceSession;

public class MbusClientProvider
implements Provider<MbusClient> {
    private final MbusClient client;

    private static MbusClient createSourceClient(SessionCache sessionCache, boolean setAllPassThrottlePolicy) {
        SourceSessionParams sourceSessionParams = new SourceSessionParams();
        if (setAllPassThrottlePolicy) {
            sourceSessionParams.setThrottlePolicy((ThrottlePolicy)new AllPassThrottlePolicy());
        }
        try (ReferencedResource<SharedSourceSession> ref = sessionCache.retainSource(sourceSessionParams);){
            MbusClient mbusClient = new MbusClient((ClientSession)ref.getResource());
            return mbusClient;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Inject
    public MbusClientProvider(SessionCache sessionCache, SessionConfig sessionConfig) {
        super();
        switch (1.$SwitchMap$com$yahoo$container$jdisc$config$SessionConfig$Type$Enum[sessionConfig.type().ordinal()]) {
            case 1: {
                intermediateSessionParams = MbusServerProvider.createIntermediateSessionParams(true, sessionConfig.name());
                ref = sessionCache.retainIntermediate(intermediateSessionParams);
                var5_5 = null;
                this.client = new MbusClient((ClientSession)ref.getResource());
                if (ref == null) break;
                if (var5_5 == null) ** GOTO lbl17
                try {
                    ref.close();
                }
                catch (Throwable var6_6) {
                    var5_5.addSuppressed(var6_6);
                }
                break;
lbl17:
                // 1 sources

                ref.close();
                break;
                catch (Throwable var6_7) {
                    try {
                        var5_5 = var6_7;
                        throw var6_7;
                    }
                    catch (Throwable var7_8) {
                        if (ref != null) {
                            if (var5_5 != null) {
                                try {
                                    ref.close();
                                }
                                catch (Throwable var8_9) {
                                    var5_5.addSuppressed(var8_9);
                                }
                            } else {
                                ref.close();
                            }
                        }
                        throw var7_8;
                    }
                }
            }
            case 2: {
                this.client = MbusClientProvider.createSourceClient(sessionCache, false);
                break;
            }
            case 3: {
                this.client = MbusClientProvider.createSourceClient(sessionCache, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown session type: " + (Object)sessionConfig.type());
            }
        }
    }

    public MbusClient get() {
        return this.client;
    }

    public void deconstruct() {
        this.client.release();
    }
}

